/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.Streams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;

public class LogForwarder
extends PayloadSender {
    private final URI LOG_API_URL = this.getCollectorURI();
    private final File file;

    public LogForwarder(File logDataFile, AgentConfiguration agentConfiguration) {
        super(logDataFile.getAbsolutePath().getBytes(StandardCharsets.UTF_8), agentConfiguration);
        this.file = logDataFile;
        this.payload.setPersisted(false);
    }

    @Override
    public PayloadSender call() throws Exception {
        if (this.shouldUploadOpportunistically()) {
            this.timer.tic();
            return super.call();
        }
        log.warn("LogForwarder: endpoint is not reachable. Will try later...");
        return this;
    }

    @Override
    public Payload getPayload() {
        try {
            return new Payload(Streams.readAllBytes(this.file));
        }
        catch (IOException e) {
            AgentLogManager.getAgentLog().error("LogForwarder: failed to get payload. " + e);
            return new Payload();
        }
    }

    @Override
    public void setPayload(byte[] payloadBytes) {
        this.file.delete();
        try (BufferedWriter writer = Streams.newBufferedFileWriter(this.file);){
            writer.write(new String(payloadBytes, StandardCharsets.UTF_8));
            writer.flush();
        }
        catch (IOException e) {
            AgentLogManager.getAgentLog().error("LogForwarder: failed to set payload. " + e);
        }
    }

    @Override
    public int getPayloadSize() {
        String logDataFile = new String(super.getPayload().getBytes(), StandardCharsets.UTF_8);
        try {
            return Math.toIntExact(new File(logDataFile).length());
        }
        catch (ArithmeticException arithmeticException) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    protected HttpURLConnection getConnection() throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)this.LOG_API_URL.toURL().openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("X-App-License-Key", this.agentConfiguration.getApplicationToken());
        connection.setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
        connection.setReadTimeout((int)TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        return connection;
    }

    @Override
    protected void onRequestResponse(HttpURLConnection connection) throws IOException {
        switch (connection.getResponseCode()) {
            case 200: 
            case 202: {
                StatsEngine.SUPPORTABILITY.sampleTimeMs("Supportability/AgentHealth/LogReporting/UploadTime", this.timer.toc());
                log.debug("LogForwarder: Log data forwarding took " + this.timer.duration() + "ms");
                int payloadSize = this.getPayloadSize();
                StatsEngine.SUPPORTABILITY.sample("Supportability/AgentHealth/LogReporting/Size/Uncompressed", payloadSize);
                log.info("LogForwarder: [" + payloadSize + "] bytes successfully submitted.");
                break;
            }
            case 408: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/UploadTimeOut");
                this.onFailedUpload("The request to submit the log data payload has timed out - (will try again later) - Response code [" + this.responseCode + "]");
                break;
            }
            case 413: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/UploadRejected");
                this.onFailedUpload("The request to rejected due to payload size limits - Response code [" + this.responseCode + "]");
                break;
            }
            case 429: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/UploadThrottled");
                this.onFailedUpload("Log upload requests have been throttled- (will try again later) - Response code [" + this.responseCode + "]");
                break;
            }
            case 500: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/Removed/Rejected");
                this.onFailedUpload("The log data was rejected and will be deleted - Response code " + connection.getResponseCode());
                break;
            }
            default: {
                this.onFailedUpload("Something went wrong while forwarding (will try again later) - Response code " + connection.getResponseCode());
            }
        }
        log.debug("Payload [" + this.file.getName() + "] delivery took " + this.timer.toc() + "ms");
    }

    @Override
    protected void onFailedUpload(String errorMsg) {
        log.error("LogForwarder: " + errorMsg);
        StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/FailedUpload");
    }

    @Override
    protected void onRequestException(Exception e) {
        this.onFailedUpload(e.toString());
    }

    @Override
    protected boolean shouldUploadOpportunistically() {
        try {
            String dest = this.LOG_API_URL.toURL().getHost();
            InetAddress inet = InetAddress.getByName(dest);
            return dest.equals(inet.getHostName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean shouldRetry() {
        return true;
    }

    URI getCollectorURI() {
        return URI.create("https://" + this.agentConfiguration.getCollectorHost() + "/mobile/logs");
    }
}

