/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.LogForwarder;
import com.newrelic.agent.android.logging.LogReporting;
import com.newrelic.agent.android.logging.LogReportingConfiguration;
import com.newrelic.agent.android.logging.Logger;
import com.newrelic.agent.android.logging.RemoteLogger;
import com.newrelic.agent.android.payload.PayloadReporter;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.Streams;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonSyntaxException;
import com.newrelic.com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LogReporter
extends PayloadReporter {
    protected static final Type gtype = new TypeToken<Map<String, Object>>(){}.getType();
    protected static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
    static int VORTEX_PAYLOAD_LIMIT = 1024000;
    static int MIN_PAYLOAD_THRESHOLD = -1;
    protected int payloadBudget = VORTEX_PAYLOAD_LIMIT;
    static final long LOG_ENDPOINT_TIMEOUT = 10L;
    static final String LOG_REPORTS_DIR = "newrelic/logreporting";
    static final String LOG_FILE_MASK = "logdata%s.%s";
    static final Pattern LOG_FILE_REGEX = Pattern.compile("^(?<path>.*\\/newrelic/logreporting)\\/(?<file>logdata.*)\\.(?<extension>.*)$");
    static final AtomicReference<LogReporter> instance = new AtomicReference<Object>(null);
    static final ReentrantLock workingFileLock = new ReentrantLock();
    static File logDataStore = new File(System.getProperty("java.io.tmpdir", "/tmp"), "newrelic/logreporting").getAbsoluteFile();
    protected long reportTTL = LogReportingConfiguration.DEFAULT_EXPIRATION_PERIOD;
    protected File workingLogFile;
    protected AtomicReference<BufferedWriter> workingLogFileWriter = new AtomicReference<Object>(null);

    public static LogReporter initialize(File rootDir, AgentConfiguration agentConfiguration) throws IOException {
        if (!(rootDir.isDirectory() && rootDir.exists() && rootDir.canWrite())) {
            throw new IOException("Reports directory [" + rootDir.getAbsolutePath() + "] must exist and be writable!");
        }
        logDataStore = new File(rootDir, LOG_REPORTS_DIR);
        logDataStore.mkdirs();
        if (!logDataStore.exists() || !logDataStore.canWrite()) {
            throw new IOException("LogReporter: Reports directory [" + rootDir.getAbsolutePath() + "] must exist and be writable!");
        }
        log.debug("LogReporting: saving log reports to " + logDataStore.getAbsolutePath());
        instance.set(new LogReporter(agentConfiguration));
        log.debug("LogReporting: reporter instance initialized");
        LogReporting.setLogger(new RemoteLogger());
        log.debug("LogReporting: logger has been set to " + LogReporting.getLogger().getClass().getSimpleName());
        StatsEngine.get().inc("Supportability/AgentHealth/LogReporting/Init");
        return instance.get();
    }

    public static LogReporter getInstance() {
        return instance.get();
    }

    public LogReporter(AgentConfiguration agentConfiguration) {
        super(agentConfiguration);
        this.setEnabled(agentConfiguration.getLogReportingConfiguration().getLoggingEnabled());
        try {
            this.resetWorkingLogFile();
        }
        catch (IOException e) {
            log.error("LogReporter error: " + e);
            this.setEnabled(false);
        }
    }

    @Override
    protected void start() {
        if (this.isEnabled()) {
            Harvest.addHarvestListener(instance.get());
            LogReportingConfiguration.reseed();
            this.isStarted.set(true);
        } else {
            log.error("Attempted to start the log reported when disabled.");
        }
    }

    @Override
    protected void stop() {
        Harvest.removeHarvestListener(instance.get());
        this.isStarted.set(false);
        if (this.isEnabled()) {
            this.onHarvestStop();
        }
        this.workingLogFileWriter.set(null);
    }

    @Override
    public void onHarvestStart() {
        Logger logger = LogReporting.getLogger();
        if (logger instanceof HarvestLifecycleAware) {
            ((HarvestLifecycleAware)((Object)logger)).onHarvestStart();
        }
        this.expire(Math.toIntExact(this.reportTTL));
        this.cleanup();
    }

    @Override
    public void onHarvestStop() {
        try {
            Logger logger = LogReporting.getLogger();
            if (logger instanceof HarvestLifecycleAware) {
                ((HarvestLifecycleAware)((Object)logger)).onHarvestStop();
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    @Override
    public void onHarvest() {
        File logReport;
        try {
            Logger logger = LogReporting.getLogger();
            if (logger instanceof HarvestLifecycleAware) {
                ((HarvestLifecycleAware)((Object)logger)).onHarvest();
            }
            workingFileLock.lock();
            this.workingLogFileWriter.get().flush();
            if (this.workingLogFile.length() > (long)MIN_PAYLOAD_THRESHOLD) {
                this.finalizeWorkingLogFile();
                this.rollWorkingLogFile();
            }
        }
        catch (IOException e) {
            log.error("LogReporter: " + e);
        }
        finally {
            workingFileLock.unlock();
        }
        if (this.isEnabled() && null != (logReport = this.rollupLogDataFiles()) && logReport.isFile()) {
            if (this.postLogReport(logReport)) {
                log.info("LogReporter: Uploaded remote log data [" + logReport.getName() + "]");
                this.safeDelete(logReport);
            } else {
                log.error("LogReporter: Upload failed for remote log data [" + logReport.getAbsoluteFile() + "]");
            }
        }
    }

    @Override
    public void onHarvestComplete() {
        Logger logger = LogReporting.getLogger();
        if (logger instanceof HarvestLifecycleAware) {
            ((HarvestLifecycleAware)((Object)logger)).onHarvestComplete();
        }
        this.getCachedLogReports(LogReportState.ROLLUP).forEach(logReport -> {
            if (this.postLogReport((File)logReport)) {
                log.info("LogReporter: Uploaded remote log data [" + logReport.getAbsolutePath() + "]");
                this.safeDelete((File)logReport);
            } else {
                log.error("LogReporter: Upload failed for remote log data [" + logReport.getAbsolutePath() + "]");
            }
        });
        this.expire(Math.toIntExact(this.reportTTL));
    }

    @Override
    public void onHarvestConfigurationChanged() {
        this.setEnabled(this.agentConfiguration.getLogReportingConfiguration().getLoggingEnabled());
        if (this.agentConfiguration.getLogReportingConfiguration().getExpirationPeriod() != this.reportTTL) {
            this.reportTTL = Math.max(this.agentConfiguration.getLogReportingConfiguration().getExpirationPeriod(), TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS));
            log.debug("LogReporter: logging configuration changed [" + this.agentConfiguration.getLogReportingConfiguration().toString() + "]");
        }
    }

    protected Set<File> getCachedLogReports(LogReportState state) {
        Set<File> reportSet = new HashSet<File>();
        try {
            String logFileMask = String.format(Locale.getDefault(), LOG_FILE_MASK, ".*", state.extension);
            reportSet = Streams.list(logDataStore).filter(file -> file.isFile() && file.getName().matches(logFileMask)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("LogReporter: Can't query cached log reports: " + e);
        }
        return reportSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File rollupLogDataFiles() {
        block18: {
            Set<File> logDataFiles = this.getCachedLogReports(LogReportState.CLOSED);
            int totalFileSize = logDataFiles.stream().mapToInt(file -> Math.toIntExact(file.length())).sum();
            if (MIN_PAYLOAD_THRESHOLD > totalFileSize) {
                if (!logDataFiles.isEmpty()) {
                    log.debug("LogReporter: buffering log data until the minimum threshold: " + totalFileSize + "/" + MIN_PAYLOAD_THRESHOLD + " bytes");
                }
                return null;
            }
            HashSet<File> mergedFiles = new HashSet<File>();
            int payloadSizeBudget = VORTEX_PAYLOAD_LIMIT;
            try {
                workingFileLock.lock();
                JsonArray jsonArray = new JsonArray();
                for (File file2 : logDataFiles) {
                    if (null == file2 || !file2.exists() || file2.length() <= 0L) continue;
                    try {
                        payloadSizeBudget = (int)((long)payloadSizeBudget - file2.length());
                        if (0 > payloadSizeBudget) break;
                        Streams.lines(file2).forEach(line -> {
                            if (!line.isEmpty()) {
                                try {
                                    JsonObject messageAsJson = gson.fromJson((String)line, JsonObject.class);
                                    jsonArray.add(messageAsJson);
                                }
                                catch (JsonSyntaxException e) {
                                    log.error("LogReporter: Invalid log record dropped: " + line);
                                }
                            }
                        });
                        mergedFiles.add(file2);
                    }
                    catch (Exception e) {
                        log.error("LogReporter: " + e.toString());
                    }
                }
                if (jsonArray.size() <= 0) break block18;
                File archivedLogFile = new File(logDataStore, String.format(Locale.getDefault(), LOG_FILE_MASK, System.currentTimeMillis(), LogReportState.ROLLUP.extension));
                archivedLogFile.mkdirs();
                archivedLogFile.delete();
                archivedLogFile.createNewFile();
                try (BufferedWriter writer = Streams.newBufferedFileWriter(archivedLogFile);){
                    writer.write(jsonArray.toString());
                    writer.flush();
                    writer.close();
                    archivedLogFile.setReadOnly();
                }
                catch (Exception e) {
                    log.error("Log file rollup failed: " + e);
                }
                mergedFiles.forEach(file -> this.safeDelete((File)file));
                File file3 = archivedLogFile;
                return file3;
            }
            catch (IOException e) {
                log.error(e.toString());
            }
            finally {
                workingFileLock.unlock();
            }
        }
        return null;
    }

    boolean postLogReport(File logDataFile) {
        try {
            if (logDataFile.exists()) {
                if (!this.isLogfileTypeOf(logDataFile, LogReportState.ROLLUP)) {
                    logDataFile = this.rollupLogDataFiles();
                }
                if (logDataFile.exists() && this.isLogfileTypeOf(logDataFile, LogReportState.ROLLUP)) {
                    LogForwarder logForwarder = new LogForwarder(logDataFile, this.agentConfiguration);
                    switch (logForwarder.call().getResponseCode()) {
                        case 408: {
                            break;
                        }
                        case 413: {
                            break;
                        }
                        case 429: {
                            break;
                        }
                        case 500: {
                            break;
                        }
                    }
                    return logForwarder.isSuccessfulResponse();
                }
            } else {
                log.warn("LogReporter: Logfile [" + logDataFile.getName() + "] vanished before it could be uploaded.");
            }
        }
        catch (Exception e) {
            AgentLogManager.getAgentLog().error("LogReporter: Log upload failed: " + e);
        }
        return false;
    }

    void safeDelete(File fileToDelete) {
        if (!this.isLogfileTypeOf(fileToDelete, LogReportState.EXPIRED)) {
            fileToDelete.setReadOnly();
            fileToDelete.renameTo(new File(fileToDelete.getAbsolutePath() + LogReportState.EXPIRED.asExtension()));
        }
    }

    File getWorkingLogfile() throws IOException {
        File logFile = new File(logDataStore, String.format(Locale.getDefault(), LOG_FILE_MASK, "", LogReportState.WORKING.extension));
        logFile.getParentFile().mkdirs();
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
        logFile.setLastModified(System.currentTimeMillis());
        return logFile;
    }

    File rollLogfile(File workingLogFile) throws IOException {
        File closedLogFile;
        int retries = 5;
        while ((closedLogFile = new File(logDataStore, String.format(Locale.getDefault(), LOG_FILE_MASK, System.currentTimeMillis(), LogReportState.CLOSED.extension))).exists() && 0L < closedLogFile.length() && retries-- > 0) {
        }
        workingLogFile.renameTo(closedLogFile);
        closedLogFile.setLastModified(System.currentTimeMillis());
        return closedLogFile;
    }

    Set<File> expire(long expirationTTL) {
        FileFilter expirationFilter = logReport -> logReport.exists() && this.isLogfileTypeOf(logReport, LogReportState.WORKING) && logReport.lastModified() + expirationTTL < System.currentTimeMillis();
        Set<File> expiredFiles = Streams.list(logDataStore, expirationFilter).collect(Collectors.toSet());
        expiredFiles.forEach(logReport -> {
            StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/Expired");
            log.debug("LogReporter: Remote log data [" + logReport.getName() + "] has expired and will be removed.");
            this.safeDelete((File)logReport);
        });
        return expiredFiles;
    }

    Set<File> cleanup() {
        Set<File> expiredFiles = this.getCachedLogReports(LogReportState.EXPIRED);
        expiredFiles.forEach(logReport -> {
            if (logReport.delete()) {
                log.debug("LogReporter: Log data [" + logReport.getName() + "] removed.");
            } else {
                log.warn("LogReporter: Log data [" + logReport.getName() + "] not removed!");
            }
        });
        return expiredFiles;
    }

    Set<File> recover() {
        Set<File> recoveredFiles = this.getCachedLogReports(LogReportState.EXPIRED);
        recoveredFiles.forEach(logReport -> {
            logReport.setWritable(true);
            logReport.renameTo(new File(logReport.getAbsolutePath().replace(LogReportState.EXPIRED.asExtension(), "")));
        });
        return recoveredFiles;
    }

    void finalizeWorkingLogFile() {
        try {
            workingFileLock.lock();
            this.workingLogFileWriter.get().flush();
            this.workingLogFileWriter.get().close();
            this.workingLogFileWriter.set(null);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        finally {
            workingFileLock.unlock();
        }
    }

    File rollWorkingLogFile() throws IOException {
        File closedLogFile;
        try {
            workingFileLock.lock();
            closedLogFile = this.rollLogfile(this.workingLogFile);
            this.workingLogFile = this.getWorkingLogfile();
            this.resetWorkingLogFile();
            if (AgentConfiguration.getInstance().getLogReportingConfiguration().isSampled()) {
                closedLogFile.setReadOnly();
            } else {
                closedLogFile.delete();
            }
            log.debug("LogReporter: Finalized log data to [" + closedLogFile.getAbsolutePath() + "]");
        }
        finally {
            workingFileLock.unlock();
        }
        return closedLogFile;
    }

    BufferedWriter resetWorkingLogFile() throws IOException {
        this.workingLogFile = this.getWorkingLogfile();
        this.workingLogFileWriter.set(new BufferedWriter(new FileWriter(this.workingLogFile, true)));
        this.payloadBudget = VORTEX_PAYLOAD_LIMIT;
        return this.workingLogFileWriter.get();
    }

    public void appendToWorkingLogFile(Map<String, Object> logDataMap) throws IOException {
        try {
            String logJsonData = gson.toJson(logDataMap, gtype);
            workingFileLock.lock();
            if (null != this.workingLogFileWriter.get()) {
                this.payloadBudget -= logJsonData.length() + System.lineSeparator().length();
                if (0 > this.payloadBudget) {
                    this.finalizeWorkingLogFile();
                    this.rollWorkingLogFile();
                }
                this.workingLogFileWriter.get().append(logJsonData);
                this.workingLogFileWriter.get().newLine();
            }
        }
        finally {
            workingFileLock.unlock();
        }
    }

    void shutdown() {
        if (this.isStarted.get()) {
            this.stop();
        }
        log.info("LogReporting: reporter instance has been shutdown");
    }

    Map<String, String> logFileNameAsParts(File logDataFile) {
        HashMap<String, String> parts = new HashMap<String, String>();
        Matcher matcher = LOG_FILE_REGEX.matcher(logDataFile.getAbsolutePath());
        if (matcher.matches()) {
            if (3 > matcher.groupCount()) {
                log.error("LogReporter: Couldn't determine log filename components. " + logDataFile.getAbsolutePath());
            } else {
                parts.put("path", matcher.group(1));
                parts.put("file", matcher.group(2));
                parts.put("extension", matcher.group(3));
            }
        }
        return parts;
    }

    boolean isLogfileTypeOf(File logDatafile, LogReportState state) {
        return this.logFileNameAsParts(logDatafile).getOrDefault("extension", "").equals(state.extension);
    }

    LogReportState typeOfLogfile(File logDatafile) throws IOException {
        String extension = this.logFileNameAsParts(logDatafile).getOrDefault("extension", "");
        if (null == extension || extension.isEmpty()) {
            throw new IOException("LogReporter:  Could not parse the log file name. " + logDatafile.getAbsolutePath());
        }
        return Arrays.stream(LogReportState.values()).filter(logReportState -> logReportState.extension.equals(extension)).findFirst().get();
    }

    static enum LogReportState {
        WORKING("tmp"),
        CLOSED("dat"),
        EXPIRED("bak"),
        ROLLUP("rollup"),
        ALL(".*");

        final String extension;

        private LogReportState(String extension) {
            this.extension = extension;
        }

        public String asExtension() {
            return String.format(Locale.getDefault(), ".%s", this.extension);
        }
    }
}

