/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.LogLevel;
import com.newrelic.agent.android.logging.LogReporter;
import com.newrelic.agent.android.logging.Logger;
import com.newrelic.agent.android.logging.MessageValidator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public abstract class LogReporting {
    public static final String INVALID_MSG = "<invalid message>";
    protected static final String LOG_TIMESTAMP_ATTRIBUTE = "timestamp";
    protected static final String LOG_LEVEL_ATTRIBUTE = "level";
    protected static final String LOG_MESSAGE_ATTRIBUTE = "message";
    protected static final String LOG_ATTRIBUTES_ATTRIBUTE = "attributes";
    protected static final String LOG_ENTITY_ATTRIBUTE = "entity.guid";
    protected static final String LOG_LOGGER_ATTRIBUTE = "logger";
    protected static final String LOG_ERROR_MESSAGE_ATTRIBUTE = "error.message";
    protected static final String LOG_ERROR_STACK_ATTRIBUTE = "error.stack";
    protected static final String LOG_ERROR_CLASS_ATTRIBUTE = "error.class";
    protected static LogLevel logLevel = LogLevel.WARN;
    protected static AgentLogger agentLogger = new AgentLogger();
    protected static AtomicReference<Logger> instance = new AtomicReference<AgentLogger>(agentLogger);
    public static MessageValidator validator = new MessageValidator(){};

    public static void initialize(File cacheDir, AgentConfiguration agentConfiguration) throws IOException {
        LogReporting.setLogLevel(agentConfiguration.getLogReportingConfiguration().getLogLevel());
        LogReporter.initialize(cacheDir, agentConfiguration);
        if (LogReporter.getInstance().isEnabled()) {
            LogReporter.getInstance().start();
        }
        if (!LogReporter.getInstance().isStarted()) {
            agentLogger.log(LogLevel.ERROR, "LogReporting failed to initialize!");
        }
    }

    public static Logger getLogger() {
        return instance.get();
    }

    public static Logger setLogger(Logger logger) {
        instance.set(logger);
        return instance.get();
    }

    static LogLevel getLogLevel() {
        return logLevel;
    }

    static int getLogLevelAsInt() {
        return logLevel.ordinal();
    }

    public static void setLogLevel(String logLevelAsString) {
        LogReporting.setLogLevel(LogLevel.valueOf(logLevelAsString.toUpperCase()));
    }

    static void setLogLevel(int logLevelAsValue) {
        logLevel = LogLevel.levels[logLevelAsValue];
    }

    public static void setLogLevel(LogLevel level) {
        logLevel = level;
    }

    public static boolean isLevelEnabled(LogLevel level) {
        return LogReporting.logLevel.value >= level.value;
    }

    public static boolean isRemoteLoggingEnabled() {
        return FeatureFlag.featureEnabled(FeatureFlag.LogReporting) && LogLevel.NONE != LogReporting.getLogLevel();
    }

    protected static Map<String, Object> validateLogData(MessageValidator validator, Map<String, Object> logDataMap) {
        if (null != logDataMap) {
            logDataMap.forEach((key, value) -> {
                if (value instanceof String) {
                    // empty if block
                }
            });
        }
        return logDataMap;
    }

    protected Map<String, Object> decorateLogData(MessageValidator validator, Map<String, Object> logDataMap) {
        return logDataMap;
    }

    public static class AgentLogger
    implements Logger {
        MessageValidator validator = new MessageValidator(){};

        public void logToAgent(LogLevel level, String message) {
            message = this.validator.validate(message);
            AgentLog agentLog = AgentLogManager.getAgentLog();
            switch (level) {
                case ERROR: {
                    agentLog.error(message);
                    break;
                }
                case WARN: {
                    agentLog.warn(message);
                    break;
                }
                case INFO: {
                    agentLog.info(message);
                    break;
                }
                case VERBOSE: {
                    agentLog.verbose(message);
                    break;
                }
                case DEBUG: {
                    agentLog.debug(message);
                }
            }
        }

        @Override
        public void log(LogLevel logLevel, String message) {
            this.logToAgent(logLevel, message);
        }

        @Override
        public void logThrowable(LogLevel logLevel, String message, Throwable throwable) {
            StringWriter sw = new StringWriter();
            message = this.validator.validate(message);
            throwable = this.validator.validate(throwable);
            throwable.printStackTrace(new PrintWriter(sw));
            this.logToAgent(logLevel, String.format(Locale.getDefault(), "%s: %s", message, sw.toString()));
        }

        @Override
        public void logAttributes(Map<String, Object> attributes) {
            attributes = this.validator.validate(attributes);
            String logLevel = (String)attributes.getOrDefault(LogReporting.LOG_LEVEL_ATTRIBUTE, LogLevel.INFO.name());
            Map<String, Object> finalAttributes = attributes;
            String mapAsString = attributes.keySet().stream().map(key -> key + "=" + finalAttributes.get(key)).collect(Collectors.joining(",", "{", "}"));
            this.logToAgent(LogLevel.valueOf(logLevel.toUpperCase()), String.format(Locale.getDefault(), "%s: %s", "newrelic", mapAsString));
        }

        @Override
        public void logAll(Throwable throwable, Map<String, Object> attributes) {
            attributes = this.validator.validate(attributes);
            String logLevel = (String)attributes.getOrDefault(LogReporting.LOG_LEVEL_ATTRIBUTE, LogLevel.INFO.name());
            StringWriter sw = new StringWriter();
            Map<String, Object> finalAttributes = attributes;
            String mapAsString = finalAttributes.keySet().stream().map(key -> key + "=" + finalAttributes.get(key)).collect(Collectors.joining(",", "{", "}"));
            throwable = this.validator.validate(throwable);
            throwable.printStackTrace(new PrintWriter(sw));
            this.logToAgent(LogLevel.valueOf(logLevel.toUpperCase()), String.format(Locale.getDefault(), "%s: %s %s", "newrelic", sw.toString(), mapAsString));
        }
    }
}

