/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.logging.LogLevel;
import java.util.HashMap;
import java.util.Map;

public interface MessageValidator {
    public static final String INVALID_KEYSET = "{}\\[\\]]";
    public static final String[] ANONYMIZATION_TARGETS = new String[]{"http?//{.*}/{.*}", "{.*}\\@{.*}\\.{.*}"};

    default public String validate(String message) {
        return null == message || message.isEmpty() ? "<invalid message>" : message;
    }

    default public Map<String, Object> validate(Map<String, Object> attributes) {
        if (null == attributes) {
            attributes = new HashMap<String, Object>();
        }
        if (!attributes.containsKey("message")) {
            attributes.put("message", "<invalid message>");
        }
        if (!attributes.containsKey("level")) {
            attributes.put("level", LogLevel.INFO.name());
        }
        return attributes;
    }

    default public Throwable validate(Throwable throwable) {
        return null != throwable ? throwable : new IllegalArgumentException();
    }

    default public Map<String, Object> anonymize(Map<String, Object> attributes) {
        attributes = this.validate(attributes);
        return attributes;
    }
}

