/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.harvest.HarvestLifecycleAware;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.LogLevel;
import com.newrelic.agent.android.logging.LogReporter;
import com.newrelic.agent.android.logging.LogReporting;
import com.newrelic.agent.android.logging.Logger;
import com.newrelic.agent.android.logging.MessageValidator;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RemoteLogger
implements HarvestLifecycleAware,
Logger {
    static int POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors() / 4);
    static long QUEUE_THREAD_TTL = 1000L;
    static MessageValidator validator = LogReporting.validator;
    static int MAX_ATTRIBUTES_PER_EVENT = 255;
    static int MAX_ATTRIBUTES_NAME_SIZE = 255;
    static int MAX_ATTRIBUTES_VALUE_SIZE = 4096;
    protected ThreadPoolExecutor executor = new ThreadPoolExecutor(2, POOL_SIZE, QUEUE_THREAD_TTL, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("LogReporting"));

    public RemoteLogger() {
        this.executor.allowCoreThreadTimeOut(true);
        this.executor.prestartCoreThread();
    }

    @Override
    public void log(LogLevel logLevel, String message) {
        if (this.isLevelEnabled(logLevel)) {
            message = validator.validate(message);
            this.appendToWorkingLogFile(logLevel, message, null, null);
        }
    }

    @Override
    public void logThrowable(LogLevel logLevel, String message, Throwable throwable) {
        if (this.isLevelEnabled(logLevel)) {
            throwable = validator.validate(throwable);
            this.appendToWorkingLogFile(logLevel, message, throwable, null);
        }
    }

    @Override
    public void logAttributes(Map<String, Object> attributes) {
        String level = (String)(attributes = validator.validate(attributes)).getOrDefault("level", LogLevel.INFO.name());
        LogLevel logLevel = LogLevel.valueOf(level.toUpperCase());
        if (this.isLevelEnabled(logLevel)) {
            String message = attributes.getOrDefault("message", null);
            this.appendToWorkingLogFile(logLevel, message, null, attributes);
        }
    }

    @Override
    public void logAll(Throwable throwable, Map<String, Object> attributes) {
        String level = (String)(attributes = validator.validate(attributes)).getOrDefault("level", LogLevel.INFO.name());
        LogLevel logLevel = LogLevel.valueOf(level.toUpperCase());
        if (this.isLevelEnabled(logLevel)) {
            String message = attributes.getOrDefault("message", null);
            message = validator.validate(message);
            this.appendToWorkingLogFile(LogLevel.valueOf(level.toUpperCase()), message, throwable, attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToWorkingLogFile(LogLevel logLevel, String message, Throwable throwable, Map<String, Object> attributes) {
        if (!LogReporting.isRemoteLoggingEnabled() || !this.isLevelEnabled(logLevel)) {
            return;
        }
        if (!AgentConfiguration.getInstance().getLogReportingConfiguration().isSampled()) {
            return;
        }
        if ((null == message || message.isEmpty()) && null == throwable && (null == attributes || attributes.isEmpty())) {
            return;
        }
        LogReporter logReporter = LogReporter.getInstance();
        Callable<Boolean> callable = () -> {
            HashMap<String, Object> logDataMap = new HashMap<String, Object>();
            try {
                logDataMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
                logDataMap.put("level", logLevel.name().toUpperCase());
                logDataMap.putAll(RemoteLogger.getCommonBlockAttributes());
                if (message != null) {
                    logDataMap.put("message", message);
                }
                if (throwable != null) {
                    logDataMap.put("error.message", throwable.toString());
                    logDataMap.put("error.stack", throwable.getStackTrace()[0].toString());
                    logDataMap.put("error.class", throwable.getClass().getSimpleName());
                }
                if (attributes != null) {
                    logDataMap.put("attributes", attributes);
                }
                if (null == logReporter) {
                    Boolean bl = false;
                    return bl;
                }
                logReporter.appendToWorkingLogFile(logDataMap);
            }
            catch (IOException e) {
                AgentLogManager.getAgentLog().error("Error recording log message: " + e.toString());
                if (this.executor.isTerminating() || this.executor.isShutdown() || null != logReporter.resetWorkingLogFile()) {
                    // empty if block
                }
                Boolean bl = false;
                return bl;
            }
            finally {
                ThreadPoolExecutor threadPoolExecutor = this.executor;
                synchronized (threadPoolExecutor) {
                    this.executor.notify();
                }
            }
            return true;
        };
        if (this.executor.isTerminating() || this.executor.isShutdown()) {
            try {
                callable.call();
            }
            catch (Exception e) {
                AgentLogManager.getAgentLog().error(e.toString());
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            this.executor.submit(callable);
        }
    }

    @Override
    public void onHarvest() {
        this.flush();
    }

    @Override
    public void onHarvestStop() {
        try {
            this.onHarvest();
        }
        catch (Exception e) {
            AgentLogManager.getAgentLog().error(e.toString());
        }
    }

    private int getPendingTaskCount() {
        return this.executor.getQueue().size() + this.executor.getActiveCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            try {
                while (this.getPendingTaskCount() > 0 && !this.executor.isTerminating() && !this.executor.isTerminated()) {
                    this.executor.wait(QUEUE_THREAD_TTL, 0);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    static Map<String, Object> getCommonBlockAttributes() {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("timestamp", System.currentTimeMillis());
        attrs.put("entity.guid", AgentConfiguration.getInstance().getEntityGuid());
        return attrs;
    }
}

