/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.ndk;

import android.content.Context;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.NewRelic;
import com.newrelic.agent.android.agentdata.AgentDataController;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashReporter;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.ndk.AgentNDK;
import com.newrelic.agent.android.ndk.AgentNDKListener;
import com.newrelic.agent.android.ndk.NativeCrash;
import com.newrelic.agent.android.ndk.NativeException;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class NativeReporting
extends HarvestAdapter
implements AgentNDKListener {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected static AtomicReference<NativeReporting> instance = new AtomicReference<Object>(null);

    public static NativeReporting getInstance() {
        return instance.get();
    }

    public static NativeReporting initialize(Context context, AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new NativeReporting(context, agentConfiguration));
        Harvest.addHarvestListener(instance.get());
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Init");
        return instance.get();
    }

    public static void shutdown() {
        if (NativeReporting.isInitialized()) {
            Harvest.removeHarvestListener(instance.get());
            instance.get().stop();
        }
        instance.set(null);
    }

    public static boolean isInitialized() {
        return instance.get() != null && AgentNDK.getInstance() != null;
    }

    public static void crashNow(String message) {
        if (NativeReporting.isInitialized()) {
            AgentNDK.getInstance().crashNow(message);
        }
    }

    public static boolean isRooted() {
        boolean isRooted = false;
        if (NativeReporting.isInitialized()) {
            StatsEngine.get().inc("Supportability/Mobile/Android/NDK/RootedDevice");
            isRooted = AgentNDK.getInstance().isRooted();
        }
        return isRooted;
    }

    NativeReporting(Context context, AgentConfiguration agentConfiguration) {
        AgentNDK.Builder builder = new AgentNDK.Builder(context);
        builder.withBuildId(Agent.getBuildId()).withANRMonitor(!agentConfiguration.getApplicationExitConfiguration().isEnabled()).withSessionId(agentConfiguration.getSessionID()).withReportListener((AgentNDKListener)this).withLogger(log).build();
    }

    public void start() {
        if (NativeReporting.isInitialized()) {
            AgentNDK.getInstance().start();
            StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Start");
            boolean isRooted = NativeReporting.isRooted();
            if (isRooted) {
                NewRelic.setAttribute("RootedDevice", isRooted);
            }
        } else {
            log.error("CrashReporter: Must first initialize native module.");
        }
    }

    void stop() {
        if (NativeReporting.isInitialized()) {
            AgentNDK.getInstance().stop();
            StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Stop");
        }
    }

    public boolean onNativeCrash(String crashAsString) {
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/NativeCrash");
        final AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
        HashSet<AnalyticsAttribute> sessionAttributes = new HashSet<AnalyticsAttribute>(){
            {
                this.addAll(analyticsController.getSessionAttributes());
            }
        };
        NativeCrashException exceptionToHandle = new NativeCrashException(crashAsString);
        sessionAttributes.add(new AnalyticsAttribute("platform", "native"));
        sessionAttributes.add(new AnalyticsAttribute("nativeCrash", true));
        sessionAttributes.add(new AnalyticsAttribute("exceptionMessage", exceptionToHandle.getNativeStackTrace().getExceptionMessage()));
        sessionAttributes.add(new AnalyticsAttribute("crashingThreadId", exceptionToHandle.getNativeStackTrace().getCrashedThread().getThreadId()));
        NativeCrash crash = new NativeCrash((NativeException)exceptionToHandle, (Set)sessionAttributes, analyticsController.getEventManager().getQueuedEvents());
        CrashReporter.getInstance().storeAndReportCrash((Crash)crash);
        return true;
    }

    public boolean onNativeException(String exceptionAsString) {
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/NativeException");
        HashMap<String, Object> exceptionAttributes = new HashMap<String, Object>(){
            {
                this.put("platform", "native");
                this.put("unhandledNativeException", true);
            }
        };
        NativeUnhandledException exceptionToHandle = new NativeUnhandledException(exceptionAsString);
        exceptionAttributes.put("crashingThreadId", exceptionToHandle.getNativeStackTrace().getCrashedThread().getThreadId());
        exceptionAttributes.put("nativeThreads", exceptionToHandle.getNativeStackTrace().getThreads());
        exceptionAttributes.put("exceptionMessage", exceptionToHandle.getNativeStackTrace().getExceptionMessage());
        return AgentDataController.sendAgentData((Throwable)((Object)exceptionToHandle), (Map<String, Object>)exceptionAttributes);
    }

    public boolean onApplicationNotResponding(String anrAsString) {
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/ANR");
        HashMap<String, Object> exceptionAttributes = new HashMap<String, Object>(){
            {
                this.put("platform", "native");
                this.put("ANR", true);
            }
        };
        ANRException exceptionToHandle = new ANRException(anrAsString);
        exceptionAttributes.put("crashingThreadId", exceptionToHandle.getNativeStackTrace().getCrashedThread().getThreadId());
        exceptionAttributes.put("nativeThreads", exceptionToHandle.getNativeStackTrace().getThreads());
        exceptionAttributes.put("exceptionMessage", exceptionToHandle.getNativeStackTrace().getExceptionMessage());
        return AgentDataController.sendAgentData((Throwable)((Object)exceptionToHandle), (Map<String, Object>)exceptionAttributes);
    }

    @Override
    public void onHarvestStart() {
        AgentNDK.getInstance().flushPendingReports();
        StatsEngine.get().inc("Supportability/Mobile/Android/NDK/Reports/Flush");
    }

    static class ANRException
    extends NativeException {
        public ANRException(String anrAsString) {
            super(anrAsString);
        }
    }

    static class NativeUnhandledException
    extends NativeException {
        public NativeUnhandledException(String exceptionAsString) {
            super(exceptionAsString);
        }
    }

    static class NativeCrashException
    extends NativeException {
        public NativeCrashException(String crashAsString) {
            super(crashAsString);
        }
    }
}

