/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.os.Build;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.analytics.AnalyticsEventCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.Streams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;

public class ApplicationExitMonitor {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    protected final String packageName;
    protected final File reportsDir;
    protected ActivityManager am;

    public ApplicationExitMonitor(Context context) {
        this.reportsDir = new File(context.getCacheDir(), "newrelic/applicationExitInfo");
        this.am = (ActivityManager)context.getSystemService("activity");
        this.packageName = context.getPackageName();
        this.reportsDir.mkdirs();
    }

    @SuppressLint(value={"SwitchIntDef"})
    protected void harvestApplicationExitInfo() {
        if (Build.VERSION.SDK_INT >= 30) {
            boolean eventsAdded = false;
            int recordsVisited = 0;
            int recordsSkipped = 0;
            if (null == this.am) {
                log.error("harvestApplicationExitInfo: ActivityManager is null!");
                return;
            }
            List applicationExitInfos = this.am.getHistoricalProcessExitReasons(this.packageName, 0, 0);
            for (ApplicationExitInfo exitInfo : applicationExitInfos) {
                File artifact = new File(this.reportsDir, "app-exit-" + exitInfo.getPid() + ".log");
                if (artifact.exists() && artifact.length() > 0L) {
                    log.debug("ApplicationExitMonitor: skipping exit info for pid[" + exitInfo.getPid() + "]: already recorded.");
                    ++recordsSkipped;
                } else {
                    String traceReport = exitInfo.toString();
                    if (artifact.exists() && artifact.length() == 0L) {
                        artifact.delete();
                    }
                    try (FileOutputStream artifactOs = new FileOutputStream(artifact, false);){
                        if (null != exitInfo.getTraceInputStream()) {
                            try (InputStream traceIs = exitInfo.getTraceInputStream();){
                                traceReport = Streams.slurpString(traceIs);
                            }
                            catch (IOException e) {
                                log.info("ApplicationExitMonitor: " + e);
                            }
                        }
                        ((OutputStream)artifactOs).write(traceReport.getBytes(StandardCharsets.UTF_8));
                        artifactOs.flush();
                        ((OutputStream)artifactOs).close();
                        artifact.setReadOnly();
                        ++recordsVisited;
                    }
                    catch (IOException e) {
                        log.debug("harvestApplicationExitInfo: AppExitInfo artifact error. " + e);
                    }
                    HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
                    eventAttributes.put("exitTimestamp", exitInfo.getTimestamp());
                    eventAttributes.put("reason", exitInfo.getReason());
                    eventAttributes.put("importance", exitInfo.getImportance());
                    eventAttributes.put("importanceAsString", this.getImportanceAsString(exitInfo.getImportance()));
                    eventAttributes.put("description", this.toValidAttributeValue(exitInfo.getDescription()));
                    eventAttributes.put("processName", this.toValidAttributeValue(exitInfo.getProcessName()));
                    switch (exitInfo.getImportance()) {
                        case 100: 
                        case 125: 
                        case 130: 
                        case 150: 
                        case 200: 
                        case 230: 
                        case 325: {
                            eventAttributes.put("appState", "foreground");
                            break;
                        }
                        default: {
                            eventAttributes.put("appState", "background");
                        }
                    }
                    eventsAdded |= AnalyticsControllerImpl.getInstance().internalRecordEvent(this.packageName, AnalyticsEventCategory.ApplicationExit, "MobileApplicationExit", eventAttributes);
                    StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/status/" + exitInfo.getStatus());
                    StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/reason/" + this.getReasonAsString(exitInfo.getReason()));
                    StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/importance/" + this.getImportanceAsString(exitInfo.getImportance()));
                    StatsEngine.SUPPORTABILITY.sample("Supportability/AgentHealth/ApplicationExitInfo/visited", recordsVisited);
                    StatsEngine.SUPPORTABILITY.sample("Supportability/AgentHealth/ApplicationExitInfo/skipped", recordsSkipped);
                }
                log.debug("AEI: inspected " + applicationExitInfos.size() + " records: new[" + recordsVisited + "] existing [" + recordsSkipped + "]");
            }
            if (eventsAdded) {
                AnalyticsControllerImpl.getInstance().getEventManager().setTransmitRequired();
            }
        } else {
            log.warn("ApplicationExitMonitor: exit info reporting was enabled, but not supported by the current OS");
            StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/unsupportedOS/" + Build.VERSION.SDK_INT);
        }
    }

    protected String toValidAttributeValue(String attributeValue) {
        return null == attributeValue ? "null" : attributeValue.substring(0, Math.min(attributeValue.length(), 4095));
    }

    protected String getImportanceAsString(int importance) {
        String importanceAsString = String.valueOf(importance);
        switch (importance) {
            case 100: {
                importanceAsString = "Foreground";
                break;
            }
            case 125: {
                importanceAsString = "Foreground service";
                break;
            }
            case 325: {
                importanceAsString = "Top sleeping";
                break;
            }
            case 200: {
                importanceAsString = "Visible";
                break;
            }
            case 230: {
                importanceAsString = "Perceptible";
                break;
            }
            case 350: {
                importanceAsString = "Can't save state";
                break;
            }
            case 300: {
                importanceAsString = "Service";
                break;
            }
            case 400: {
                importanceAsString = "Cached";
                break;
            }
            case 1000: {
                importanceAsString = "Gone";
            }
        }
        return importanceAsString;
    }

    protected String getReasonAsString(int reason) {
        String reasonAsString = String.valueOf(reason);
        switch (reason) {
            case 0: {
                reasonAsString = "Unknown";
                break;
            }
            case 1: {
                reasonAsString = "Exit self";
                break;
            }
            case 2: {
                reasonAsString = "Signaled";
                break;
            }
            case 3: {
                reasonAsString = "Low memory";
                break;
            }
            case 4: {
                reasonAsString = "Crash";
                break;
            }
            case 5: {
                reasonAsString = "Native crash";
                break;
            }
            case 6: {
                reasonAsString = "ANR";
                break;
            }
            case 7: {
                reasonAsString = "Initialization failure";
                break;
            }
            case 8: {
                reasonAsString = "Permission change";
                break;
            }
            case 9: {
                reasonAsString = "Excessive resource usage";
                break;
            }
            case 10: {
                reasonAsString = "User requested";
                break;
            }
            case 11: {
                reasonAsString = "User stopped";
                break;
            }
            case 12: {
                reasonAsString = "Dependency died";
                break;
            }
            case 13: {
                reasonAsString = "Other";
                break;
            }
            case 14: {
                reasonAsString = "Freezer";
                break;
            }
            case 15: {
                reasonAsString = "Package state changed";
                break;
            }
            case 16: {
                reasonAsString = "Package updated";
            }
        }
        return reasonAsString;
    }
}

