/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.activity.MeasuredActivity;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.HttpTransactionMeasurement;
import com.newrelic.agent.android.measurement.MeasurementEngine;
import com.newrelic.agent.android.measurement.consumer.ActivityMeasurementConsumer;
import com.newrelic.agent.android.measurement.consumer.CustomMetricMeasurementConsumer;
import com.newrelic.agent.android.measurement.consumer.HttpTransactionMeasurementConsumer;
import com.newrelic.agent.android.measurement.consumer.MeasurementConsumer;
import com.newrelic.agent.android.measurement.consumer.MethodMeasurementConsumer;
import com.newrelic.agent.android.measurement.consumer.SummaryMetricMeasurementConsumer;
import com.newrelic.agent.android.measurement.producer.ActivityMeasurementProducer;
import com.newrelic.agent.android.measurement.producer.CustomMetricMeasurementProducer;
import com.newrelic.agent.android.measurement.producer.MeasurementProducer;
import com.newrelic.agent.android.measurement.producer.MethodMeasurementProducer;
import com.newrelic.agent.android.measurement.producer.NetworkMeasurementProducer;
import com.newrelic.agent.android.metric.MetricUnit;
import com.newrelic.agent.android.tracing.Trace;

public class Measurements {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    protected static final MeasurementEngine measurementEngine = new MeasurementEngine();
    private static final NetworkMeasurementProducer networkMeasurementProducer = new NetworkMeasurementProducer();
    private static final ActivityMeasurementProducer activityMeasurementProducer = new ActivityMeasurementProducer();
    private static final MethodMeasurementProducer methodMeasurementProducer = new MethodMeasurementProducer();
    private static final CustomMetricMeasurementProducer customMetricMeasurementProducer = new CustomMetricMeasurementProducer();
    private static final HttpTransactionMeasurementConsumer httpTransactionHarvester = new HttpTransactionMeasurementConsumer();
    private static final ActivityMeasurementConsumer activityConsumer = new ActivityMeasurementConsumer();
    private static final MethodMeasurementConsumer methodMeasurementConsumer = new MethodMeasurementConsumer();
    private static final CustomMetricMeasurementConsumer customMetricMeasurementConsumer = new CustomMetricMeasurementConsumer();
    private static final SummaryMetricMeasurementConsumer summaryMetricMeasurementConsumer = new SummaryMetricMeasurementConsumer();
    private static boolean broadcastNewMeasurements = true;

    public static void initialize() {
        log.info("Measurement Engine initialized.");
        TaskQueue.start();
        Measurements.addMeasurementProducer(measurementEngine.getRootMeasurementPool());
        Measurements.addMeasurementProducer(networkMeasurementProducer);
        Measurements.addMeasurementProducer(activityMeasurementProducer);
        Measurements.addMeasurementProducer(methodMeasurementProducer);
        Measurements.addMeasurementProducer(customMetricMeasurementProducer);
        Measurements.addMeasurementConsumer(httpTransactionHarvester);
        Measurements.addMeasurementConsumer(activityConsumer);
        Measurements.addMeasurementConsumer(methodMeasurementConsumer);
        Measurements.addMeasurementConsumer(customMetricMeasurementConsumer);
        Measurements.addMeasurementConsumer(summaryMetricMeasurementConsumer);
    }

    public static void shutdown() {
        TaskQueue.stop();
        measurementEngine.clear();
        log.info("Measurement Engine shutting down.");
        Measurements.removeMeasurementProducer(measurementEngine.getRootMeasurementPool());
        Measurements.removeMeasurementProducer(networkMeasurementProducer);
        Measurements.removeMeasurementProducer(activityMeasurementProducer);
        Measurements.removeMeasurementProducer(methodMeasurementProducer);
        Measurements.removeMeasurementProducer(customMetricMeasurementProducer);
        Measurements.removeMeasurementConsumer(httpTransactionHarvester);
        Measurements.removeMeasurementConsumer(activityConsumer);
        Measurements.removeMeasurementConsumer(methodMeasurementConsumer);
        Measurements.removeMeasurementConsumer(customMetricMeasurementConsumer);
        Measurements.removeMeasurementConsumer(summaryMetricMeasurementConsumer);
    }

    public static void addHttpTransaction(HttpTransactionMeasurement transactionMeasurement) {
        if (Harvest.isDisabled()) {
            return;
        }
        if (transactionMeasurement == null) {
            log.error("TransactionMeasurement is null. HttpTransactionMeasurement measurement not created.");
        } else {
            networkMeasurementProducer.produceMeasurement(transactionMeasurement);
            Measurements.newMeasurementBroadcast();
        }
    }

    public static void addCustomMetric(String name, String category, int count, double totalValue, double exclusiveValue, MetricUnit countUnit, MetricUnit valueUnit) {
        if (Harvest.isDisabled()) {
            return;
        }
        customMetricMeasurementProducer.produceMeasurement(name, category, count, totalValue, exclusiveValue, countUnit, valueUnit);
        Measurements.newMeasurementBroadcast();
    }

    public static void setBroadcastNewMeasurements(boolean broadcast) {
        broadcastNewMeasurements = broadcast;
    }

    private static void newMeasurementBroadcast() {
        if (broadcastNewMeasurements) {
            Measurements.broadcast();
        }
    }

    public static void broadcast() {
        measurementEngine.broadcastMeasurements();
    }

    public static MeasuredActivity startActivity(String activityName) {
        if (Harvest.isDisabled()) {
            return null;
        }
        return measurementEngine.startActivity(activityName);
    }

    public static void renameActivity(String oldName, String newName) {
        measurementEngine.renameActivity(oldName, newName);
    }

    public static void endActivity(String activityName) {
        if (Harvest.isDisabled()) {
            return;
        }
        MeasuredActivity measuredActivity = measurementEngine.endActivity(activityName);
        activityMeasurementProducer.produceMeasurement(measuredActivity);
        Measurements.newMeasurementBroadcast();
    }

    public static void endActivity(MeasuredActivity activity) {
        if (!Harvest.isDisabled()) {
            measurementEngine.endActivity(activity);
            activityMeasurementProducer.produceMeasurement(activity);
            Measurements.newMeasurementBroadcast();
        }
    }

    public static void endActivityWithoutMeasurement(MeasuredActivity activity) {
        if (Harvest.isDisabled()) {
            return;
        }
        measurementEngine.endActivity(activity);
    }

    public static void addTracedMethod(Trace trace) {
        if (Harvest.isDisabled()) {
            return;
        }
        methodMeasurementProducer.produceMeasurement(trace);
        Measurements.newMeasurementBroadcast();
    }

    public static void addMeasurementProducer(MeasurementProducer measurementProducer) {
        measurementEngine.addMeasurementProducer(measurementProducer);
    }

    public static void removeMeasurementProducer(MeasurementProducer measurementProducer) {
        measurementProducer.drainMeasurements();
        measurementEngine.removeMeasurementProducer(measurementProducer);
    }

    public static void addMeasurementConsumer(MeasurementConsumer measurementConsumer) {
        measurementEngine.addMeasurementConsumer(measurementConsumer);
    }

    public static void removeMeasurementConsumer(MeasurementConsumer measurementConsumer) {
        measurementEngine.removeMeasurementConsumer(measurementConsumer);
    }

    public static void process() {
        measurementEngine.broadcastMeasurements();
    }
}

