/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.ApplicationFramework;
import com.newrelic.agent.android.RemoteConfiguration;
import com.newrelic.agent.android.harvest.ApplicationInformation;
import com.newrelic.agent.android.harvest.ConnectInformation;
import com.newrelic.agent.android.harvest.DataToken;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

public class SavedState
extends HarvestAdapter {
    private static final AgentLog log = AgentLogManager.getAgentLog();
    private final String PREFERENCE_FILE_PREFIX = "com.newrelic.android.agent.v1_";
    private final Gson gson = new GsonBuilder().create();
    private final String PREF_MAX_TRANSACTION_COUNT = "maxTransactionCount";
    private final String PREF_MAX_TRANSACTION_AGE = "maxTransactionAgeInSeconds";
    private final String PREF_HARVEST_INTERVAL = "harvestIntervalInSeconds";
    private final String PREF_SERVER_TIMESTAMP = "serverTimestamp";
    private final String PREF_CROSS_PROCESS_ID = "crossProcessId";
    private final String PREF_ACCOUNT_ID = "account_id";
    private final String PREF_TRUSTED_ACCOUNT_KEY = "trusted_account_key";
    private final String PREF_DATA_TOKEN = "dataToken";
    private final String PREF_DATA_TOKEN_EXPIRATION = "dataTokenExpiration";
    private final String PREF_CONNECT_HASH = "connectHash";
    private final String PREF_STACK_TRACE_LIMIT = "stackTraceLimit";
    private final String PREF_RESPONSE_BODY_LIMIT = "responseBodyLimit";
    private final String PREF_COLLECT_NETWORK_ERRORS = "collectNetworkErrors";
    private final String PREF_ERROR_LIMIT = "errorLimit";
    private final String NEW_RELIC_AGENT_DISABLED_VERSION_KEY = "NewRelicAgentDisabledVersion";
    private final String PREF_ACTIVITY_TRACE_MIN_UTILIZATION = "activityTraceMinUtilization";
    private final String PREF_REMOTE_CONFIGURATION = "remoteConfiguration";
    private final String PREF_REQUEST_HEADERS_MAP = "requestHeadersMap";
    private final String PREF_ENTITY_GUID = "entityGuid";
    private final String PREF_APP_NAME = "appName";
    private final String PREF_APP_VERSION = "appVersion";
    private final String PREF_APP_BUILD = "appBuild";
    private final String PREF_PACKAGE_ID = "packageId";
    private final String PREF_VERSION_CODE = "versionCode";
    private final String PREF_AGENT_NAME = "agentName";
    private final String PREF_AGENT_VERSION = "agentVersion";
    private final String PREF_DEVICE_ARCHITECTURE = "deviceArchitecture";
    private final String PREF_DEVICE_ID = "deviceId";
    private final String PREF_DEVICE_MODEL = "deviceModel";
    private final String PREF_DEVICE_MANUFACTURER = "deviceManufacturer";
    private final String PREF_DEVICE_RUN_TIME = "deviceRunTime";
    private final String PREF_DEVICE_SIZE = "deviceSize";
    private final String PREF_OS_NAME = "osName";
    private final String PREF_OS_BUILD = "osBuild";
    private final String PREF_OS_VERSION = "osVersion";
    private final String PREF_PLATFORM = "platform";
    private final String PREF_PLATFORM_VERSION = "platformVersion";
    private Float activityTraceMinUtilization;
    private final HarvestConfiguration configuration = new HarvestConfiguration();
    private final ConnectInformation connectInformation = new ConnectInformation(new ApplicationInformation(), new DeviceInformation());
    private final SharedPreferences prefs;
    private final SharedPreferences.Editor editor;
    private final Lock lock = new ReentrantLock();
    private final long DATA_TOKEN_TTL_MS = TimeUnit.MILLISECONDS.convert(14L, TimeUnit.DAYS);

    @SuppressLint(value={"CommitPrefEdits"})
    public SavedState(Context context) {
        this.prefs = context.getSharedPreferences(this.getPreferenceFileName(context.getPackageName()), 0);
        this.editor = this.prefs.edit();
        this.loadHarvestConfiguration();
        this.loadConnectInformation();
    }

    public void saveHarvestConfiguration(HarvestConfiguration newConfiguration) {
        DataToken dataToken = newConfiguration.getDataToken();
        if (!dataToken.isValid()) {
            log.debug("Invalid data token: " + newConfiguration.getDataToken());
            DataToken confDataToken = this.configuration.getDataToken();
            if (confDataToken.isValid()) {
                newConfiguration.setData_token(confDataToken.asIntArray());
            }
        }
        log.info("Saving configuration: " + newConfiguration);
        dataToken = newConfiguration.getDataToken();
        if (dataToken.isValid()) {
            String newDataTokenStr = dataToken.toJsonString();
            log.info("Saving data token: " + newDataTokenStr);
            this.save("dataToken", newDataTokenStr);
            this.save("dataTokenExpiration", System.currentTimeMillis() + this.getDataTokenTTL());
        } else {
            log.error("Refusing to save invalid data token: " + dataToken);
            StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/DataToken/Invalid");
        }
        this.save("crossProcessId", newConfiguration.getCross_process_id());
        this.save("serverTimestamp", newConfiguration.getServer_timestamp());
        this.save("harvestIntervalInSeconds", (long)newConfiguration.getData_report_period());
        this.save("maxTransactionAgeInSeconds", (long)newConfiguration.getReport_max_transaction_age());
        this.save("maxTransactionCount", (long)newConfiguration.getReport_max_transaction_count());
        this.save("stackTraceLimit", newConfiguration.getStack_trace_limit());
        this.save("responseBodyLimit", newConfiguration.getResponse_body_limit());
        this.save("collectNetworkErrors", newConfiguration.isCollect_network_errors());
        this.save("errorLimit", newConfiguration.getError_limit());
        this.save("account_id", newConfiguration.getAccount_id());
        this.save("trusted_account_key", newConfiguration.getTrusted_account_key());
        this.save("remoteConfiguration", this.gson.toJson(newConfiguration.getRemote_configuration()));
        this.save("requestHeadersMap", this.gson.toJson(newConfiguration.getRequest_headers_map()));
        this.save("entityGuid", newConfiguration.getEntity_guid());
        this.saveActivityTraceMinUtilization((float)newConfiguration.getActivity_trace_min_utilization());
        this.loadHarvestConfiguration();
    }

    public void loadHarvestConfiguration() {
        if (this.has("dataToken")) {
            this.configuration.setData_token(this.getDataToken());
            if (!this.configuration.getDataToken().isValid()) {
                this.configuration.setData_token(new int[]{0, 0});
            }
        }
        if (this.has("crossProcessId")) {
            this.configuration.setCross_process_id(this.getCrossProcessId());
        }
        if (this.has("account_id")) {
            this.configuration.setAccount_id(this.getAccountId());
        }
        if (this.has("serverTimestamp")) {
            this.configuration.setServer_timestamp(this.getServerTimestamp());
        }
        if (this.has("harvestIntervalInSeconds")) {
            this.configuration.setData_report_period((int)this.getHarvestIntervalInSeconds());
        }
        if (this.has("maxTransactionAgeInSeconds")) {
            this.configuration.setReport_max_transaction_age((int)this.getMaxTransactionAgeInSeconds());
        }
        if (this.has("maxTransactionCount")) {
            this.configuration.setReport_max_transaction_count((int)this.getMaxTransactionCount());
        }
        if (this.has("stackTraceLimit")) {
            this.configuration.setStack_trace_limit(this.getStackTraceLimit());
        }
        if (this.has("responseBodyLimit")) {
            this.configuration.setResponse_body_limit(this.getResponseBodyLimit());
        }
        if (this.has("collectNetworkErrors")) {
            this.configuration.setCollect_network_errors(this.isCollectingNetworkErrors());
        }
        if (this.has("errorLimit")) {
            this.configuration.setError_limit(this.getErrorLimit());
        }
        if (this.has("activityTraceMinUtilization")) {
            this.configuration.setActivity_trace_min_utilization(this.getActivityTraceMinUtilization());
        }
        if (this.has("trusted_account_key")) {
            this.configuration.setTrusted_account_key(this.getTrustedAccountKey());
        }
        if (this.has("remoteConfiguration")) {
            String remoteConfigAsJson = this.getString("remoteConfiguration");
            try {
                RemoteConfiguration remoteConfiguration = this.gson.fromJson(remoteConfigAsJson, RemoteConfiguration.class);
                this.configuration.setRemote_configuration(remoteConfiguration);
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to deserialize log reporting configuration: " + e);
                this.configuration.setRemote_configuration(new RemoteConfiguration());
            }
        }
        if (this.has("requestHeadersMap")) {
            String requestHeadersAsJson = this.getString("requestHeadersMap");
            try {
                Map requestHeadersMap = this.gson.fromJson(requestHeadersAsJson, Map.class);
                this.configuration.setRequest_headers_map(requestHeadersMap);
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to deserialize request header configuration: " + e);
                this.configuration.setRequest_headers_map(new HashMap<String, String>());
            }
        }
        if (this.has("entityGuid")) {
            this.configuration.setEntity_guid(this.getString("entityGuid"));
        }
        log.info("Loaded configuration: " + this.configuration);
    }

    public void saveConnectInformation(ConnectInformation newConnectInformation) {
        if (this.connectInformation.equals(newConnectInformation)) {
            return;
        }
        this.saveApplicationInformation(newConnectInformation.getApplicationInformation());
        this.saveDeviceInformation(newConnectInformation.getDeviceInformation());
        this.loadConnectInformation();
    }

    public void saveDeviceId(String deviceId) {
        this.save("deviceId", deviceId);
        this.connectInformation.getDeviceInformation().setDeviceId(deviceId);
    }

    public String getConnectionToken() {
        return String.valueOf(this.getInt("connectHash"));
    }

    public void saveConnectionToken(String connectionToken) {
        this.save("connectHash", connectionToken.hashCode());
    }

    private void saveApplicationInformation(ApplicationInformation applicationInformation) {
        this.save("appName", applicationInformation.getAppName());
        this.save("appVersion", applicationInformation.getAppVersion());
        this.save("appBuild", applicationInformation.getAppBuild());
        this.save("packageId", applicationInformation.getPackageId());
        this.save("versionCode", applicationInformation.getVersionCode());
    }

    private void saveDeviceInformation(DeviceInformation deviceInformation) {
        this.save("agentName", deviceInformation.getAgentName());
        this.save("agentVersion", deviceInformation.getAgentVersion());
        this.save("deviceArchitecture", deviceInformation.getArchitecture());
        this.save("deviceId", deviceInformation.getDeviceId());
        this.save("deviceModel", deviceInformation.getModel());
        this.save("deviceManufacturer", deviceInformation.getManufacturer());
        this.save("deviceRunTime", deviceInformation.getRunTime());
        this.save("deviceSize", deviceInformation.getSize());
        this.save("osName", deviceInformation.getOsName());
        this.save("osBuild", deviceInformation.getOsBuild());
        this.save("osVersion", deviceInformation.getOsVersion());
        this.save("platform", deviceInformation.getApplicationFramework().toString());
        this.save("platformVersion", deviceInformation.getApplicationFrameworkVersion());
    }

    public void loadConnectInformation() {
        ApplicationInformation applicationInformation = new ApplicationInformation();
        DeviceInformation deviceInformation = new DeviceInformation();
        if (this.has("appName")) {
            applicationInformation.setAppName(this.getAppName());
        }
        if (this.has("appVersion")) {
            applicationInformation.setAppVersion(this.getAppVersion());
        }
        if (this.has("appBuild")) {
            applicationInformation.setAppBuild(this.getAppBuild());
        }
        if (this.has("packageId")) {
            applicationInformation.setPackageId(this.getPackageId());
        }
        if (this.has("versionCode")) {
            applicationInformation.setVersionCode(this.getVersionCode());
        }
        if (this.has("agentName")) {
            deviceInformation.setAgentName(this.getAgentName());
        }
        if (this.has("agentVersion")) {
            deviceInformation.setAgentVersion(this.getAgentVersion());
        }
        if (this.has("deviceArchitecture")) {
            deviceInformation.setArchitecture(this.getDeviceArchitecture());
        }
        if (this.has("deviceId")) {
            deviceInformation.setDeviceId(this.getDeviceId());
        }
        if (this.has("deviceModel")) {
            deviceInformation.setModel(this.getDeviceModel());
        }
        if (this.has("deviceManufacturer")) {
            deviceInformation.setManufacturer(this.getDeviceManufacturer());
        }
        if (this.has("deviceRunTime")) {
            deviceInformation.setRunTime(this.getDeviceRunTime());
        }
        if (this.has("deviceSize")) {
            deviceInformation.setSize(this.getDeviceSize());
        }
        if (this.has("osName")) {
            deviceInformation.setOsName(this.getOsName());
        }
        if (this.has("osBuild")) {
            deviceInformation.setOsBuild(this.getOsBuild());
        }
        if (this.has("osVersion")) {
            deviceInformation.setOsVersion(this.getOsVersion());
        }
        if (this.has("platform")) {
            deviceInformation.setApplicationFramework(this.getFramework());
        }
        if (this.has("platformVersion")) {
            deviceInformation.setApplicationFrameworkVersion(this.getPlatformVersion());
        }
        this.connectInformation.setApplicationInformation(applicationInformation);
        this.connectInformation.setDeviceInformation(deviceInformation);
    }

    public HarvestConfiguration getHarvestConfiguration() {
        return this.configuration;
    }

    public ConnectInformation getConnectInformation() {
        return this.connectInformation;
    }

    boolean has(String key) {
        return this.prefs.contains(key);
    }

    @Override
    public void onHarvestConnected() {
        this.saveHarvestConfiguration(Harvest.getHarvestConfiguration());
    }

    @Override
    public void onHarvestComplete() {
        long tsExpiration;
        if (this.has("dataTokenExpiration") && (tsExpiration = this.getLong("dataTokenExpiration")) > 0L && System.currentTimeMillis() >= tsExpiration) {
            this.remove("dataToken");
            this.remove("dataTokenExpiration");
        }
    }

    @Override
    public void onHarvestDisconnected() {
        log.info("Clearing harvest configuration.");
        this.clear();
    }

    @Override
    public void onHarvestDisabled() {
        String agentVersion = Agent.getDeviceInformation().getAgentVersion();
        log.info("Disabling agent version " + agentVersion);
        this.saveDisabledVersion(agentVersion);
    }

    @Override
    public void onHarvestConfigurationChanged() {
        this.saveHarvestConfiguration(Harvest.getHarvestConfiguration());
    }

    public void save(String key, String value) {
        this.lock.lock();
        try {
            this.editor.putString(key, value);
            this.editor.apply();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void save(String key, boolean value) {
        this.lock.lock();
        try {
            this.editor.putBoolean(key, value);
            this.editor.apply();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void save(String key, int value) {
        this.lock.lock();
        try {
            this.editor.putInt(key, value);
            this.editor.apply();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String key, long value) {
        this.lock.lock();
        try {
            this.editor.putLong(key, value);
            this.editor.apply();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void save(String key, float value) {
        this.lock.lock();
        try {
            this.editor.putFloat(key, value);
            this.editor.apply();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getString(String key) {
        if (!this.prefs.contains(key)) {
            return null;
        }
        return this.prefs.getString(key, null);
    }

    public boolean getBoolean(String key) {
        return this.prefs.getBoolean(key, false);
    }

    public long getLong(String key) {
        return this.prefs.getLong(key, 0L);
    }

    public int getInt(String key) {
        return this.prefs.getInt(key, 0);
    }

    public Float getFloat(String key) {
        if (!this.prefs.contains(key)) {
            return null;
        }
        float f = this.prefs.getFloat(key, 0.0f);
        return Float.valueOf((float)((int)(f * 100.0f)) / 100.0f);
    }

    public String getDisabledVersion() {
        return this.getString("NewRelicAgentDisabledVersion");
    }

    public void saveDisabledVersion(String version) {
        this.save("NewRelicAgentDisabledVersion", version);
    }

    public int[] getDataToken() {
        int[] dataToken = new int[2];
        String dataTokenString = this.getString("dataToken");
        if (dataTokenString == null || dataTokenString.isEmpty()) {
            return null;
        }
        try {
            JSONTokener tokener = new JSONTokener(dataTokenString);
            if (tokener == null) {
                return null;
            }
            JSONArray array = (JSONArray)tokener.nextValue();
            if (array == null) {
                return null;
            }
            dataToken[0] = array.getInt(0);
            dataToken[1] = array.getInt(1);
            return dataToken;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCrossProcessId() {
        return this.getString("crossProcessId");
    }

    public String getAccountId() {
        return this.getString("account_id");
    }

    public String getTrustedAccountKey() {
        return this.getString("trusted_account_key");
    }

    public boolean isCollectingNetworkErrors() {
        return this.getBoolean("collectNetworkErrors");
    }

    public long getServerTimestamp() {
        return this.getLong("serverTimestamp");
    }

    public long getHarvestInterval() {
        return this.getLong("harvestIntervalInSeconds");
    }

    public long getMaxTransactionAge() {
        return this.getLong("maxTransactionAgeInSeconds");
    }

    public long getMaxTransactionCount() {
        return this.getLong("maxTransactionCount");
    }

    public int getStackTraceLimit() {
        return this.getInt("stackTraceLimit");
    }

    public int getResponseBodyLimit() {
        return this.getInt("responseBodyLimit");
    }

    public int getErrorLimit() {
        return this.getInt("errorLimit");
    }

    public void saveActivityTraceMinUtilization(float activityTraceMinUtilization) {
        this.activityTraceMinUtilization = Float.valueOf(activityTraceMinUtilization);
        this.save("activityTraceMinUtilization", activityTraceMinUtilization);
    }

    public float getActivityTraceMinUtilization() {
        if (this.activityTraceMinUtilization == null) {
            this.activityTraceMinUtilization = this.getFloat("activityTraceMinUtilization");
        }
        return this.activityTraceMinUtilization.floatValue();
    }

    public long getHarvestIntervalInSeconds() {
        return this.getHarvestInterval();
    }

    public long getMaxTransactionAgeInSeconds() {
        return this.getMaxTransactionAge();
    }

    public String getAppName() {
        return this.getString("appName");
    }

    public String getAppVersion() {
        return this.getString("appVersion");
    }

    public int getVersionCode() {
        return this.getInt("versionCode");
    }

    public String getAppBuild() {
        return this.getString("appBuild");
    }

    public String getPackageId() {
        return this.getString("packageId");
    }

    public String getAgentName() {
        return this.getString("agentName");
    }

    public String getAgentVersion() {
        return this.getString("agentVersion");
    }

    public String getDeviceArchitecture() {
        return this.getString("deviceArchitecture");
    }

    public String getDeviceId() {
        return this.getString("deviceId");
    }

    public String getDeviceModel() {
        return this.getString("deviceModel");
    }

    public String getDeviceManufacturer() {
        return this.getString("deviceManufacturer");
    }

    public String getDeviceRunTime() {
        return this.getString("deviceRunTime");
    }

    public String getDeviceSize() {
        return this.getString("deviceSize");
    }

    public String getOsName() {
        return this.getString("osName");
    }

    public String getOsBuild() {
        return this.getString("osBuild");
    }

    public String getOsVersion() {
        return this.getString("osVersion");
    }

    public String getApplicationFramework() {
        return this.getString("platform");
    }

    public String getApplicationFrameworkVersion() {
        return this.getString("platformVersion");
    }

    public ApplicationFramework getFramework() {
        ApplicationFramework applicationFramework = ApplicationFramework.Native;
        try {
            applicationFramework = ApplicationFramework.valueOf(this.getString("platform"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return applicationFramework;
    }

    public String getPlatformVersion() {
        return this.getString("platformVersion");
    }

    private String getPreferenceFileName(String packageName) {
        return "com.newrelic.android.agent.v1_" + packageName;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.editor.clear();
            this.editor.apply();
            this.configuration.setDefaultValues();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(String key) {
        this.lock.lock();
        try {
            this.editor.remove(key).apply();
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasConnectionToken(String appToken) {
        return this.getInt("connectHash") == appToken.hashCode();
    }

    long getDataTokenTTL() {
        return this.DATA_TOKEN_TTL_MS;
    }
}

