/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.distributedtracing;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.agentdata.AgentDataController;
import com.newrelic.agent.android.distributedtracing.TraceConfiguration;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceFacade;
import com.newrelic.agent.android.distributedtracing.TraceListener;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class DistributedTracing
implements TraceFacade,
TraceListener {
    static final DistributedTracing instance = new DistributedTracing();
    static final AgentLog log = AgentLogManager.getAgentLog();
    public static final String NR_GUID_ATTRIBUTE = "guid";
    public static final String NR_ID_ATTRIBUTE = "id";
    public static final String NR_TRACE_ID_ATTRIBUTE = "trace.id";
    public static final String NR_SPAN_ID_ATTRIBUTE = "span.id";
    public static final String ACTION_TYPE_ATTRIBUTE = "actionType";
    AtomicReference<TraceListener> traceListener = new AtomicReference<DistributedTracing>(this);

    public static final DistributedTracing getInstance() {
        return instance;
    }

    @Override
    public TraceContext startTrace(final TransactionState transactionState) {
        HashMap<String, String> requestContext = new HashMap<String, String>(){
            {
                this.put("url", transactionState.getUrl());
                this.put("httpMethod", transactionState.getHttpMethod());
                this.put("thread.id", Long.toString(Thread.currentThread().getId()));
            }
        };
        TraceContext traceContext = TraceContext.createTraceContext((Map<String, String>)requestContext);
        this.invokeListeners(traceContext);
        return traceContext;
    }

    @Override
    public void setConfiguration(TraceConfiguration traceConfiguration) {
        TraceConfiguration.setInstance(traceConfiguration);
    }

    @Override
    public void setTraceListener(TraceListener listener) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            if (listener == null) {
                this.traceListener.set(this);
            } else {
                this.traceListener.set(listener);
            }
        }
    }

    public void setConfiguration(HarvestConfiguration harvestConfiguration) {
        TraceConfiguration.getInstance().setConfiguration(harvestConfiguration);
    }

    @Override
    public void onTraceCreated(Map<String, String> requestContext) {
    }

    @Override
    public void onSpanCreated(Map<String, String> requestContext) {
    }

    private void invokeListeners(TraceContext traceContext) {
        try {
            traceContext.requestContext.put(NR_TRACE_ID_ATTRIBUTE, traceContext.traceId);
            DistributedTracing.instance.traceListener.get().onTraceCreated(traceContext.requestContext);
        }
        catch (Exception e) {
            DistributedTracing.instance.traceListener.set(instance);
            log.error("The provided listener has thrown an exception and has been removed: " + e.getLocalizedMessage());
            AgentDataController.sendAgentData(e, null);
        }
        try {
            traceContext.requestContext.put(NR_SPAN_ID_ATTRIBUTE, traceContext.tracePayload.getSpanId());
            DistributedTracing.instance.traceListener.get().onSpanCreated(traceContext.requestContext);
        }
        catch (Exception e) {
            DistributedTracing.instance.traceListener.set(instance);
            log.error("The provided listener has thrown an exception and has been removed: " + e.getLocalizedMessage());
            AgentDataController.sendAgentData(e, new HashMap<String, Object>());
        }
    }

    static String generateRandomBytes(int minLength) {
        Object randomBytes = "";
        while (((String)randomBytes).length() < minLength) {
            randomBytes = (String)randomBytes + UUID.randomUUID().toString().replace("-", "");
        }
        return ((String)randomBytes).substring(0, minLength);
    }

    public static String generateTraceId() {
        return DistributedTracing.generateRandomBytes(32);
    }

    public static String generateSpanId() {
        return DistributedTracing.generateRandomBytes(16);
    }

    public static long generateNormalizedTimestamp() {
        return System.currentTimeMillis();
    }

    public static void setDistributedTraceListener(TraceListener listener) {
        instance.setTraceListener(listener);
    }
}

