/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.okhttp3;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.measurement.HttpTransactionMeasurement;
import java.io.IOException;
import java.util.TreeMap;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3TransactionStateUtil
extends TransactionStateUtil {
    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        if (request == null) {
            log.debug("Missing request");
        } else {
            OkHttp3TransactionStateUtil.inspectAndInstrument(transactionState, request.url().toString(), request.method());
            try {
                RequestBody body = request.body();
                if (body != null && body.contentLength() > 0L) {
                    transactionState.setBytesSent(body.contentLength());
                }
            }
            catch (IOException e) {
                log.debug("Could not determine request length: " + e);
            }
        }
    }

    public static Response inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = "";
        int statusCode = -1;
        long contentLength = 0L;
        if (response == null) {
            statusCode = 500;
            log.debug("Missing response");
        } else {
            String url;
            Request request = response.request();
            if (request != null && request.url() != null && !(url = request.url().toString()).isEmpty()) {
                OkHttp3TransactionStateUtil.inspectAndInstrument(transactionState, url, request.method());
            }
            appData = response.header("X-NewRelic-App-Data");
            statusCode = response.code();
            try {
                contentLength = OkHttp3TransactionStateUtil.exhaustiveContentLength(response);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (contentLength < 0L) {
                log.debug("OkHttp3TransactionStateUtil: Missing body or content length");
            }
        }
        OkHttp3TransactionStateUtil.inspectAndInstrumentResponse(transactionState, appData, (int)contentLength, statusCode);
        return OkHttp3TransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    private static long exhaustiveContentLength(Response response) {
        long contentLength = -1L;
        if (response != null) {
            if (response.body() != null) {
                contentLength = response.body().contentLength();
            }
            if (contentLength < 0L) {
                String responseBodyString = response.header("Content-Length");
                if (responseBodyString != null && responseBodyString.length() > 0) {
                    try {
                        contentLength = Long.parseLong(responseBodyString);
                    }
                    catch (NumberFormatException var10) {
                        log.debug("Failed to parse content length: " + var10);
                    }
                } else {
                    Response networkResponse = response.networkResponse();
                    if (networkResponse != null) {
                        responseBodyString = networkResponse.header("Content-Length");
                        if (responseBodyString != null && responseBodyString.length() > 0) {
                            try {
                                contentLength = Long.parseLong(responseBodyString);
                            }
                            catch (NumberFormatException var5) {
                                log.debug("Failed to parse network response content length: " + var5);
                            }
                        } else if (networkResponse.body() != null) {
                            contentLength = networkResponse.body().contentLength();
                        }
                    }
                }
            }
        }
        return contentLength;
    }

    protected static Response addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData != null) {
            if (response != null && transactionState.isErrorOrFailure()) {
                String responseBodyString;
                TreeMap<String, Object> params;
                block6: {
                    String contentTypeHeader = response.header("Content-Type");
                    params = new TreeMap<String, Object>();
                    if (contentTypeHeader != null && !contentTypeHeader.isEmpty()) {
                        params.put("content_type", contentTypeHeader);
                    }
                    params.put("content_length", "" + transactionState.getBytesReceived());
                    responseBodyString = "";
                    try {
                        long contentLength = OkHttp3TransactionStateUtil.exhaustiveContentLength(response);
                        if (contentLength > 0L) {
                            responseBodyString = response.peekBody(contentLength).string();
                        }
                    }
                    catch (Exception e) {
                        if (response.message() == null) break block6;
                        log.debug("Missing response body, using response message");
                        responseBodyString = response.message();
                    }
                }
                transactionData.setResponseBody(responseBodyString);
                transactionData.getParams().putAll(params);
            }
            HttpTransactionMeasurement httpTransactionMeasurement = new HttpTransactionMeasurement(transactionData);
            TaskQueue.queue(httpTransactionMeasurement);
            OkHttp3TransactionStateUtil.setDistributedTraceHeaders(transactionState, response);
        }
        return response;
    }

    public static Request setDistributedTraceHeaders(TransactionState transactionState, Request request) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            try {
                Request.Builder builder = request.newBuilder();
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        builder = builder.header(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                    TraceContext.reportSupportabilityMetrics();
                }
                return builder.build();
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
        return request;
    }

    public static Response setDistributedTraceHeaders(TransactionState transactionState, Response response) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            try {
                Response.Builder builder = response.newBuilder();
                TraceContext traceContext = transactionState.getTrace();
                if (traceContext != null) {
                    Headers headers = response.headers();
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        if (headers.get(traceHeader.getHeaderName()) != null) continue;
                        builder = builder.addHeader(traceHeader.getHeaderName(), traceHeader.getHeaderValue());
                    }
                }
                return builder.build();
            }
            catch (Exception e) {
                log.error("setDistributedTraceHeaders: Unable to add trace headers. ", e);
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
        return response;
    }
}

