/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.retrofit;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.TaskQueue;
import com.newrelic.agent.android.api.common.TransactionData;
import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import com.newrelic.agent.android.instrumentation.TransactionState;
import com.newrelic.agent.android.instrumentation.TransactionStateUtil;
import com.newrelic.agent.android.measurement.HttpTransactionMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;

public class RetrofitTransactionStateUtil
extends TransactionStateUtil {
    public static void inspectAndInstrument(TransactionState transactionState, Request request) {
        transactionState.setUrl(request.getUrl());
        transactionState.setHttpMethod(request.getMethod());
        transactionState.setCarrier(Agent.getActiveNetworkCarrier());
        transactionState.setWanType(Agent.getActiveNetworkWanType());
    }

    public static void inspectAndInstrumentResponse(TransactionState transactionState, Response response) {
        String appData = RetrofitTransactionStateUtil.getAppDataHeader(response.getHeaders(), "X-NewRelic-App-Data");
        if (appData != null && !"".equals(appData)) {
            transactionState.setAppData(appData);
        }
        int statusCode = response.getStatus();
        transactionState.setStatusCode(statusCode);
        long contentLength = response.getBody().length();
        if (contentLength >= 0L) {
            transactionState.setBytesReceived(contentLength);
        }
        RetrofitTransactionStateUtil.addTransactionAndErrorData(transactionState, response);
    }

    private static String getAppDataHeader(List<Header> headers, String headerName) {
        if (headers != null) {
            for (Header header : headers) {
                if (header.getName() == null || !header.getName().equalsIgnoreCase(headerName)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    protected static void addTransactionAndErrorData(TransactionState transactionState, Response response) {
        TransactionData transactionData = transactionState.end();
        if (transactionData == null) {
            return;
        }
        if (transactionState.isErrorOrFailure()) {
            String contentTypeHeader = RetrofitTransactionStateUtil.getAppDataHeader(response.getHeaders(), "Content-Type");
            TreeMap<String, String> params = new TreeMap<String, String>();
            if (contentTypeHeader != null && contentTypeHeader.length() > 0 && !"".equals(contentTypeHeader)) {
                params.put("content_type", contentTypeHeader);
            }
            params.put("content_length", "" + transactionState.getBytesReceived());
            transactionData.setParams(params);
        }
        HttpTransactionMeasurement httpTransactionMeasurement = new HttpTransactionMeasurement(transactionData);
        TaskQueue.queue(httpTransactionMeasurement);
        response = RetrofitTransactionStateUtil.setDistributedTraceHeaders(transactionState, response);
    }

    static Request setDistributedTraceHeaders(TransactionState transactionState, Request request) {
        ArrayList<Header> headers = new ArrayList<Header>(request.getHeaders());
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            TraceContext traceContext = DistributedTracing.getInstance().startTrace(transactionState);
            transactionState.setTrace(traceContext);
            try {
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        headers.add(new Header(traceHeader.getHeaderName(), traceHeader.getHeaderValue()));
                    }
                }
                TraceContext.reportSupportabilityMetrics();
                return new Request(request.getMethod(), request.getUrl(), headers, request.getBody());
            }
            catch (Exception e) {
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
        return request;
    }

    static Response setDistributedTraceHeaders(TransactionState transactionState, Response response) {
        if (FeatureFlag.featureEnabled(FeatureFlag.DistributedTracing)) {
            ArrayList<Header> headers = new ArrayList<Header>(response.getHeaders());
            TraceContext traceContext = DistributedTracing.getInstance().startTrace(transactionState);
            transactionState.setTrace(traceContext);
            try {
                if (traceContext != null) {
                    for (TraceHeader traceHeader : traceContext.getHeaders()) {
                        headers.add(new Header(traceHeader.getHeaderName(), traceHeader.getHeaderValue()));
                    }
                }
                return new Response(response.getUrl(), response.getStatus(), response.getReason(), headers, response.getBody());
            }
            catch (Exception e) {
                TraceContext.reportSupportabilityExceptionMetric(e);
            }
        }
        return response;
    }
}

