/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.LogLevel;
import com.newrelic.agent.android.logging.LogReporting;
import com.newrelic.agent.android.logging.RemoteLogger;
import java.util.HashMap;
import java.util.Map;

public class ForwardingAgentLog
implements AgentLog {
    private final AgentLog delegate;

    public ForwardingAgentLog(AgentLog agentLog) {
        this.delegate = agentLog;
    }

    @Override
    public void audit(String message) {
        this.delegate.audit(message);
        if (this.delegate.getLevel() == 6 && LogReporting.getLogger() instanceof RemoteLogger) {
            LogReporting.getLogger().logAttributes(this.asAttributes(LogLevel.DEBUG, message));
        }
    }

    @Override
    public void debug(String message) {
        this.delegate.debug(message);
        if (this.delegate.getLevel() >= 5 && LogReporting.getLogger() instanceof RemoteLogger) {
            LogReporting.getLogger().logAttributes(this.asAttributes(LogLevel.DEBUG, message));
        }
    }

    @Override
    public void verbose(String message) {
        this.delegate.verbose(message);
        if (this.delegate.getLevel() >= 4 && LogReporting.getLogger() instanceof RemoteLogger) {
            LogReporting.getLogger().logAttributes(this.asAttributes(LogLevel.VERBOSE, message));
        }
    }

    @Override
    public void info(String message) {
        this.delegate.info(message);
        if (this.delegate.getLevel() >= 3 && LogReporting.getLogger() instanceof RemoteLogger) {
            LogReporting.getLogger().logAttributes(this.asAttributes(LogLevel.INFO, message));
        }
    }

    @Override
    public void warn(String message) {
        this.delegate.warn(message);
        if (this.delegate.getLevel() >= 2 && LogReporting.getLogger() instanceof RemoteLogger) {
            LogReporting.getLogger().logAttributes(this.asAttributes(LogLevel.WARN, message));
        }
    }

    @Override
    public void error(String message) {
        this.delegate.error(message);
        if (this.delegate.getLevel() >= 1 && LogReporting.getLogger() instanceof RemoteLogger) {
            LogReporting.getLogger().logAttributes(this.asAttributes(LogLevel.ERROR, message));
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.delegate.error(message, throwable);
        if (this.delegate.getLevel() >= 1 && LogReporting.getLogger() instanceof RemoteLogger) {
            Map<String, Object> attributes = this.asAttributes(LogLevel.ERROR, message);
            attributes.put("error.message", throwable.toString());
            attributes.put("error.stack", throwable.getStackTrace()[0].toString());
            attributes.put("error.class", throwable.getClass().getSimpleName());
            LogReporting.getLogger().logAttributes(attributes);
        }
    }

    @Override
    public int getLevel() {
        return this.delegate.getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.delegate.setLevel(level);
    }

    Map<String, Object> asAttributes(LogLevel level, String message) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("level", level.name());
        attributes.put("message", message);
        attributes.put("logger", "Android agent " + Agent.getVersion());
        return attributes;
    }
}

