/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.logging.LogLevel;
import com.newrelic.agent.android.logging.LoggingConfiguration;
import com.newrelic.com.google.gson.annotations.SerializedName;
import java.util.concurrent.TimeUnit;

public class LogReportingConfiguration
extends LoggingConfiguration {
    static int sampleSeed = 100;
    static final long DEFAULT_HARVEST_PERIOD = TimeUnit.SECONDS.convert(30L, TimeUnit.SECONDS);
    static final long DEFAULT_EXPIRATION_PERIOD = TimeUnit.SECONDS.convert(2L, TimeUnit.DAYS);
    @SerializedName(value="data_report_period")
    Long harvestPeriod;
    @SerializedName(value="expiration_period")
    Long expirationPeriod;
    @SerializedName(value="sampling_rate")
    int sampleRate;

    public LogReportingConfiguration() {
        this(false, LogLevel.NONE);
    }

    public LogReportingConfiguration(boolean enabled, LogLevel level) {
        this(enabled, level, DEFAULT_HARVEST_PERIOD, DEFAULT_EXPIRATION_PERIOD, sampleSeed);
    }

    public LogReportingConfiguration(boolean enabled, LogLevel level, long harvestPeriod, long expirationPeriod, int sampleRate) {
        super(enabled, level);
        this.harvestPeriod = harvestPeriod;
        this.expirationPeriod = expirationPeriod;
        this.sampleRate = Math.min(100, Math.max(0, sampleRate));
    }

    public void setConfiguration(LogReportingConfiguration logReportingConfiguration) {
        super.setConfiguration(logReportingConfiguration);
        this.enabled = logReportingConfiguration.enabled;
        this.level = logReportingConfiguration.level;
        this.sampleRate = logReportingConfiguration.sampleRate;
    }

    public long getHarvestPeriod() {
        return this.harvestPeriod;
    }

    public long getExpirationPeriod() {
        return this.expirationPeriod;
    }

    @Override
    public String toString() {
        return "{\"enabled\"=" + this.enabled + ",\"level\"=\"" + this.level + "\",\"data_report_period\"=" + this.harvestPeriod + ",\"expiration_period\"=" + this.expirationPeriod + ",\"sampling_rate\"=" + this.sampleRate + "}";
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogReportingConfiguration) {
            LogReportingConfiguration rhs = (LogReportingConfiguration)obj;
            return this.enabled == rhs.enabled && this.level.equals((Object)rhs.level) && this.sampleRate == rhs.sampleRate;
        }
        return false;
    }

    @Override
    public boolean getLoggingEnabled() {
        return this.enabled && this.isSampled();
    }

    public boolean isSampled() {
        return sampleSeed <= this.sampleRate;
    }

    public static int reseed() {
        sampleSeed = (int)(Math.random() * 100.0) + 1;
        return sampleSeed;
    }
}

