/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.measurement.consumer;

import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.instrumentation.MetricCategory;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.measurement.BaseMeasurement;
import com.newrelic.agent.android.measurement.CustomMetricMeasurement;
import com.newrelic.agent.android.measurement.HttpTransactionMeasurement;
import com.newrelic.agent.android.measurement.Measurement;
import com.newrelic.agent.android.measurement.MeasurementType;
import com.newrelic.agent.android.measurement.MethodMeasurement;
import com.newrelic.agent.android.measurement.consumer.MetricMeasurementConsumer;
import com.newrelic.agent.android.metric.Metric;
import com.newrelic.agent.android.tracing.ActivityTrace;
import com.newrelic.agent.android.tracing.Trace;
import com.newrelic.agent.android.tracing.TraceLifecycleAware;
import com.newrelic.agent.android.tracing.TraceMachine;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SummaryMetricMeasurementConsumer
extends MetricMeasurementConsumer
implements TraceLifecycleAware {
    protected static final String METRIC_PREFIX = "Mobile/Summary/";
    protected static final String ACTIVITY_METRIC_PREFIX = "Mobile/Activity/Summary/Name/";
    private static final AgentLog log = AgentLogManager.getAgentLog();
    protected final List<ActivityTrace> completedTraces = new CopyOnWriteArrayList<ActivityTrace>();

    public SummaryMetricMeasurementConsumer() {
        super(MeasurementType.Any);
        this.recordUnscopedMetrics = false;
        TraceMachine.addTraceListener(this);
    }

    @Override
    public void consumeMeasurement(Measurement measurement) {
        if (measurement != null) {
            switch (measurement.getType()) {
                case Method: {
                    this.consumeMethodMeasurement((MethodMeasurement)measurement);
                    break;
                }
                case Network: {
                    this.consumeNetworkMeasurement((HttpTransactionMeasurement)measurement);
                    break;
                }
                case Custom: {
                    this.consumeCustomMeasurement((CustomMetricMeasurement)measurement);
                }
            }
        }
    }

    void consumeMethodMeasurement(MethodMeasurement methodMeasurement) {
        if (methodMeasurement.getCategory() == null || methodMeasurement.getCategory() == MetricCategory.NONE) {
            methodMeasurement.setCategory(MetricCategory.categoryForMethod(methodMeasurement.getName()));
            if (methodMeasurement.getCategory() == MetricCategory.NONE) {
                return;
            }
        }
        BaseMeasurement summary = new BaseMeasurement(methodMeasurement);
        summary.setName(methodMeasurement.getCategory().getCategoryName());
        super.consumeMeasurement(summary);
    }

    void consumeCustomMeasurement(CustomMetricMeasurement customMetricMeasurement) {
        if (customMetricMeasurement.getCategory() == null || customMetricMeasurement.getCategory() == MetricCategory.NONE) {
            return;
        }
        BaseMeasurement summary = new BaseMeasurement(customMetricMeasurement);
        summary.setName(customMetricMeasurement.getCategory().getCategoryName());
        super.consumeMeasurement(summary);
    }

    void consumeNetworkMeasurement(HttpTransactionMeasurement httpTransactionMeasurement) {
        BaseMeasurement summary = new BaseMeasurement(httpTransactionMeasurement);
        summary.setName(MetricCategory.NETWORK.getCategoryName());
        super.consumeMeasurement(summary);
    }

    @Override
    protected String formatMetricName(String name) {
        return METRIC_PREFIX + (name != null ? name.replace("#", "/") : "");
    }

    @Override
    public void onHarvest() {
        if (this.metrics.getAll().size() == 0) {
            return;
        }
        if (this.completedTraces.size() == 0) {
            return;
        }
        for (ActivityTrace trace : this.completedTraces) {
            this.summarizeActivityMetrics(trace);
        }
        if (this.metrics.getAll().size() != 0) {
            log.debug("Not all metrics were summarized!");
        }
        this.completedTraces.clear();
    }

    void summarizeActivityNetworkMetrics(ActivityTrace activityTrace) {
        String name;
        String activityName = activityTrace.getActivityName();
        if (activityTrace.networkCountMetric.getCount() > 0L) {
            name = activityTrace.networkCountMetric.getName();
            activityTrace.networkCountMetric.setName(name.replace("<activity>", activityName)).setCount(1L).setMinFieldValue(activityTrace.networkCountMetric.getTotal()).setMaxFieldValue(activityTrace.networkCountMetric.getTotal());
            Harvest.addMetric(activityTrace.networkCountMetric);
        }
        if (activityTrace.networkTimeMetric.getCount() > 0L) {
            name = activityTrace.networkTimeMetric.getName();
            activityTrace.networkTimeMetric.setName(name.replace("<activity>", activityName)).setCount(1L).setMinFieldValue(activityTrace.networkTimeMetric.getTotal()).setMaxFieldValue(activityTrace.networkTimeMetric.getTotal());
            Harvest.addMetric(activityTrace.networkTimeMetric);
        }
    }

    void summarizeActivityMetrics(ActivityTrace activityTrace) {
        Trace trace = activityTrace.rootTrace;
        List<Metric> activityMetrics = this.metrics.removeAllWithScope(trace.metricName);
        List<Metric> backgroundMetrics = this.metrics.removeAllWithScope(trace.metricBackgroundName);
        HashMap<String, Metric> summaryMetrics = new HashMap<String, Metric>();
        for (Metric activityMetric : activityMetrics) {
            summaryMetrics.put(activityMetric.getName(), activityMetric);
        }
        for (Metric backgroundMetric : backgroundMetrics) {
            if (summaryMetrics.containsKey(backgroundMetric.getName())) {
                ((Metric)summaryMetrics.get(backgroundMetric.getName())).aggregate(backgroundMetric);
                continue;
            }
            summaryMetrics.put(backgroundMetric.getName(), backgroundMetric);
        }
        double totalExclusiveTime = 0.0;
        for (Metric metric : summaryMetrics.values()) {
            totalExclusiveTime += metric.getExclusive();
        }
        double traceTime = (double)(trace.exitTimestamp - trace.entryTimestamp) / 1000.0;
        for (Metric metric : summaryMetrics.values()) {
            double normalizedTime = 0.0;
            if (metric.getExclusive() != 0.0 && totalExclusiveTime != 0.0) {
                normalizedTime = metric.getExclusive() / totalExclusiveTime;
            }
            double scaledTime = normalizedTime * traceTime;
            metric.setTotal(scaledTime).setExclusive(scaledTime).setMinFieldValue(Double.NaN).setMaxFieldValue(Double.NaN).setSumOfSquares(0.0).setScope(ACTIVITY_METRIC_PREFIX + trace.displayName);
            Harvest.addMetric(metric);
            Metric unScoped = new Metric(metric);
            unScoped.setScope(null);
            Harvest.addMetric(unScoped);
        }
        this.summarizeActivityNetworkMetrics(activityTrace);
    }

    @Override
    public void onTraceComplete(ActivityTrace activityTrace) {
        if (!this.completedTraces.contains(activityTrace)) {
            this.completedTraces.add(activityTrace);
        }
    }
}

