/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.metric;

import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonPrimitive;

public class Metric
extends HarvestableObject {
    static final AgentLog log = AgentLogManager.getAgentLog();
    private String name;
    private String scope;
    private Double min = Double.NaN;
    private Double max = Double.NaN;
    private Double total = 0.0;
    private Double sumOfSquares = 0.0;
    private Double exclusive = 0.0;
    private long count = 0L;
    private boolean isCountOnly = true;

    public Metric(String name) {
        this(name, null);
    }

    public Metric(String name, String scope) {
        this.name = name;
        this.scope = scope;
    }

    public Metric(Metric metric) {
        this.name = metric.getName();
        this.scope = metric.getScope();
        this.min = metric.getMin();
        this.max = metric.getMax();
        this.total = metric.getTotal();
        this.sumOfSquares = metric.getSumOfSquares();
        this.exclusive = metric.getExclusive();
        this.count = metric.getCount();
        this.isCountOnly = metric.isCountOnly();
    }

    public Metric sample(double value) {
        ++this.count;
        this.total = this.total + value;
        this.isCountOnly = false;
        this.setMin(value);
        this.setMax(value);
        this.addSumOfSquares(value);
        return this;
    }

    public Metric sampleMetricDataUsage(double bytesSent, double byteReceived) {
        ++this.count;
        this.total = this.total + bytesSent;
        this.exclusive = this.exclusive + byteReceived;
        this.sumOfSquares = 0.0;
        this.min = 0.0;
        this.max = 0.0;
        return this;
    }

    public Metric aggregate(Metric metric) {
        if (metric != null) {
            this.increment(metric.getCount());
            if (!metric.isCountOnly()) {
                this.total = this.total + metric.getTotal();
                this.sumOfSquares = this.sumOfSquares + metric.getSumOfSquares();
                this.exclusive = this.exclusive + metric.getExclusive();
                if (!metric.min.isNaN()) {
                    this.setMin(metric.min);
                }
                if (!metric.max.isNaN()) {
                    this.setMax(metric.max);
                }
            }
        } else {
            log.error("Metric.aggregate() called with null metric!");
        }
        return this;
    }

    public Metric increment(long value) {
        if (value > 0L) {
            this.count += value;
        } else {
            log.error("Metric.increment() called with value[" + value + "] less then or equal to zero");
        }
        return this;
    }

    public Metric increment() {
        this.increment(1L);
        return this;
    }

    public Metric addSumOfSquares(double value) {
        double valueSquared = Math.pow(value, 2.0);
        this.sumOfSquares = this.sumOfSquares.isNaN() ? valueSquared : this.sumOfSquares + valueSquared;
        return this;
    }

    public Metric addExclusive(double value) {
        this.exclusive = this.exclusive + value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public String getStringScope() {
        return this.scope == null ? "" : this.scope;
    }

    public double getMin() {
        return this.min.isNaN() ? 0.0 : this.min;
    }

    public double getMax() {
        return this.max.isNaN() ? 0.0 : this.max;
    }

    public double getTotal() {
        return this.total;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getExclusive() {
        return this.exclusive;
    }

    public long getCount() {
        return this.count;
    }

    public Metric setName(String name) {
        this.name = name == null ? "" : name;
        return this;
    }

    public Metric setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public Metric setMin(double value) {
        this.min = this.min.isNaN() ? value : Math.min(this.min, value);
        return this;
    }

    public Metric setMinFieldValue(double value) {
        this.min = value;
        return this;
    }

    public Metric setMax(double value) {
        this.max = this.max.isNaN() ? value : Math.max(this.max, value);
        return this;
    }

    public Metric setMaxFieldValue(double value) {
        this.max = value;
        return this;
    }

    public Metric setTotal(double value) {
        this.total = value;
        return this;
    }

    public Metric setSumOfSquares(double value) {
        if (value >= 0.0) {
            this.sumOfSquares = value;
        } else {
            log.error("Metric.setSumOfSquares() called with negative value[" + value + "]");
        }
        return this;
    }

    public Metric setExclusive(double value) {
        if (value >= 0.0) {
            this.exclusive = value;
        } else {
            log.error("Metric.setExclusive() called with negative value[" + value + "]");
        }
        return this;
    }

    public Metric setCount(long value) {
        if (value >= 0L) {
            this.count = value;
        } else {
            log.error("Metric.setCount() called with negative value[" + value + "]");
        }
        return this;
    }

    public void clear() {
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.total = 0.0;
        this.sumOfSquares = 0.0;
        this.exclusive = 0.0;
        this.count = 0L;
        this.isCountOnly = true;
    }

    public boolean isCountOnly() {
        return this.isCountOnly;
    }

    public boolean isScoped() {
        return this.scope != null;
    }

    public boolean isUnscoped() {
        return !this.isScoped();
    }

    @Override
    public JsonElement asJson() {
        if (this.isCountOnly()) {
            return new JsonPrimitive(this.count);
        }
        return this.asJsonObject();
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("count", new JsonPrimitive(this.count));
        if (!this.isCountOnly) {
            jsonObject.add("total", new JsonPrimitive(this.total));
            if (!this.min.isNaN()) {
                jsonObject.add("min", new JsonPrimitive(this.min));
            }
            if (!this.max.isNaN()) {
                jsonObject.add("max", new JsonPrimitive(this.max));
            }
            jsonObject.add("sum_of_squares", new JsonPrimitive(this.sumOfSquares));
            jsonObject.add("exclusive", new JsonPrimitive(this.exclusive));
        }
        return jsonObject;
    }

    public String toString() {
        return "Metric{count=" + this.count + ", total=" + this.total + ", max=" + this.max + ", min=" + this.min + ", scope='" + this.scope + "', name='" + this.name + "', exclusive='" + this.exclusive + "', sumofsquares='" + this.sumOfSquares + "'}";
    }
}

