/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.mobile.fbs.ios;

import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Library
extends Table {
    public static Library getRootAsLibrary(ByteBuffer _bb) {
        return Library.getRootAsLibrary(_bb, new Library());
    }

    public static Library getRootAsLibrary(ByteBuffer _bb, Library obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public Library __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long uuidLow() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateUuidLow(long uuidLow) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, uuidLow);
            return true;
        }
        return false;
    }

    public long uuidHigh() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateUuidHigh(long uuidHigh) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, uuidHigh);
            return true;
        }
        return false;
    }

    public long address() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateAddress(long address) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, address);
            return true;
        }
        return false;
    }

    public boolean userLibrary() {
        int o = this.__offset(10);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean mutateUserLibrary(boolean userLibrary) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)(userLibrary ? 1 : 0));
            return true;
        }
        return false;
    }

    public int arch() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.get(o + this.bb_pos) & 0xFF : 0;
    }

    public boolean mutateArch(int arch) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, (byte)arch);
            return true;
        }
        return false;
    }

    public long size() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateSize(long size) {
        int o = this.__offset(14);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, size);
            return true;
        }
        return false;
    }

    public String path() {
        int o = this.__offset(16);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer pathAsByteBuffer() {
        return this.__vector_as_bytebuffer(16, 1);
    }

    public ByteBuffer pathInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 16, 1);
    }

    public static int createLibrary(FlatBufferBuilder builder, long uuidLow, long uuidHigh, long address, boolean userLibrary, int arch, long size, int pathOffset) {
        builder.startObject(7);
        Library.addSize(builder, size);
        Library.addAddress(builder, address);
        Library.addUuidHigh(builder, uuidHigh);
        Library.addUuidLow(builder, uuidLow);
        Library.addPath(builder, pathOffset);
        Library.addArch(builder, arch);
        Library.addUserLibrary(builder, userLibrary);
        return Library.endLibrary(builder);
    }

    public static void startLibrary(FlatBufferBuilder builder) {
        builder.startObject(7);
    }

    public static void addUuidLow(FlatBufferBuilder builder, long uuidLow) {
        builder.addLong(0, uuidLow, 0L);
    }

    public static void addUuidHigh(FlatBufferBuilder builder, long uuidHigh) {
        builder.addLong(1, uuidHigh, 0L);
    }

    public static void addAddress(FlatBufferBuilder builder, long address) {
        builder.addLong(2, address, 0L);
    }

    public static void addUserLibrary(FlatBufferBuilder builder, boolean userLibrary) {
        builder.addBoolean(3, userLibrary, false);
    }

    public static void addArch(FlatBufferBuilder builder, int arch) {
        builder.addByte(4, (byte)arch, 0);
    }

    public static void addSize(FlatBufferBuilder builder, long size) {
        builder.addLong(5, size, 0L);
    }

    public static void addPath(FlatBufferBuilder builder, int pathOffset) {
        builder.addOffset(6, pathOffset, 0);
    }

    public static int endLibrary(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }

    public static void finishLibraryBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedLibraryBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }
}

