/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class HttpHeaders {
    protected static final AtomicReference<HttpHeaders> instance = new AtomicReference<HttpHeaders>(new HttpHeaders());
    private final Set<String> httpHeaders = new HashSet<String>();
    public static final String OPERATION_NAME = "operationName";
    public static final String OPERATION_TYPE = "operationType";
    public static final String OPERATION_ID = "operationId";

    private HttpHeaders() {
        this.httpHeaders.add("X-APOLLO-OPERATION-NAME");
        this.httpHeaders.add("X-APOLLO-OPERATION-ID");
        this.httpHeaders.add("X-APOLLO-OPERATION-TYPE");
    }

    public static HttpHeaders getInstance() {
        return instance.get();
    }

    public void addHttpHeaderAsAttribute(String httpHeader) {
        this.httpHeaders.add(httpHeader);
    }

    public void removeHttpHeaderAsAttribute(String httpHeader) {
        if (!("X-APOLLO-OPERATION-ID".equalsIgnoreCase(httpHeader) || "X-APOLLO-OPERATION-NAME".equalsIgnoreCase(httpHeader) || "X-APOLLO-OPERATION-TYPE".equalsIgnoreCase(httpHeader))) {
            this.httpHeaders.remove(httpHeader);
        }
    }

    public boolean addHttpHeadersAsAttributes(List<String> httpHeaders) {
        return this.httpHeaders.addAll(httpHeaders);
    }

    public Set<String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public static String translateApolloHeader(String s) {
        switch (s) {
            case "X-APOLLO-OPERATION-NAME": {
                return OPERATION_NAME;
            }
            case "X-APOLLO-OPERATION-ID": {
                return OPERATION_ID;
            }
            case "X-APOLLO-OPERATION-TYPE": {
                return OPERATION_TYPE;
            }
        }
        return s;
    }
}

