/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.aei;

import com.newrelic.agent.android.logging.AgentLogManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AEITrace {
    static final Pattern TRACE_HEADER_REGEXP = Pattern.compile(".*----- pid (?<pid>.\\d+) at (?<timeCreated>\\d{4}-\\d{2}-\\d{2}[T ]{0,}[0-9:.-]+) -----(?<body>.*$)");
    static final Pattern TRACE_THREADS_REGEXP = Pattern.compile(".*DALVIK THREADS \\((?<threadCnt>\\d+)\\):\\s(.*)----- end (\\d+) -----", 8);
    static final Pattern TRACE_THREAD_ID_REGEXP = Pattern.compile("^\"(?<threadName>.*)\" (.*)prio=(\\d+).*$");
    final ArrayList<String> threads = new ArrayList();
    String pid;
    String createTime;

    public AEITrace() {
    }

    public AEITrace(File filePath) {
        this();
    }

    public AEITrace(int pid, File artifact) {
        this(artifact);
        this.pid = String.valueOf(pid);
    }

    public AEITrace decomposeFromSystemTrace(String sysTrace) {
        Matcher headerMatcher = TRACE_HEADER_REGEXP.matcher(sysTrace = sysTrace.strip().replace('\n', '\t'));
        if (headerMatcher.matches()) {
            if (null == this.pid || this.pid.isBlank()) {
                this.pid = headerMatcher.group(1);
            }
            this.createTime = headerMatcher.group(2).strip();
        } else {
            AgentLogManager.getAgentLog().debug("The trace file does not contain the expected file header.");
        }
        Matcher threadsMatcher = TRACE_THREADS_REGEXP.matcher(sysTrace);
        if (threadsMatcher.matches()) {
            String threadData = threadsMatcher.group(2).strip();
            this.parseThreadsData(threadData);
        } else {
            AgentLogManager.getAgentLog().error("The trace file does not contain the expected threads data.");
        }
        return this;
    }

    private ArrayList<String> parseThreadsData(String threadData) {
        if (threadData != null && !threadData.isEmpty()) {
            this.threads.addAll(List.of(threadData.split("\t\t")));
            this.threads.removeIf(s -> !TRACE_THREAD_ID_REGEXP.matcher((CharSequence)s).matches());
            this.threads.replaceAll(s -> {
                String[] frames = s.split("\t");
                return Arrays.stream(frames).filter(s1 -> !s1.trim().matches("[(|-].*")).collect(Collectors.joining("\n"));
            });
        }
        return this.threads;
    }

    public ArrayList<String> getThreads() {
        return this.threads;
    }

    public String getPid() {
        return this.pid;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        String flattenedThreads = this.threads.stream().collect(Collectors.joining("\n\n"));
        return flattenedThreads;
    }
}

