/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.aei;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.payload.FileBackedPayload;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class AEITraceSender
extends PayloadSender {
    static final String AEI_COLLECTOR_PATH = "/mobile/errors?protocol_version=1&platform=native&type=application_exit";
    static final int COLLECTOR_TIMEOUT = 5000;

    public AEITraceSender(String aeiTrace, AgentConfiguration agentConfiguration) {
        super(aeiTrace.getBytes(), agentConfiguration);
        this.setPayload(aeiTrace.getBytes());
    }

    public AEITraceSender(File traceDataFile, AgentConfiguration agentConfiguration) {
        super(traceDataFile.getAbsolutePath().getBytes(StandardCharsets.UTF_8), agentConfiguration);
        this.payload = new FileBackedPayload(traceDataFile);
    }

    @Override
    protected HttpURLConnection getConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.getCollectorURI().toURL().openConnection();
        HarvestConfiguration harvestConfiguration = Harvest.getHarvestConfiguration();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("Content-Encoding", "identity");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("X-App-License-Key", this.agentConfiguration.getApplicationToken());
        connection.setRequestProperty("X-NewRelic-Account-Id", harvestConfiguration.getAccount_id());
        connection.setRequestProperty("X-NewRelic-Trusted-Account-Id", harvestConfiguration.getTrusted_account_key());
        connection.setRequestProperty("X-NewRelic-Entity-Guid", harvestConfiguration.getEntity_guid());
        connection.setRequestProperty("X-NewRelic-OS-Name", Agent.getDeviceInformation().getOsName());
        connection.setRequestProperty("X-NewRelic-App-Version", Agent.getApplicationInformation().getAppVersion());
        Map<String, String> requestHeaders = Harvest.getHarvestConfiguration().getRequest_headers_map();
        for (Map.Entry<String, String> stringStringEntry : requestHeaders.entrySet()) {
            connection.setRequestProperty(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        return connection;
    }

    @Override
    public PayloadSender call() {
        try {
            return super.call();
        }
        catch (Exception e) {
            this.onFailedUpload("Unable to report AEI trace to New Relic, will try again later. " + e);
            return this;
        }
    }

    @Override
    protected void onRequestResponse(HttpURLConnection connection) throws IOException {
        super.onRequestResponse(connection);
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: 
            case 202: {
                StatsEngine.SUPPORTABILITY.sampleTimeMs("Supportability/AgentHealth/ApplicationExitInfo/UploadTime", this.timer.peek());
                break;
            }
            case 413: {
                FileBackedPayload fileBackedPayload = (FileBackedPayload)this.payload;
                fileBackedPayload.compress(true);
            }
        }
        log.debug("AEITraceSender: data reporting took " + this.timer.toc() + "ms");
    }

    @Override
    protected void onFailedUpload(String errorMsg) {
        log.error("AEITraceSender: " + errorMsg);
        StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/FailedUpload");
    }

    @Override
    protected void onRequestException(Exception e) {
        log.error("AEITraceSender: Crash upload failed: " + e);
        StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/ApplicationExitInfo/FailedUpload");
    }

    @Override
    protected boolean shouldUploadOpportunistically() {
        return Agent.hasReachableNetworkConnection(null);
    }

    @Override
    protected URI getCollectorURI() {
        return URI.create(this.getProtocol() + this.agentConfiguration.getCollectorHost() + AEI_COLLECTOR_PATH);
    }

    @Override
    public boolean shouldRetry() {
        return true;
    }
}

