/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.distributedtracing;

import com.newrelic.agent.android.distributedtracing.DistributedTracing;
import com.newrelic.agent.android.distributedtracing.TraceContext;
import com.newrelic.agent.android.distributedtracing.TraceHeader;
import java.util.Locale;

public abstract class TraceParent
implements TraceHeader {
    public static final String TRACE_PARENT_HEADER = "traceparent";
    static final int TRACE_PARENT_VERSION = 0;
    static final String TRACE_PARENT_HEADER_FMT = "%s-%s-%s-%s";
    final TraceContext traceContext;
    final String parentId;

    public static TraceParent createTraceParent(TraceContext traceContext) {
        return new W3CTraceParent(traceContext);
    }

    protected TraceParent(TraceContext traceContext) {
        this.traceContext = traceContext;
        this.parentId = DistributedTracing.generateSpanId();
    }

    @Override
    public String getHeaderName() {
        return TRACE_PARENT_HEADER;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getVersion() {
        return String.format(Locale.ROOT, "%02x", 0);
    }

    static class W3CTraceParent
    extends TraceParent {
        static final String TRACE_PARENT_HEADER_REGEX = "^(\\d+)-([A-Fa-f0-9]{32})-([A-Fa-f0-9]{16})?-(\\d+)$";

        W3CTraceParent(TraceContext traceContext) {
            super(traceContext);
        }

        @Override
        public String getHeaderValue() {
            return String.format(Locale.ROOT, TraceParent.TRACE_PARENT_HEADER_FMT, this.getVersion(), this.traceContext.traceId, this.parentId, this.traceContext.getSampled());
        }
    }
}

