/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.logging.LogLevel;
import com.newrelic.agent.android.logging.LogReporting;
import java.util.Map;

public interface Logger {
    public static final String TAG = "newrelic";

    default public boolean isLevelEnabled(LogLevel logLevel) {
        return LogReporting.isLevelEnabled(logLevel);
    }

    default public void log(LogLevel level, String message) {
        if (LogReporting.isLevelEnabled(level)) {
            AgentLog agentLog = AgentLogManager.getAgentLog();
            switch (level) {
                case ERROR: {
                    agentLog.error(message);
                    break;
                }
                case WARN: {
                    agentLog.warn(message);
                    break;
                }
                case INFO: {
                    agentLog.info(message);
                    break;
                }
                case VERBOSE: {
                    agentLog.verbose(message);
                    break;
                }
                case DEBUG: {
                    agentLog.debug(message);
                }
            }
        }
    }

    default public void logThrowable(LogLevel logLevel, String message, Throwable throwable) {
    }

    default public void logAttributes(Map<String, Object> attributes) {
    }

    default public void logAll(Throwable throwable, Map<String, Object> attributes) {
    }
}

