/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.payload;

import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.util.Streams;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;

public class FileBackedPayload
extends Payload {
    boolean isCompressed = false;

    public FileBackedPayload(File payloadFile) {
        super(payloadFile.getAbsolutePath().getBytes(StandardCharsets.UTF_8));
        this.uuid = payloadFile.getAbsolutePath();
        if (payloadFile.exists()) {
            this.timestamp = payloadFile.lastModified();
            this.isPersistable = payloadFile.canWrite();
            this.isCompressed = FileBackedPayload.isCompressed(payloadFile);
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            File payloadFile = this.payloadFile();
            if (payloadFile.exists()) {
                return Streams.readAllBytes(payloadFile);
            }
        }
        catch (IOException e) {
            AgentLogManager.getAgentLog().error("FileBackedPayload: failed to read payload. " + e);
        }
        return "".getBytes(StandardCharsets.UTF_8);
    }

    protected File payloadFile() {
        return new File(this.uuid);
    }

    @Override
    public void putBytes(byte[] payloadBytes) {
        if (this.isPersisted()) {
            try (BufferedWriter writer = Streams.newBufferedFileWriter(this.payloadFile());){
                writer.write(new String(payloadBytes, StandardCharsets.UTF_8));
                writer.flush();
            }
            catch (IOException e) {
                AgentLogManager.getAgentLog().error("FileBackedPayload: failed to write payload to backing file." + e);
            }
        } else {
            super.putBytes(payloadBytes);
        }
    }

    @Override
    public long getTimestamp() {
        return this.payloadFile().lastModified();
    }

    @Override
    public void setPersisted(boolean isPersistable) {
        if (!isPersistable) {
            this.payloadFile().delete();
        }
    }

    @Override
    public long size() {
        File payloadFile = this.payloadFile();
        return payloadFile.exists() ? payloadFile.length() : 0L;
    }

    public File compress(boolean replace) throws IOException {
        return this.compress(this.payloadFile(), replace);
    }

    public File compress(File payloadFile, boolean replace) throws IOException {
        File compressedFile = new File(payloadFile.getAbsolutePath() + ".gz");
        try (FileInputStream fis = new FileInputStream(payloadFile);
             FileOutputStream fos = new FileOutputStream(compressedFile);
             GZIPOutputStream gzOut = new GZIPOutputStream((OutputStream)fos, 65536, true);){
            Streams.copy(fis, gzOut);
            gzOut.flush();
            if (replace && payloadFile.delete()) {
                this.isCompressed = true;
                if (compressedFile.renameTo(payloadFile)) {
                    compressedFile = payloadFile;
                }
            }
        }
        return compressedFile;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public static boolean isCompressed(File payloadFile) {
        boolean bl;
        FileInputStream fis = new FileInputStream(payloadFile);
        try {
            byte[] buf = new byte[10];
            fis.read(buf, 0, 9);
            bl = buf[0] == 31 && buf[1] == -117;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                AgentLogManager.getAgentLog().error("FileBackedPayload: isCompressed() - " + e);
                return false;
            }
        }
        fis.close();
        return bl;
    }
}

