/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stats;

import java.util.concurrent.TimeUnit;

public class TicToc {
    private long startTime;
    private long endTime;
    private State state;

    public TicToc tic() {
        this.state = State.STARTED;
        long nanoTime = System.nanoTime();
        this.startTime = TimeUnit.MILLISECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
        return this;
    }

    public long toc() {
        long nanoTime = System.nanoTime();
        this.endTime = TimeUnit.MILLISECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
        if (this.state == State.STARTED) {
            this.state = State.STOPPED;
            return this.endTime - this.startTime;
        }
        return -1L;
    }

    public long peek() {
        long nanoTime = System.nanoTime();
        long endTime = TimeUnit.MILLISECONDS.convert(nanoTime, TimeUnit.NANOSECONDS);
        return this.state == State.STARTED ? endTime - this.startTime : 0L;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected long getEndTime() {
        return this.endTime;
    }

    protected void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    protected State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    public long duration() {
        return this.state == State.STARTED ? this.peek() : System.currentTimeMillis() - this.startTime;
    }

    protected static enum State {
        STOPPED,
        STARTED;

    }
}

