/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.stores;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressLint(value={"NewApi"})
public abstract class SharedPrefsStore {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected static final Charset ENCODING = Charset.forName("ISO-8859-1");
    protected final SharedPreferences sharedPrefs;
    protected final String storeFilename;

    public SharedPrefsStore(Context context, String storeFilename) {
        this.sharedPrefs = context.getSharedPreferences(storeFilename, 0);
        this.storeFilename = storeFilename;
    }

    public String getStoreFilename() {
        return this.storeFilename;
    }

    public boolean store(String uuid, byte[] bytes) {
        try {
            SharedPreferences.Editor editor = this.sharedPrefs.edit();
            editor.putString(uuid, this.decodeBytesToString(bytes));
            return this.applyOrCommitEditor(editor);
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.store(String, byte[]): ", e);
            return false;
        }
    }

    public boolean store(String uuid, Set<String> stringSet) {
        try {
            SharedPreferences.Editor editor = this.sharedPrefs.edit();
            editor.putStringSet(uuid, stringSet);
            return this.applyOrCommitEditor(editor);
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.store(String, Set<String>): ", e);
            return false;
        }
    }

    public boolean store(String uuid, String string) {
        try {
            SharedPreferences.Editor editor = this.sharedPrefs.edit();
            editor.putString(uuid, string);
            return this.applyOrCommitEditor(editor);
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.store(String, String): ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> fetchAll() {
        ArrayList objectList = new ArrayList();
        try {
            SharedPrefsStore sharedPrefsStore = this;
            synchronized (sharedPrefsStore) {
                Map objectStrings = this.sharedPrefs.getAll();
                objectList.addAll(objectStrings.values());
            }
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.fetchAll(): ", e);
        }
        return objectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        try {
            SharedPreferences sharedPreferences = this.sharedPrefs;
            synchronized (sharedPreferences) {
                return this.sharedPrefs.getAll().size();
            }
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.count(): ", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            SharedPrefsStore sharedPrefsStore = this;
            synchronized (sharedPrefsStore) {
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                editor.clear();
                this.applyOrCommitEditor(editor);
            }
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.clear(): ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String uuid) {
        try {
            SharedPrefsStore sharedPrefsStore = this;
            synchronized (sharedPrefsStore) {
                SharedPreferences.Editor editor = this.sharedPrefs.edit();
                editor.remove(uuid);
                this.applyOrCommitEditor(editor);
            }
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.delete(): ", e);
        }
    }

    protected String encodeBytes(byte[] bytes) {
        try {
            return Base64.encodeToString((byte[])bytes, (int)2);
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.encodeBytes(byte[]): ", e);
            return null;
        }
    }

    protected byte[] decodeStringToBytes(String encodedString) {
        try {
            return Base64.decode((String)encodedString, (int)0);
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.decodeStringToBytes(String): ", e);
            return null;
        }
    }

    protected String decodeBytesToString(byte[] decodedString) {
        try {
            return new String(decodedString, ENCODING);
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.decodeBytesToString(byte[]): ", e);
            return null;
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    protected boolean applyOrCommitEditor(SharedPreferences.Editor editor) {
        boolean result = true;
        try {
            editor.apply();
        }
        catch (Exception e) {
            log.error("SharedPrefsStore.applyOrCommitEditor(SharedPreferences.Editor): ", e);
        }
        return result;
    }
}

