/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Stream;

public class Streams {
    public static final int DEFAULT_BUFFER_SIZE = 65536;

    private Streams() {
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 65536, false);
    }

    public static int copy(InputStream input, OutputStream output, boolean closeStreams) throws IOException {
        return Streams.copy(input, output, 65536, closeStreams);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return Streams.copy(input, output, bufferSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean closeStreams) throws IOException {
        try {
            int n;
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (closeStreams) {
                input.close();
                output.close();
            }
        }
    }

    public static byte[] slurpBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Streams.copy(in, out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static String slurpString(InputStream in) throws IOException {
        return Streams.slurpString(in, StandardCharsets.UTF_8.name());
    }

    public static String slurpString(InputStream in, String encoding) throws IOException {
        return new String(Streams.slurpBytes(in), null == encoding || encoding.isEmpty() ? StandardCharsets.UTF_8.name() : encoding);
    }

    public static String slurpString(File file, String encoding) throws IOException {
        return Streams.slurpString(new FileInputStream(file), encoding);
    }

    public static String[] readAllLines(File file) throws IOException {
        String[] lines = new String[]{};
        try (BufferedReader br = Streams.newBufferedFileReader(file);){
            lines = (String[])br.lines().map(Object::toString).toArray(String[]::new);
        }
        return lines;
    }

    public static Stream<String> lines(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        return br.lines();
    }

    public static byte[] readAllBytes(File file) throws IOException {
        return Streams.slurpBytes(new FileInputStream(file));
    }

    public static BufferedReader newBufferedFileReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedWriter newBufferedFileWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file));
    }

    public static Stream<File> list(File rootDir) throws IllegalArgumentException {
        return Streams.list(rootDir, pathname -> true);
    }

    public static Stream<File> list(File rootDir, FileFilter filter) throws IllegalArgumentException {
        if (null == rootDir) {
            throw new IllegalArgumentException("Invalid file argument: file is null");
        }
        if (!rootDir.exists()) {
            throw new IllegalArgumentException("Invalid file argument: file does not exist");
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid file argument: file is not a directory");
        }
        if (null == filter) {
            filter = pathname -> false;
        }
        return Arrays.stream(rootDir.listFiles(filter));
    }
}

