/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.mobile.fbs.jserror;

import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Frame
extends Table {
    public static Frame getRootAsFrame(ByteBuffer _bb) {
        return Frame.getRootAsFrame(_bb, new Frame());
    }

    public static Frame getRootAsFrame(ByteBuffer _bb, Frame obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        this.vtable_start = this.bb_pos - this.bb.getInt(this.bb_pos);
        this.vtable_size = this.bb.getShort(this.vtable_start);
    }

    public Frame __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String method() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer methodAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer methodInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public String fileName() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer fileNameAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer fileNameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public int lineNumber() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateLineNumber(int lineNumber) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, lineNumber);
            return true;
        }
        return false;
    }

    public int column() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean mutateColumn(int column) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putInt(o + this.bb_pos, column);
            return true;
        }
        return false;
    }

    public static int createFrame(FlatBufferBuilder builder, int methodOffset, int fileNameOffset, int lineNumber, int column) {
        builder.startObject(4);
        Frame.addColumn(builder, column);
        Frame.addLineNumber(builder, lineNumber);
        Frame.addFileName(builder, fileNameOffset);
        Frame.addMethod(builder, methodOffset);
        return Frame.endFrame(builder);
    }

    public static void startFrame(FlatBufferBuilder builder) {
        builder.startObject(4);
    }

    public static void addMethod(FlatBufferBuilder builder, int methodOffset) {
        builder.addOffset(0, methodOffset, 0);
    }

    public static void addFileName(FlatBufferBuilder builder, int fileNameOffset) {
        builder.addOffset(1, fileNameOffset, 0);
    }

    public static void addLineNumber(FlatBufferBuilder builder, int lineNumber) {
        builder.addInt(2, lineNumber, 0);
    }

    public static void addColumn(FlatBufferBuilder builder, int column) {
        builder.addInt(3, column, 0);
    }

    public static int endFrame(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

