/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.aei;

import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.util.Streams;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AEISessionMapper {
    static final Gson gson = new GsonBuilder().create();
    final File mapStore;
    final Map<Integer, AEISessionMeta> mapper;

    public AEISessionMapper(File mapStore) {
        this.mapStore = mapStore;
        this.mapper = new HashMap<Integer, AEISessionMeta>();
        if (mapStore.exists()) {
            this.load();
        }
    }

    public AEISessionMapper put(int pid, AEISessionMeta model) {
        if (model != null && model.sessionId != null && !model.sessionId.isEmpty()) {
            this.mapper.put(pid, model);
        } else {
            AgentLogManager.getAgentLog().debug("Refusing to store null or empty session model for pid[" + pid + "]");
        }
        return this;
    }

    public AEISessionMeta get(int pid) {
        return this.mapper.getOrDefault(pid, null);
    }

    public String getSessionId(int pid) {
        AEISessionMeta model = this.get(pid);
        return model == null ? "" : model.sessionId;
    }

    public int getRealAgentID(int pid) {
        AEISessionMeta model = this.get(pid);
        return model == null ? 0 : model.realAgentId;
    }

    public String getOrDefault(int pid, String defaultSessionId) {
        AEISessionMeta model = this.get(pid);
        return model == null || model.sessionId == null || model.sessionId.isEmpty() ? defaultSessionId : model.sessionId;
    }

    public AEISessionMapper load() {
        if (this.mapStore.exists() && this.mapStore.canRead()) {
            try {
                String storeData = Streams.slurpString(this.mapStore, StandardCharsets.UTF_8.toString());
                Type gtype = new TypeToken<Map<Integer, AEISessionMeta>>(){}.getType();
                Map map = (Map)gson.fromJson(storeData, gtype);
                map.forEach((key, val) -> this.mapper.putIfAbsent((Integer)key, (AEISessionMeta)val));
            }
            catch (Exception e) {
                AgentLogManager.getAgentLog().error("Cannot read session ID mapper: " + e);
            }
        } else {
            AgentLogManager.getAgentLog().debug("Cannot read session ID mapper: file does not exist or is unreadable");
        }
        return this;
    }

    public boolean flush() {
        if (this.mapper.isEmpty()) {
            this.mapStore.delete();
        } else {
            try (BufferedWriter os = Streams.newBufferedFileWriter(this.mapStore);){
                os.write(gson.toJson(this.mapper));
                os.flush();
            }
            catch (IOException e) {
                AgentLogManager.getAgentLog().error("Cannot write session ID mapping file: " + e);
            }
        }
        return this.mapStore.exists() && this.mapStore.canRead();
    }

    public void clear() {
        this.mapper.clear();
    }

    public void delete() {
        if (this.mapStore.exists()) {
            this.mapStore.delete();
        }
    }

    public void erase(int pid) {
        this.mapper.remove(pid);
    }

    public int size() {
        return this.mapper.size();
    }

    public synchronized void erase(Set<Integer> pidSet) {
        Set<Integer> currentKeySet = this.mapper.keySet();
        currentKeySet.stream().filter(pid -> !pidSet.contains(pid)).collect(Collectors.toSet()).forEach(pid -> this.mapper.remove(pid));
    }

    public static class AEISessionMeta {
        final String sessionId;
        final int realAgentId;

        public AEISessionMeta(String sessionId, int realAgentId) {
            this.sessionId = sessionId == null ? "" : sessionId;
            this.realAgentId = realAgentId;
        }

        public boolean isValid() {
            return this.sessionId != null && !this.sessionId.isEmpty() && this.realAgentId != 0;
        }
    }
}

