/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.aei;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.aei.AEITrace;
import com.newrelic.agent.android.aei.AEITraceSender;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.payload.PayloadReporter;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.Streams;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class AEITraceReporter
extends PayloadReporter {
    protected static AtomicReference<AEITraceReporter> instance = new AtomicReference<Object>(null);
    static final String TRACE_DATA_DIR = "aeitrace/";
    static final String FILE_MASK = "threads-%s.dat";
    static long reportTTL = TimeUnit.SECONDS.convert(2L, TimeUnit.DAYS);
    File traceStore = new File(System.getProperty("java.io.tmpdir", "/tmp"), "aeitrace/").getAbsoluteFile();
    protected final Callable reportCachedAgentDataCallable = () -> {
        this.postCachedAgentData();
        if (this.getCachedTraces().isEmpty()) {
            AEITraceReporter.shutdown();
        }
        return null;
    };

    public static AEITraceReporter getInstance() {
        return instance.get();
    }

    public static AEITraceReporter initialize(File rootDir, AgentConfiguration agentConfiguration) throws IOException {
        if (!(rootDir.isDirectory() && rootDir.exists() && rootDir.canWrite())) {
            throw new IOException("Trace reports directory [" + rootDir.getAbsolutePath() + "] must exist and be writable!");
        }
        if (instance.compareAndSet(null, new AEITraceReporter(agentConfiguration))) {
            AEITraceReporter instance = AEITraceReporter.getInstance();
            instance.traceStore = new File(rootDir, TRACE_DATA_DIR);
            instance.traceStore.mkdirs();
            if (!instance.traceStore.exists() || !instance.traceStore.canWrite()) {
                throw new IOException("AEI: Threads directory [" + rootDir.getAbsolutePath() + "] must exist and be writable!");
            }
            log.debug("AEI: saving AEI trace data to " + instance.traceStore.getAbsolutePath());
            log.debug("AEI: reporter instance initialized");
        }
        return instance.get();
    }

    protected static boolean isInitialized() {
        return instance.get() != null;
    }

    protected AEITraceReporter(AgentConfiguration agentConfiguration) {
        super(agentConfiguration);
        this.setEnabled(agentConfiguration.getApplicationExitConfiguration().isEnabled());
    }

    @Override
    public void start() {
        if (AEITraceReporter.isInitialized()) {
            if (this.isStarted.compareAndSet(false, true)) {
                Harvest.addHarvestListener(instance.get());
                this.isStarted.set(true);
            } else {
                log.error("AEITraceReporter: failed to initialize.");
            }
        }
    }

    @Override
    protected void stop() {
        if (this.isStarted()) {
            Harvest.removeHarvestListener(instance.get());
            this.isStarted.set(false);
        }
    }

    public static void shutdown() {
        if (AEITraceReporter.isInitialized()) {
            instance.get().stop();
            instance.set(null);
        }
    }

    public void reportAEITrace(String aeiError, int pid) {
        this.reportAEITrace(aeiError, this.generateUniqueDataFilename(pid));
    }

    public void reportAEITrace(String aeiError, File artifact) {
        try (FileOutputStream artifactOs = new FileOutputStream(artifact, false);){
            ((OutputStream)artifactOs).write(aeiError.getBytes(StandardCharsets.UTF_8));
            artifactOs.flush();
            ((OutputStream)artifactOs).close();
            artifact.setReadOnly();
        }
        catch (IOException e) {
            log.debug("AEITraceReporter: AppExitInfo artifact error. " + e);
        }
    }

    protected void postCachedAgentData() {
        if (AEITraceReporter.isInitialized() && Agent.hasReachableNetworkConnection(null)) {
            this.getCachedTraces().forEach(traceDataFile -> {
                if (this.postAEITrace((File)traceDataFile)) {
                    log.info("AEI: Uploaded trace data [" + traceDataFile.getAbsolutePath() + "]");
                    if (this.safeDelete((File)traceDataFile)) {
                        log.debug("AEI: Trace data artifact[" + traceDataFile.getName() + "] removed from device");
                    }
                } else {
                    log.error("AEITraceReporter: upload failed for trace data [" + traceDataFile.getAbsolutePath() + "]");
                }
            });
        }
        this.expire(Math.toIntExact(reportTTL));
    }

    boolean postAEITrace(File traceDataFile) {
        boolean hasValidDataToken = Harvest.getHarvestConfiguration().getDataToken().isValid();
        if (hasValidDataToken) {
            try {
                if (traceDataFile.exists()) {
                    AEITraceSender traceSender = new AEITraceSender(traceDataFile, this.agentConfiguration);
                    switch (traceSender.call().getResponseCode()) {
                        case 408: {
                            break;
                        }
                        case 413: {
                            break;
                        }
                        case 429: {
                            break;
                        }
                        case 500: {
                            break;
                        }
                    }
                    return traceSender.isSuccessfulResponse();
                }
                log.warn("AEI: Trace [" + traceDataFile.getName() + "] vanished before it could be uploaded.");
            }
            catch (Exception e) {
                AgentLogManager.getAgentLog().error("AEI: Trace upload failed: " + e);
            }
        } else {
            log.warn("AEITraceReporter: agent has not successfully connected and cannot report AEITrace. Will retry later");
        }
        return false;
    }

    protected Future postAEITrace(String sysTrace) {
        boolean hasValidDataToken = Harvest.getHarvestConfiguration().getDataToken().isValid();
        if (hasValidDataToken) {
            if (sysTrace != null) {
                AEITrace aeiTrace = new AEITrace().decomposeFromSystemTrace(sysTrace);
                long aeiSize = aeiTrace.toString().getBytes().length;
                if (aeiSize > 1000000L) {
                    DeviceInformation deviceInformation = Agent.getDeviceInformation();
                    String name = "Supportability/Mobile/Android/<framework>/<destination>/MaxPayloadSizeLimit/<subdestination>".replace("<framework>", deviceInformation.getApplicationFramework().name()).replace("<destination>", "Collector").replace("<subdestination>", "errors");
                    StatsEngine.SUPPORTABILITY.inc(name);
                    return null;
                }
                PayloadSender.CompletionHandler completionHandler = new PayloadSender.CompletionHandler(){

                    @Override
                    public void onResponse(PayloadSender payloadSender) {
                        if (payloadSender.isSuccessfulResponse()) {
                            DeviceInformation deviceInformation = Agent.getDeviceInformation();
                            String name = "Supportability/Mobile/Android/<framework>/<destination>/<subdestination>/Output/Bytes".replace("<framework>", deviceInformation.getApplicationFramework().name()).replace("<destination>", "Collector").replace("<subdestination>", "mobile_crash");
                            StatsEngine.get().sampleMetricDataUsage(name, payloadSender.getPayloadSize(), 0.0f);
                        }
                    }

                    @Override
                    public void onException(PayloadSender payloadSender, Exception e) {
                        log.error("AEITraceReporter: AEITrace upload failed: " + e);
                    }
                };
                AEITraceSender sender = new AEITraceSender(aeiTrace.toString(), this.agentConfiguration);
                if (!sender.shouldUploadOpportunistically()) {
                    log.warn("AEITraceReporter: network is unreachable. AEITrace will be uploaded on next app launch");
                }
                return PayloadController.submitPayload(sender, completionHandler);
            }
            log.warn("AEITraceReporter: attempted to report null AEITrace.");
        } else {
            log.error("AEITraceReporter: agent has not successfully connected and cannot report AEITrace.");
        }
        return null;
    }

    @Override
    public void onHarvest() {
        this.postCachedAgentData();
        if (this.getCachedTraces().isEmpty()) {
            AEITraceReporter.shutdown();
        }
    }

    protected Set<File> getCachedTraces() {
        Set<File> reportSet = new HashSet<File>();
        try {
            String fileMask = String.format(Locale.getDefault(), FILE_MASK, "\\d+");
            reportSet = Streams.list(this.traceStore).filter(file -> file.isFile() && file.getName().matches(fileMask)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("AEI:Can't query cached log reports: " + e);
        }
        return reportSet;
    }

    Set<File> expire(long expirationTTL) {
        FileFilter expirationFilter = traceFile -> traceFile.exists() && traceFile.lastModified() + expirationTTL < System.currentTimeMillis();
        Set<File> expiredFiles = Streams.list(this.traceStore, expirationFilter).collect(Collectors.toSet());
        expiredFiles.forEach(threadData -> {
            log.debug("AEI:Thread data [" + threadData.getName() + "] has expired and will be removed.");
            this.safeDelete((File)threadData);
        });
        return expiredFiles;
    }

    boolean safeDelete(File fileToDelete) {
        fileToDelete.setReadOnly();
        fileToDelete.delete();
        return !fileToDelete.exists();
    }

    File generateUniqueDataFilename(int pid) {
        File traceFile;
        int retries = 5;
        while ((traceFile = new File(this.traceStore, String.format(Locale.getDefault(), FILE_MASK, pid))).exists() && 0L < traceFile.length() && retries-- > 0) {
        }
        return traceFile.exists() ? null : traceFile;
    }
}

