/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.aei;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentImpl;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.aei.AEISessionMapper;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.crash.CrashReporter;
import com.newrelic.agent.android.harvest.DataToken;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.crash.ApplicationInfo;
import com.newrelic.agent.android.harvest.crash.DeviceInfo;
import com.newrelic.agent.android.harvest.type.HarvestableObject;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.SafeJsonPrimitive;
import com.newrelic.com.google.gson.Gson;
import com.newrelic.com.google.gson.GsonBuilder;
import com.newrelic.com.google.gson.JsonArray;
import com.newrelic.com.google.gson.JsonElement;
import com.newrelic.com.google.gson.JsonObject;
import com.newrelic.com.google.gson.JsonParser;
import com.newrelic.com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Error
extends HarvestableObject {
    public static final int PROTOCOL_VERSION = 1;
    public static final int MAX_UPLOAD_COUNT = 3;
    private final String agentName;
    private final String agentVersion;
    protected String buildId;
    protected long timestamp;
    private DeviceInfo deviceInfo;
    private ApplicationInfo applicationInfo;
    private Set<AnalyticsAttribute> sessionAttributes;
    private HashMap<String, Object> event;
    private DataToken dataToken;
    private static final Gson gson = new GsonBuilder().create();

    public Error(String buildId, long timestamp) {
        AgentImpl agentImpl = Agent.getImpl();
        this.agentVersion = Agent.getVersion();
        this.buildId = buildId;
        this.timestamp = timestamp;
        this.deviceInfo = new DeviceInfo(agentImpl.getDeviceInformation(), agentImpl.getEnvironmentInformation());
        this.applicationInfo = new ApplicationInfo(agentImpl.getApplicationInformation());
        this.sessionAttributes = new HashSet<AnalyticsAttribute>();
        this.event = new HashMap();
        this.agentName = agentImpl.getDeviceInformation().getAgentName();
        this.dataToken = Harvest.getHarvestConfiguration().getDataToken();
    }

    public Error(Set<AnalyticsAttribute> sessionAttributes, HashMap<String, Object> events) {
        this(sessionAttributes, events, null);
    }

    public Error(Set<AnalyticsAttribute> sessionAttributes, HashMap<String, Object> event, AEISessionMapper.AEISessionMeta sessionMeta) {
        AgentImpl agentImpl = Agent.getImpl();
        this.agentVersion = Agent.getVersion();
        this.buildId = Error.getSafeBuildId();
        this.timestamp = System.currentTimeMillis();
        this.deviceInfo = new DeviceInfo(agentImpl.getDeviceInformation(), agentImpl.getEnvironmentInformation());
        this.applicationInfo = new ApplicationInfo(agentImpl.getApplicationInformation());
        this.sessionAttributes = this.getErrorSessionAttributes(sessionAttributes);
        this.agentName = agentImpl.getDeviceInformation().getAgentName();
        this.event = event;
        this.dataToken = Harvest.getHarvestConfiguration().getDataToken();
        if (sessionMeta != null) {
            this.dataToken.setAgentId(sessionMeta.realAgentId);
        }
    }

    protected String getAppToken() {
        if (CrashReporter.getInstance() != null) {
            return CrashReporter.getInstance().getAgentConfiguration().getApplicationToken();
        }
        return "<missing app token>";
    }

    protected DataToken getDataToken() {
        return this.dataToken;
    }

    public void setDataToken(DataToken dataToken) {
        this.dataToken = dataToken;
    }

    public static String getSafeBuildId() {
        String buildId = Error.getBuildId();
        if (buildId == null || buildId.isEmpty()) {
            buildId = Agent.getBuildId();
            StatsEngine.get().inc("Supportability/AgentHealth/Crash/InvalidBuildId");
            if (buildId == null || buildId.isEmpty()) {
                AgentLogManager.getAgentLog().error("Invalid (null or empty) build ID detected! Crash will be ignored by collector.");
            }
        }
        return buildId;
    }

    public static String getBuildId() {
        return Agent.getBuildId();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setSessionAttributes(Set<AnalyticsAttribute> sessionAttributes) {
        this.sessionAttributes = this.getErrorSessionAttributes(sessionAttributes);
    }

    public Set<AnalyticsAttribute> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setAnalyticsEvents(HashMap<String, Object> event) {
        this.event = event;
    }

    public boolean getIsObfuscated() {
        return Agent.getIsObfuscated();
    }

    public Set<AnalyticsAttribute> getErrorSessionAttributes(Set<AnalyticsAttribute> sessionAttributes) {
        if (sessionAttributes == null) {
            return null;
        }
        HashSet<AnalyticsAttribute> attrs = new HashSet<AnalyticsAttribute>(sessionAttributes);
        if (FeatureFlag.featureEnabled(FeatureFlag.OfflineStorage) && !Agent.hasReachableNetworkConnection(null)) {
            attrs.add(new AnalyticsAttribute("offline", true));
            StatsEngine.notice().inc("Supportability/AgentHealth/OfflineStorage/Crash/Count");
        }
        if (FeatureFlag.featureEnabled(FeatureFlag.BackgroundReporting) && ApplicationStateMonitor.isAppInBackground()) {
            attrs.add(new AnalyticsAttribute("background", true));
            StatsEngine.notice().inc("Supportability/AgentHealth/Background/Crash/Count");
        }
        attrs.add(new AnalyticsAttribute("HarvestAccountId", Harvest.getHarvestConfiguration().getAccount_id()));
        return Collections.unmodifiableSet(attrs);
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObject data = new JsonObject();
        data.add("agentName", new JsonPrimitive(this.agentName));
        data.add("agentVersion", new JsonPrimitive(this.agentVersion));
        data.add("protocolVersion", new JsonPrimitive(1));
        data.add("platform", new JsonPrimitive("Android"));
        data.add("buildId", SafeJsonPrimitive.factory(this.buildId));
        data.add("timestamp", SafeJsonPrimitive.factory(this.timestamp));
        data.add("deviceInfo", this.deviceInfo.asJsonObject());
        data.add("appInfo", this.applicationInfo.asJsonObject());
        JsonObject attributeObject = new JsonObject();
        if (this.sessionAttributes != null) {
            for (AnalyticsAttribute attribute : this.sessionAttributes) {
                attributeObject.add(attribute.getName(), attribute.asJsonElement());
            }
        }
        data.add("sessionAttributes", attributeObject);
        JsonArray eventArray = new JsonArray();
        if (this.event != null) {
            eventArray.add(gson.toJsonTree(this.event));
        }
        data.add("analyticsEvents", eventArray);
        data.add("dataToken", this.dataToken.asJsonArray());
        return data;
    }

    public static Error ErrorFromJsonString(String json) {
        JsonObject errorObject = JsonParser.parseString(json).getAsJsonObject();
        String buildIdentifier = errorObject.get("buildId").getAsString();
        long timestamp = errorObject.get("timestamp").getAsLong();
        Error error = new Error(buildIdentifier, timestamp);
        error.deviceInfo = DeviceInfo.newFromJson(errorObject.get("deviceInfo").getAsJsonObject());
        error.applicationInfo = ApplicationInfo.newFromJson(errorObject.get("appInfo").getAsJsonObject());
        if (errorObject.has("sessionAttributes")) {
            Set<AnalyticsAttribute> sessionAttributes = AnalyticsAttribute.newFromJson(errorObject.get("sessionAttributes").getAsJsonObject());
            error.setSessionAttributes(sessionAttributes);
        }
        if (errorObject.has("analyticsEvents")) {
            ArrayList<HashMap> events = new ArrayList<HashMap>();
            for (JsonElement e : errorObject.get("analyticsEvents").getAsJsonArray()) {
                events.add(gson.fromJson(e, HashMap.class));
            }
            if (!events.isEmpty()) {
                error.setAnalyticsEvents((HashMap)events.get(0));
            }
        }
        error.dataToken = DataToken.newFromJson(errorObject.get("dataToken").getAsJsonArray());
        return error;
    }
}

