/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.agentdata;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.agentdata.AgentDataReporter;
import com.newrelic.agent.android.agentdata.builder.AgentDataBuilder;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.harvest.crash.ApplicationInfo;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.StatsEngine;
import com.newrelic.agent.android.util.ExceptionHelper;
import com.newrelic.com.google.flatbuffers.FlatBufferBuilder;
import com.newrelic.mobile.fbs.HexAgentDataBundle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AgentDataController {
    protected static final AgentConfiguration agentConfiguration = new AgentConfiguration();
    private static final AgentLog log = AgentLogManager.getAgentLog();

    static FlatBufferBuilder buildAgentDataFromHandledException(Throwable e, Map<String, Object> exceptionAttributes) {
        UUID buildUuid;
        HashMap<String, Object> handledException = new HashMap<String, Object>();
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        ApplicationInfo applicationInfo = new ApplicationInfo(Agent.getApplicationInformation());
        try {
            buildUuid = UUID.fromString(Crash.getSafeBuildId());
        }
        catch (IllegalArgumentException ie) {
            buildUuid = UUID.randomUUID();
            ExceptionHelper.recordSupportabilityMetric(ie, "RandomUUID");
        }
        handledException.put("appUuidHigh", buildUuid.getLeastSignificantBits());
        handledException.put("appUuidLow", buildUuid.getMostSignificantBits());
        handledException.put("appVersion", applicationInfo.getApplicationVersion());
        handledException.put("appBuild", applicationInfo.getApplicationBuild());
        handledException.put("sessionId", agentConfiguration.getSessionID());
        handledException.put("timestampMs", System.currentTimeMillis());
        handledException.put("message", e.getMessage() != null && e.getMessage().length() > 4096 ? e.getMessage().substring(0, 4096) : e.getMessage());
        String cause = AgentDataController.getRootCause(e).toString();
        handledException.put("cause", cause.length() > 4096 ? cause.substring(0, 4096) : cause);
        handledException.put("name", e.getClass().toString());
        handledException.put("thread", AgentDataController.threadSetFromStackElements(e.getStackTrace()));
        handledException.putAll(exceptionAttributes);
        for (AnalyticsAttribute attribute : AnalyticsControllerImpl.getInstance().getSessionAttributes()) {
            switch (attribute.getAttributeDataType()) {
                case STRING: {
                    sessionAttributes.put(attribute.getName(), attribute.getStringValue());
                    break;
                }
                case DOUBLE: {
                    sessionAttributes.put(attribute.getName(), attribute.getDoubleValue());
                    break;
                }
                case BOOLEAN: {
                    sessionAttributes.put(attribute.getName(), attribute.getBooleanValue());
                }
            }
        }
        long sessionDuration = Agent.getImpl().getSessionDurationMillis();
        if (0L == sessionDuration) {
            log.error("Harvest instance is not running! Session duration will be invalid");
        } else {
            sessionAttributes.put("timeSinceLoad", Float.valueOf((float)sessionDuration / 1000.0f));
        }
        sessionAttributes.put("obfuscated", Agent.getIsObfuscated());
        sessionAttributes.putAll(exceptionAttributes);
        HashSet<Map<String, Object>> agentData = new HashSet<Map<String, Object>>();
        agentData.add(handledException);
        FlatBufferBuilder flat = AgentDataBuilder.startAndFinishAgentData(sessionAttributes, agentData);
        return flat;
    }

    static FlatBufferBuilder buildAgentDataFromHandledException(Throwable e) {
        return AgentDataController.buildAgentDataFromHandledException(e, new HashMap<String, Object>());
    }

    protected static Throwable getRootCause(Throwable throwable) {
        block4: {
            try {
                if (throwable != null) {
                    Throwable cause = throwable.getCause();
                    if (cause == null) {
                        return throwable;
                    }
                    return AgentDataController.getRootCause(cause);
                }
            }
            catch (Exception e) {
                if (throwable == null) break block4;
                return throwable;
            }
        }
        return new Throwable("Unknown cause");
    }

    protected static List<Map<String, Object>> threadSetFromStackElements(StackTraceElement[] ste) {
        ArrayList<Map<String, Object>> thread = new ArrayList<Map<String, Object>>();
        for (StackTraceElement ele : ste) {
            LinkedHashMap<String, Object> frame = new LinkedHashMap<String, Object>();
            frame.put("className", ele.getClassName());
            frame.put("methodName", ele.getMethodName());
            frame.put("lineNumber", ele.getLineNumber());
            frame.put("fileName", ele.getFileName());
            thread.add(frame);
        }
        return thread;
    }

    public static boolean sendAgentData(Throwable e, Map<String, Object> attributes) {
        if (FeatureFlag.featureEnabled(FeatureFlag.HandledExceptions) || FeatureFlag.featureEnabled(FeatureFlag.NativeReporting)) {
            try {
                if (FeatureFlag.featureEnabled(FeatureFlag.OfflineStorage) && !Agent.hasReachableNetworkConnection(null)) {
                    attributes.put("offline", true);
                    StatsEngine.notice().inc("Supportability/AgentHealth/OfflineStorage/HandledException/Count");
                }
                if (FeatureFlag.featureEnabled(FeatureFlag.BackgroundReporting) && ApplicationStateMonitor.isAppInBackground()) {
                    attributes.put("background", true);
                    StatsEngine.notice().inc("Supportability/AgentHealth/Background/HandledException/Count");
                }
                FlatBufferBuilder flat = AgentDataController.buildAgentDataFromHandledException(e, attributes);
                ByteBuffer byteBuffer = flat.dataBuffer().slice();
                byte[] modifiedBytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(modifiedBytes);
                log.audit(AgentDataBuilder.toJsonString(HexAgentDataBundle.getRootAsHexAgentDataBundle(ByteBuffer.wrap(modifiedBytes)), 0));
                boolean reported = AgentDataReporter.reportAgentData(modifiedBytes);
                if (!reported) {
                    log.error("HandledException: exception " + e.getClass().getName() + " failed to record data.");
                }
                return reported;
            }
            catch (Exception error) {
                log.error("HandledException: exception " + e.getClass().getName() + " failed to record data.");
            }
        }
        return false;
    }
}

