/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.agentdata;

import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.agentdata.AgentDataSender;
import com.newrelic.agent.android.harvest.DeviceInformation;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.payload.Payload;
import com.newrelic.agent.android.payload.PayloadController;
import com.newrelic.agent.android.payload.PayloadReporter;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.payload.PayloadStore;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class AgentDataReporter
extends PayloadReporter {
    protected static final AtomicReference<AgentDataReporter> instance = new AtomicReference<Object>(null);
    private static boolean reportExceptions = false;
    protected final PayloadStore<Payload> payloadStore;
    protected final Callable reportCachedAgentDataCallable = new Callable(){

        public Object call() throws Exception {
            AgentDataReporter.this.reportCachedAgentData();
            return null;
        }
    };

    public static AgentDataReporter getInstance() {
        return instance.get();
    }

    public static AgentDataReporter initialize(AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new AgentDataReporter(agentConfiguration));
        reportExceptions = agentConfiguration.getReportHandledExceptions();
        return instance.get();
    }

    public static void shutdown() {
        if (AgentDataReporter.isInitialized()) {
            try {
                instance.get().stop();
            }
            finally {
                instance.set(null);
            }
        }
    }

    public static boolean reportAgentData(byte[] bytes) {
        boolean reported = false;
        if (AgentDataReporter.isInitialized()) {
            if (reportExceptions) {
                Payload payload = new Payload(bytes);
                instance.get().storeAndReportAgentData(payload);
                reported = true;
            }
        } else {
            log.error("AgentDataReporter not initialized");
        }
        return reported;
    }

    protected static boolean isInitialized() {
        return instance.get() != null;
    }

    protected AgentDataReporter(AgentConfiguration agentConfiguration) {
        super(agentConfiguration);
        this.payloadStore = agentConfiguration.getPayloadStore();
        this.isEnabled.set(FeatureFlag.featureEnabled(FeatureFlag.HandledExceptions));
    }

    @Override
    public void start() {
        if (PayloadController.isInitialized()) {
            if (this.isEnabled() && this.isStarted.compareAndSet(false, true)) {
                PayloadController.submitCallable(this.reportCachedAgentDataCallable);
                Harvest.addHarvestListener(this);
            }
        } else {
            log.error("AgentDataReporter.start(): Must initialize PayloadController first.");
        }
    }

    @Override
    public void stop() {
        Harvest.removeHarvestListener(this);
    }

    protected void reportCachedAgentData() {
        if (Agent.hasReachableNetworkConnection(null)) {
            if (AgentDataReporter.isInitialized()) {
                if (this.payloadStore != null) {
                    for (Payload payload : this.payloadStore.fetchAll()) {
                        if (this.isPayloadStale(payload)) continue;
                        this.reportAgentData(payload);
                    }
                }
            } else {
                log.error("AgentDataReporter not initialized");
            }
        }
    }

    public Future reportAgentData(Payload payload) {
        AgentDataSender payloadSender = new AgentDataSender(payload, this.getAgentConfiguration());
        if ((long)payload.getBytes().length > 1000000L) {
            DeviceInformation deviceInformation = Agent.getDeviceInformation();
            String name = "Supportability/Mobile/Android/<framework>/<destination>/MaxPayloadSizeLimit/<subdestination>".replace("<framework>", deviceInformation.getApplicationFramework().name()).replace("<destination>", "Collector").replace("<subdestination>", "f");
            StatsEngine.notice().inc(name);
            this.payloadStore.delete(payload);
            log.error("Unable to upload handled exceptions because payload is larger than 1 MB, handled exceptions are discarded.");
            return null;
        }
        Future future = PayloadController.submitPayload(payloadSender, new PayloadSender.CompletionHandler(){

            @Override
            public void onResponse(PayloadSender payloadSender) {
                if (payloadSender.isSuccessfulResponse()) {
                    if (AgentDataReporter.this.payloadStore != null) {
                        AgentDataReporter.this.payloadStore.delete(payloadSender.getPayload());
                    }
                    DeviceInformation deviceInformation = Agent.getDeviceInformation();
                    String name = "Supportability/Mobile/Android/<framework>/<destination>/<subdestination>/Output/Bytes".replace("<framework>", deviceInformation.getApplicationFramework().name()).replace("<destination>", "Collector").replace("<subdestination>", "f");
                    StatsEngine.get().sampleMetricDataUsage(name, payloadSender.getPayload().getBytes().length, 0.0f);
                } else if (FeatureFlag.featureEnabled(FeatureFlag.OfflineStorage)) {
                    log.warn("AgentDataReporter didn't send due to lack of network connection");
                }
            }

            @Override
            public void onException(PayloadSender payloadSender, Exception e) {
                log.error("AgentDataReporter.reportAgentData(Payload): " + e);
            }
        });
        return future;
    }

    public Future storeAndReportAgentData(Payload payload) {
        if (this.payloadStore != null && payload.isPersisted() && this.payloadStore.store(payload)) {
            payload.setPersisted(false);
        }
        return this.reportAgentData(payload);
    }

    @Override
    protected boolean isPayloadStale(Payload payload) {
        if (payload.isStale(this.agentConfiguration.getPayloadTTL())) {
            this.payloadStore.delete(payload);
            log.info("Payload [" + payload.getUuid() + "] has become stale, and has been removed");
            StatsEngine.get().inc("Supportability/AgentHealth/Payload/Removed/Stale");
            return true;
        }
        return false;
    }

    @Override
    public void onHarvest() {
        PayloadController.submitCallable(this.reportCachedAgentDataCallable);
    }
}

