/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.RemoteConfiguration;
import com.newrelic.agent.android.activity.config.ActivityTraceConfiguration;
import com.newrelic.agent.android.harvest.DataToken;
import com.newrelic.agent.android.harvest.HarvestConfigurable;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class HarvestConfiguration
implements HarvestConfigurable {
    protected static final String NO_VALUE = "";
    private static final int DEFAULT_ACTIVITY_TRACE_LENGTH = 65535;
    private static final int DEFAULT_ACTIVITY_TRACE_MAX_REPORT_ATTEMPTS = 1;
    private static final int DEFAULT_REPORT_PERIOD = 60;
    private static final int DEFAULT_ERROR_LIMIT = 50;
    private static final int DEFAULT_RESPONSE_BODY_LIMIT = 2048;
    private static final int DEFAULT_STACK_TRACE_LIMIT = 100;
    private static final int DEFAULT_MAX_TRANSACTION_AGE = 600;
    private static final int DEFAULT_MAX_TRANSACTION_COUNT = 1000;
    private static final float DEFAULT_ACTIVITY_TRACE_MIN_UTILIZATION = 0.3f;
    private static final String DEFAULT_PRIORITY_ENCODING_KEY = "d67afc830dab717fd163bfcb0b8b88423e9a1a3b";
    @SerializedName(value="account_id")
    private String account_id;
    @SerializedName(value="configuration")
    private RemoteConfiguration remote_configuration;
    @SerializedName(value="data_token")
    private int[] data_token;
    @SerializedName(value="entity_guid")
    private String entity_guid = "";
    @SerializedName(value="request_headers_map")
    private Map<String, String> request_headers_map;
    @SerializedName(value="trusted_account_key")
    private String trusted_account_key;
    @SerializedName(value="collect_network_errors")
    private boolean collect_network_errors;
    @SerializedName(value="cross_process_id")
    private String cross_process_id;
    @SerializedName(value="data_report_period")
    private int data_report_period;
    @SerializedName(value="error_limit")
    private int error_limit;
    @SerializedName(value="report_max_transaction_age")
    private int report_max_transaction_age;
    @SerializedName(value="report_max_transaction_count")
    private int report_max_transaction_count;
    @SerializedName(value="response_body_limit")
    private int response_body_limit;
    @SerializedName(value="server_timestamp")
    private long server_timestamp;
    @SerializedName(value="stack_trace_limit")
    private int stack_trace_limit;
    @SerializedName(value="activity_trace_max_size")
    private int activity_trace_max_size;
    @SerializedName(value="activity_trace_min_utilization")
    private double activity_trace_min_utilization;
    @SerializedName(value="at_capture")
    private ActivityTraceConfiguration at_capture;
    @SerializedName(value="encoding_key", alternate={"priority_encoding_key"})
    private String encoding_key;
    @SerializedName(value="application_id")
    private String application_id;
    @SerializedName(value="activity_trace_max_report_attempts")
    private int activity_trace_max_report_attempts;
    private static final AtomicReference<HarvestConfiguration> defaultHarvestConfiguration = new AtomicReference<Object>(null);

    public HarvestConfiguration() {
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.setData_token(new int[]{0, 0});
        this.setCollect_network_errors(true);
        this.setCross_process_id(null);
        this.setData_report_period(60);
        this.setError_limit(50);
        this.setResponse_body_limit(2048);
        this.setStack_trace_limit(100);
        this.setReport_max_transaction_age(600);
        this.setReport_max_transaction_count(1000);
        this.setActivity_trace_max_size(65535);
        this.setActivity_trace_max_report_attempts(1);
        this.setActivity_trace_min_utilization(0.3f);
        this.setAt_capture(ActivityTraceConfiguration.defaultActivityTraceConfiguration());
        this.setEncoding_key(DEFAULT_PRIORITY_ENCODING_KEY);
        this.setAccount_id(NO_VALUE);
        this.setApplication_id(NO_VALUE);
        this.setTrusted_account_key(NO_VALUE);
        this.setEntity_guid(NO_VALUE);
        this.setRemote_configuration(new RemoteConfiguration());
        this.setRequest_headers_map(new HashMap<String, String>());
    }

    public static HarvestConfiguration getDefaultHarvestConfiguration() {
        if (defaultHarvestConfiguration.get() == null) {
            defaultHarvestConfiguration.compareAndSet(null, new HarvestConfiguration());
        }
        return defaultHarvestConfiguration.get();
    }

    @Override
    public void setConfiguration(HarvestConfiguration harvestConfiguration) {
        this.updateConfiguration(harvestConfiguration);
    }

    @Override
    public void updateConfiguration(HarvestConfiguration configuration) {
        this.setCollect_network_errors(configuration.isCollect_network_errors());
        if (configuration.getCross_process_id() != null) {
            this.setCross_process_id(configuration.getCross_process_id());
        }
        this.setData_report_period(configuration.getData_report_period());
        DataToken confDataToken = configuration.getDataToken();
        if (confDataToken != null && confDataToken.isValid()) {
            this.setData_token(configuration.getData_token());
        }
        this.setError_limit(configuration.getError_limit());
        this.setReport_max_transaction_age(configuration.getReport_max_transaction_age());
        this.setReport_max_transaction_count(configuration.getReport_max_transaction_count());
        this.setResponse_body_limit(configuration.getResponse_body_limit());
        this.setServer_timestamp(configuration.getServer_timestamp());
        this.setStack_trace_limit(configuration.getStack_trace_limit());
        this.setActivity_trace_min_utilization(configuration.getActivity_trace_min_utilization());
        this.setActivity_trace_max_report_attempts(configuration.getActivity_trace_max_report_attempts());
        this.setActivity_trace_max_size(configuration.getActivity_trace_max_size());
        if (configuration.getAt_capture() != null) {
            this.setAt_capture(configuration.getAt_capture());
        }
        this.setEncoding_key(configuration.getEncoding_key());
        this.setAccount_id(configuration.getAccount_id());
        this.setApplication_id(String.valueOf(configuration.getDataToken().getAccountId()));
        this.setTrusted_account_key(configuration.getTrusted_account_key());
        this.setEntity_guid(configuration.getEntity_guid());
        this.setRemote_configuration(configuration.getRemote_configuration());
        this.setRequest_headers_map(configuration.getRequest_headers_map());
    }

    public void setCollect_network_errors(boolean collect_network_errors) {
        this.collect_network_errors = collect_network_errors;
    }

    public void setCross_process_id(String cross_process_id) {
        this.cross_process_id = cross_process_id;
    }

    public void setData_report_period(int data_report_period) {
        this.data_report_period = data_report_period;
    }

    public void setData_token(int[] data_token) {
        this.data_token = data_token;
    }

    public DataToken getDataToken() {
        if (this.data_token == null) {
            return new DataToken(0, 0);
        }
        return new DataToken(this.data_token[0], this.data_token[1]);
    }

    public void setError_limit(int error_limit) {
        this.error_limit = error_limit;
    }

    public void setReport_max_transaction_age(int report_max_transaction_age) {
        this.report_max_transaction_age = report_max_transaction_age;
    }

    public void setReport_max_transaction_count(int report_max_transaction_count) {
        this.report_max_transaction_count = report_max_transaction_count;
    }

    public void setResponse_body_limit(int response_body_limit) {
        this.response_body_limit = response_body_limit;
    }

    public void setServer_timestamp(long server_timestamp) {
        this.server_timestamp = server_timestamp;
    }

    public void setStack_trace_limit(int stack_trace_limit) {
        this.stack_trace_limit = stack_trace_limit;
    }

    public void setActivity_trace_max_size(int activity_trace_max_size) {
        this.activity_trace_max_size = activity_trace_max_size;
    }

    public void setActivity_trace_max_report_attempts(int activity_trace_max_report_attempts) {
        this.activity_trace_max_report_attempts = activity_trace_max_report_attempts;
    }

    public boolean isCollect_network_errors() {
        return this.collect_network_errors;
    }

    public String getCross_process_id() {
        return this.cross_process_id;
    }

    public int getData_report_period() {
        return this.data_report_period;
    }

    public int[] getData_token() {
        return this.data_token;
    }

    public int getError_limit() {
        return this.error_limit;
    }

    public int getReport_max_transaction_age() {
        return this.report_max_transaction_age;
    }

    public long getReportMaxTransactionAgeMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.report_max_transaction_age, TimeUnit.SECONDS);
    }

    public int getReport_max_transaction_count() {
        return this.report_max_transaction_count;
    }

    public int getResponse_body_limit() {
        return this.response_body_limit;
    }

    public long getServer_timestamp() {
        return this.server_timestamp;
    }

    public int getStack_trace_limit() {
        return this.stack_trace_limit;
    }

    public int getActivity_trace_max_size() {
        return this.activity_trace_max_size;
    }

    public int getActivity_trace_max_report_attempts() {
        return this.activity_trace_max_report_attempts;
    }

    public ActivityTraceConfiguration getAt_capture() {
        return this.at_capture;
    }

    public void setAt_capture(ActivityTraceConfiguration at_capture) {
        this.at_capture = at_capture;
    }

    public double getActivity_trace_min_utilization() {
        return this.activity_trace_min_utilization;
    }

    public void setActivity_trace_min_utilization(double activity_trace_min_utilization) {
        this.activity_trace_min_utilization = activity_trace_min_utilization;
    }

    public String getEncoding_key() {
        return this.encoding_key;
    }

    public void setEncoding_key(String encoding_key) {
        this.encoding_key = encoding_key;
    }

    public String getApplication_id() {
        DataToken dataToken;
        if (this.data_token != null && (dataToken = this.getDataToken()).isValid()) {
            return String.valueOf(dataToken.getAccountId());
        }
        return NO_VALUE;
    }

    public void setApplication_id(String application_id) {
        this.application_id = application_id;
    }

    public String getAccount_id() {
        if (this.account_id == null) {
            return NO_VALUE;
        }
        return this.account_id;
    }

    public void setAccount_id(String account_id) {
        this.account_id = account_id;
    }

    public String getTrusted_account_key() {
        if (this.trusted_account_key == null) {
            return NO_VALUE;
        }
        return this.trusted_account_key;
    }

    public void setTrusted_account_key(String trusted_account_key) {
        this.trusted_account_key = trusted_account_key;
    }

    public void setEntity_guid(String entityGuid) {
        if (entityGuid == null || entityGuid.isEmpty()) {
            AgentLogManager.getAgentLog().info("setEntity_guid: invalid entity guid value!");
        } else {
            this.entity_guid = entityGuid;
        }
    }

    public void setRemote_configuration(RemoteConfiguration remoteConfiguration) {
        this.remote_configuration = remoteConfiguration;
    }

    public RemoteConfiguration getRemote_configuration() {
        return this.remote_configuration;
    }

    public Map<String, String> getRequest_headers_map() {
        return this.request_headers_map;
    }

    public void setRequest_headers_map(Map<String, String> requestHeadersMap) {
        if (requestHeadersMap != null) {
            this.request_headers_map = requestHeadersMap;
        }
    }

    public String getEntity_guid() {
        return this.entity_guid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarvestConfiguration that = (HarvestConfiguration)o;
        if (this.collect_network_errors != that.collect_network_errors) {
            return false;
        }
        if (this.data_report_period != that.data_report_period) {
            return false;
        }
        if (this.error_limit != that.error_limit) {
            return false;
        }
        if (this.report_max_transaction_age != that.report_max_transaction_age) {
            return false;
        }
        if (this.report_max_transaction_count != that.report_max_transaction_count) {
            return false;
        }
        if (this.response_body_limit != that.response_body_limit) {
            return false;
        }
        if (this.stack_trace_limit != that.stack_trace_limit) {
            return false;
        }
        if (this.activity_trace_max_size != that.activity_trace_max_size) {
            return false;
        }
        if (this.activity_trace_max_report_attempts != that.activity_trace_max_report_attempts) {
            return false;
        }
        if (this.cross_process_id == null && that.cross_process_id != null) {
            return false;
        }
        if (this.cross_process_id != null && that.cross_process_id == null) {
            return false;
        }
        if (this.cross_process_id != null && !this.cross_process_id.equals(that.cross_process_id)) {
            return false;
        }
        if (!this.encoding_key.equals(that.encoding_key)) {
            return false;
        }
        if (this.account_id == null && that.account_id != null) {
            return false;
        }
        if (this.account_id != null && that.account_id == null) {
            return false;
        }
        if (this.account_id != null && !this.account_id.equals(that.account_id)) {
            return false;
        }
        if (this.getApplication_id() == null && that.getApplication_id() != null) {
            return false;
        }
        if (this.getApplication_id() != null && that.getApplication_id() == null) {
            return false;
        }
        if (this.getApplication_id() != null && !this.getApplication_id().equals(that.getApplication_id())) {
            return false;
        }
        if (this.trusted_account_key != null && !this.trusted_account_key.equals(that.trusted_account_key)) {
            return false;
        }
        if (this.entity_guid != null && !this.entity_guid.equals(that.entity_guid)) {
            return false;
        }
        if (this.remote_configuration != null && !this.remote_configuration.getApplicationExitConfiguration().equals(that.remote_configuration.getApplicationExitConfiguration())) {
            return false;
        }
        if (this.request_headers_map != null && !this.request_headers_map.equals(that.request_headers_map)) {
            return false;
        }
        int thisMinUtil = (int)this.activity_trace_min_utilization * 100;
        int thatMinUtil = (int)that.activity_trace_min_utilization * 100;
        if (thisMinUtil != thatMinUtil) {
            return false;
        }
        boolean dataTokenEqual = Arrays.equals(this.data_token, that.data_token);
        return dataTokenEqual;
    }

    public int hashCode() {
        int result = this.collect_network_errors ? 1 : 0;
        result = 31 * result + (this.cross_process_id != null ? this.cross_process_id.hashCode() : 0);
        result = 31 * result + this.data_report_period;
        result = 31 * result + (this.data_token != null ? Arrays.hashCode(this.data_token) : 0);
        result = 31 * result + this.error_limit;
        result = 31 * result + this.report_max_transaction_age;
        result = 31 * result + this.report_max_transaction_count;
        result = 31 * result + this.response_body_limit;
        result = 31 * result + this.stack_trace_limit;
        result = 31 * result + this.activity_trace_max_size;
        result = 31 * result + this.activity_trace_max_report_attempts;
        long temp = Double.doubleToLongBits(this.activity_trace_min_utilization);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.at_capture != null ? this.at_capture.hashCode() : 0);
        result = 31 * result + (this.account_id != null ? this.account_id.hashCode() : 0);
        result = 31 * result + (this.application_id != null ? this.application_id.hashCode() : 0);
        result = 31 * result + (this.encoding_key != null ? this.encoding_key.hashCode() : 0);
        result = 31 * result + (this.trusted_account_key != null ? this.trusted_account_key.hashCode() : 0);
        result = 31 * result + (this.entity_guid != null ? this.entity_guid.hashCode() : 0);
        result = 31 * result + (this.remote_configuration != null ? this.remote_configuration.hashCode() : 0);
        result = 31 * result + (this.request_headers_map != null ? this.request_headers_map.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HarvestConfiguration{collect_network_errors=" + this.collect_network_errors + ", cross_process_id='" + this.cross_process_id + "', data_report_period=" + this.data_report_period + ", data_token=" + Arrays.toString(this.data_token) + ", error_limit=" + this.error_limit + ", report_max_transaction_age=" + this.report_max_transaction_age + ", report_max_transaction_count=" + this.report_max_transaction_count + ", response_body_limit=" + this.response_body_limit + ", server_timestamp=" + this.server_timestamp + ", stack_trace_limit=" + this.stack_trace_limit + ", activity_trace_max_size=" + this.activity_trace_max_size + ", activity_trace_max_report_attempts=" + this.activity_trace_max_report_attempts + ", activity_trace_min_utilization=" + this.activity_trace_min_utilization + ", at_capture=" + this.at_capture + ", priority_encoding_key=" + this.encoding_key + ", account_id=" + this.account_id + ", application_id=" + this.application_id + ", trusted_account_key=" + this.trusted_account_key + ", entity_guid=" + this.entity_guid + ", remote_configuration=" + this.remote_configuration.toString() + ", request_headers_map=" + this.request_headers_map + "}";
    }
}

