/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.harvest;

import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.background.ApplicationStateMonitor;
import com.newrelic.agent.android.harvest.AgentHealth;
import com.newrelic.agent.android.harvest.HarvestConfiguration;
import com.newrelic.agent.android.harvest.Harvester;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.stats.TicToc;
import com.newrelic.agent.android.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HarvestTimer
implements Runnable {
    public static final long DEFAULT_HARVEST_PERIOD = TimeUnit.SECONDS.toMillis(60L);
    private static final long HARVEST_PERIOD_LEEWAY = TimeUnit.SECONDS.toMillis(1L);
    private static final long NEVER_TICKED = -1L;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Harvester"));
    private final AgentLog log = AgentLogManager.getAgentLog();
    private ScheduledFuture tickFuture = null;
    protected long period = DEFAULT_HARVEST_PERIOD;
    protected final Harvester harvester;
    protected long lastTickTime;
    private long startTimeMs;
    private final Lock lock = new ReentrantLock();

    public HarvestTimer(Harvester harvester) {
        this.harvester = harvester;
        this.startTimeMs = 0L;
    }

    @Override
    public void run() {
        try {
            this.lock.lock();
            this.tickIfReady();
        }
        catch (Exception e) {
            this.log.error("HarvestTimer: Exception in timer tick: " + e.getMessage());
            AgentHealth.noticeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void tickIfReady() {
        long lastTickDelta = this.timeSinceLastTick();
        if (lastTickDelta + HARVEST_PERIOD_LEEWAY < this.period && lastTickDelta != -1L) {
            this.log.debug("HarvestTimer: Tick is too soon (" + lastTickDelta + " delta) Last tick time: " + this.lastTickTime + " . Skipping.");
            return;
        }
        this.log.debug("HarvestTimer: time since last tick: " + lastTickDelta);
        try {
            this.tick();
        }
        catch (Exception e) {
            this.log.error("HarvestTimer: Exception in timer tick: " + e.getMessage());
            AgentHealth.noticeException(e);
        }
        this.log.debug("Set last tick time to: " + this.lastTickTime);
    }

    protected void tick() {
        this.log.debug("Harvest: tick");
        TicToc t = new TicToc().tic();
        try {
            if (FeatureFlag.featureEnabled(FeatureFlag.BackgroundReporting)) {
                this.harvester.execute();
                this.log.debug("Harvest: executed");
                this.log.debug("Harvest: executed in the background");
            } else if (ApplicationStateMonitor.isAppInBackground()) {
                this.log.error("HarvestTimer: Attempting to harvest while app is in background");
            } else {
                this.harvester.execute();
                this.log.debug("Harvest: executed");
            }
            this.lastTickTime = this.now();
        }
        catch (Exception e) {
            this.log.error("HarvestTimer: Exception in harvest execute: " + e.getMessage());
            AgentHealth.noticeException(e);
        }
        if (this.harvester.isDisabled()) {
            this.stop();
        }
        this.log.debug("HarvestTimer tick took " + t.toc() + "ms");
    }

    public void start() {
        if (!FeatureFlag.featureEnabled(FeatureFlag.BackgroundReporting) && ApplicationStateMonitor.isAppInBackground()) {
            this.log.warn("HarvestTimer: Attempting to start while app is in background");
            return;
        }
        if (this.isRunning()) {
            this.log.warn("HarvestTimer: Attempting to start while already running");
            return;
        }
        if (this.period <= 0L) {
            this.log.error("HarvestTimer: Refusing to start with a period of 0 ms");
            return;
        }
        this.log.debug("HarvestTimer: Starting with a period of " + this.period + "ms");
        this.startTimeMs = this.now();
        this.tickFuture = this.scheduler.scheduleWithFixedDelay(this, 0L, this.period, TimeUnit.MILLISECONDS);
        this.harvester.start();
    }

    public void stop() {
        if (!this.isRunning()) {
            this.log.warn("HarvestTimer: Attempting to stop when not running");
            return;
        }
        this.cancelPendingTasks();
        this.log.debug("HarvestTimer: Stopped");
        this.startTimeMs = 0L;
        this.harvester.stop();
    }

    public void shutdown() {
        this.cancelPendingTasks();
        this.scheduler.shutdownNow();
    }

    public void tickNow(boolean bWait) {
        try {
            HarvestTimer timer = this;
            ScheduledFuture<?> future = this.scheduler.schedule(() -> timer.tick(), 0L, TimeUnit.MILLISECONDS);
            if (bWait && !future.isCancelled()) {
                future.get();
                this.startTimeMs = this.now();
            }
        }
        catch (Exception e) {
            this.log.error("Exception waiting for tickNow to finish: " + e.getMessage());
            AgentHealth.noticeException(e);
        }
    }

    public boolean isRunning() {
        return this.tickFuture != null;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long timeSinceLastTick() {
        if (this.lastTickTime == 0L) {
            return -1L;
        }
        return this.now() - this.lastTickTime;
    }

    public long timeSinceStart() {
        if (this.startTimeMs == 0L) {
            return 0L;
        }
        return this.now() - this.startTimeMs;
    }

    private long now() {
        return System.currentTimeMillis();
    }

    protected void cancelPendingTasks() {
        try {
            this.lock.lock();
            if (this.tickFuture != null) {
                this.tickFuture.cancel(false);
                this.tickFuture = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateConfiguration(HarvestConfiguration harvestConfiguration) {
    }
}

