/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.instrumentation.androidx.navigation;

import android.os.Bundle;
import androidx.compose.runtime.Composer;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavController;
import androidx.navigation.NavHostController;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import com.newrelic.agent.android.FeatureFlag;
import com.newrelic.agent.android.instrumentation.InstrumentationDelegate;
import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NavigationController
extends InstrumentationDelegate {
    private static Set<FeatureFlag> requiredFeatures = new HashSet<FeatureFlag>(){
        {
            this.add(FeatureFlag.Jetpack);
        }
    };

    @ReplaceCallSite(isStatic=true)
    public static void navigate$default(NavController navController, final String route, final NavOptions options, final Navigator.Extras extras, int i, Object o) {
        navController.navigate(route, options, extras);
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("navigate$default(NavController, String, NavOptions, Navigator.Extras, int, Object)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "navigate");
                    this.put("route", route);
                    if (options != null) {
                        this.put("restoreState", options.shouldRestoreState());
                        this.put("popUpToInclusive", options.isPopUpToInclusive());
                        this.put("popUpToSaveState", options.shouldPopUpToSaveState());
                        if (options.getPopUpToRoute() != null) {
                            this.put("options.popUpToRoute", options.getPopUpToRoute());
                        }
                        if (-1 != options.getEnterAnim()) {
                            this.put("options.enterAnim", options.getEnterAnim());
                        }
                        if (-1 != options.getExitAnim()) {
                            this.put("options.exitAnim", options.getExitAnim());
                        }
                        if (-1 != options.getPopEnterAnim()) {
                            this.put("options.popEnterAnim", options.getPopEnterAnim());
                        }
                        if (-1 != options.getPopExitAnim()) {
                            this.put("options.popExitAnim", options.getPopExitAnim());
                        }
                    }
                    if (extras != null) {
                        this.put("extras", extras);
                    }
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
    }

    @ReplaceCallSite(isStatic=true)
    public static void invoke(NavHostController navHostController, final NavBackStackEntry navBackStackEntry, final Composer composer, int cnt) {
        navHostController.navigate(navBackStackEntry.getDestination().getId(), navBackStackEntry.getArguments());
        executor.submit(() -> {
            log.debug("invoke(NavController, NavBackStackEntry, Composer, int)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "invoke");
                    this.put("navBackStackEntry.id", navBackStackEntry.getDestination().getId());
                    if (navBackStackEntry.getArguments() != null) {
                        this.put("navBackStackEntry.arguments", navBackStackEntry.getArguments().toString());
                    }
                    this.put("composer.rememberedValue", composer.rememberedValue());
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
    }

    @ReplaceCallSite
    public static void navigate(NavController navController, final int resId, Bundle bundle, final NavOptions options, final Navigator.Extras extras) {
        navController.navigate(resId, bundle, options, extras);
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("navigate(NavController, int, Bundle, NavOptions, Navigator.Extras)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "navigate");
                    this.put("resId", resId);
                    if (options.getPopUpToRoute() != null) {
                        this.put("options.popUpToRoute", options.getPopUpToRoute());
                    }
                    if (-1 != options.getEnterAnim()) {
                        this.put("options.enterAnim", options.getEnterAnim());
                    }
                    if (-1 != options.getExitAnim()) {
                        this.put("options.exitAnim", options.getExitAnim());
                    }
                    if (-1 != options.getPopEnterAnim()) {
                        this.put("options.popEnterAnim", options.getPopEnterAnim());
                    }
                    if (-1 != options.getPopExitAnim()) {
                        this.put("options.popExitAnim", options.getPopExitAnim());
                    }
                    this.put("extras", extras == null ? "null" : extras.toString());
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
    }

    @ReplaceCallSite
    public static boolean navigateUp(NavController navController) {
        final boolean rc = navController.navigateUp();
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("navigateUp(NavController)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "navigateUp");
                    this.put("result", rc);
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
        return rc;
    }

    @ReplaceCallSite(isStatic=true)
    public static void popBackStack$default(NavController navController, final String route, final boolean inclusive, final boolean saveState, int i, Object unused) {
        navController.popBackStack(route, inclusive, saveState);
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("popBackStack$default(NavController, String, boolean, boolean, int, Object)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "popBackStack");
                    this.put("route", route);
                    this.put("inclusive", inclusive);
                    this.put("saveState", saveState);
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
    }

    @ReplaceCallSite
    public static boolean popBackStack(NavController navController, final int destinationId, final boolean inclusive, final boolean saveState) {
        final boolean rc = navController.popBackStack(destinationId, inclusive, saveState);
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("popBackStack(NavController, int, boolean, boolean)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "popBackStack");
                    this.put("destinationId", destinationId);
                    this.put("inclusive", inclusive);
                    this.put("saveState", saveState);
                    this.put("result", rc);
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
        return rc;
    }

    @ReplaceCallSite
    public static boolean popBackStack(NavController navController, final String route, final boolean inclusive, final boolean saveState) {
        final boolean rc = navController.popBackStack(route, inclusive, saveState);
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("popBackStack(NavController, String, boolean, boolean) ");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "popBackStack");
                    this.put("route", route);
                    this.put("inclusive", inclusive);
                    this.put("saveState", saveState);
                    this.put("result", rc);
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
        return rc;
    }

    @ReplaceCallSite
    public static boolean popBackStack(NavHostController navHostController) {
        final boolean rc = navHostController.popBackStack();
        NavigationController.submit(requiredFeatures, () -> {
            log.debug("boolean popBackStack(NavHostController)");
            HashMap<String, Object> attrs = new HashMap<String, Object>(){
                {
                    this.put("span", "popBackStack");
                    this.put("result", rc);
                }
            };
            analyticsController.recordBreadcrumb("Compose", (Map<String, Object>)attrs);
        });
        return rc;
    }
}

