/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.logging;

import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.payload.FileBackedPayload;
import com.newrelic.agent.android.payload.PayloadSender;
import com.newrelic.agent.android.stats.StatsEngine;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;

public class LogForwarder
extends PayloadSender {
    public LogForwarder(File logDataFile, AgentConfiguration agentConfiguration) throws IOException {
        super(agentConfiguration);
        FileBackedPayload logFileBackedPayload = new FileBackedPayload(logDataFile);
        logFileBackedPayload.compress(true);
        this.payload = logFileBackedPayload;
    }

    @Override
    public PayloadSender call() throws Exception {
        if (this.shouldUploadOpportunistically()) {
            this.timer.tic();
            return super.call();
        }
        log.warn("LogForwarder: endpoint is not reachable. Will try later...");
        return this;
    }

    @Override
    protected HttpURLConnection getConnection() throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)this.getCollectorURI().toURL().openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Content-Encoding", "gzip");
        connection.setRequestProperty("X-App-License-Key", this.agentConfiguration.getApplicationToken());
        connection.setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
        connection.setReadTimeout((int)TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        return connection;
    }

    @Override
    protected void onRequestResponse(HttpURLConnection connection) throws IOException {
        switch (connection.getResponseCode()) {
            case 200: 
            case 202: {
                StatsEngine.SUPPORTABILITY.sampleTimeMs("Supportability/AgentHealth/LogReporting/UploadTime", this.timer.duration());
                log.debug("LogForwarder: Log data forwarding took " + this.timer.duration() + "ms");
                int payloadSize = this.getPayloadSize();
                StatsEngine.SUPPORTABILITY.sample("Supportability/AgentHealth/LogReporting/Size/Uncompressed", payloadSize);
                log.info("LogForwarder: [" + payloadSize + "] bytes successfully submitted.");
                break;
            }
            case 408: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/UploadTimeOut");
                this.onFailedUpload("The request to submit the log data payload has timed out - (will try again later) - Response code [" + this.responseCode + "]");
                break;
            }
            case 413: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/UploadRejected");
                this.onFailedUpload("The request was rejected due to payload size limits - Response code [" + this.responseCode + "]");
                break;
            }
            case 429: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/UploadThrottled");
                this.onFailedUpload("Log upload requests have been throttled (will try again later) - Response code [" + this.responseCode + "]");
                break;
            }
            case 500: {
                StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/Removed/Rejected");
                this.onFailedUpload("The log data was rejected and will be deleted - Response code " + connection.getResponseCode());
                break;
            }
            default: {
                this.onFailedUpload("Something went wrong while forwarding (will try again later) - Response code " + connection.getResponseCode());
            }
        }
        log.debug("Payload [" + this.payload.getUuid() + "] delivery took " + this.timer.duration() + "ms");
    }

    @Override
    protected void onFailedUpload(String errorMsg) {
        log.error("LogForwarder: " + errorMsg);
        StatsEngine.SUPPORTABILITY.inc("Supportability/AgentHealth/LogReporting/FailedUpload");
    }

    @Override
    protected void onRequestException(Exception e) {
        this.onFailedUpload(e.toString());
    }

    @Override
    protected boolean shouldUploadOpportunistically() {
        try {
            String dest = this.getCollectorURI().toURL().getHost();
            InetAddress inet = InetAddress.getByName(dest);
            return dest.equals(inet.getHostName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean shouldRetry() {
        return true;
    }

    @Override
    protected URI getCollectorURI() {
        return URI.create(this.getProtocol() + this.agentConfiguration.getCollectorHost() + "/mobile/logs");
    }
}

