/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.android.ndk;

import android.content.Context;
import com.newrelic.agent.android.Agent;
import com.newrelic.agent.android.AgentConfiguration;
import com.newrelic.agent.android.NewRelic;
import com.newrelic.agent.android.agentdata.AgentDataController;
import com.newrelic.agent.android.agentdata.AgentDataReporter;
import com.newrelic.agent.android.analytics.AnalyticsAttribute;
import com.newrelic.agent.android.analytics.AnalyticsControllerImpl;
import com.newrelic.agent.android.crash.Crash;
import com.newrelic.agent.android.crash.CrashReporter;
import com.newrelic.agent.android.harvest.Harvest;
import com.newrelic.agent.android.harvest.HarvestAdapter;
import com.newrelic.agent.android.logging.AgentLog;
import com.newrelic.agent.android.logging.AgentLogManager;
import com.newrelic.agent.android.ndk.AgentNDK;
import com.newrelic.agent.android.ndk.AgentNDKListener;
import com.newrelic.agent.android.ndk.NativeCrash;
import com.newrelic.agent.android.ndk.NativeException;
import com.newrelic.agent.android.stats.StatsEngine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class NativeReporting
extends HarvestAdapter {
    protected static final AgentLog log = AgentLogManager.getAgentLog();
    protected static AtomicReference<NativeReporting> instance = new AtomicReference<Object>(null);
    protected static AtomicReference<AgentNDK> agentNdk = new AtomicReference<Object>(null);
    protected final NativeReportListener nativeReportListener = new NativeReportListener();

    public static NativeReporting getInstance() {
        return instance.get();
    }

    public static NativeReporting initialize(Context context, AgentConfiguration agentConfiguration) {
        instance.compareAndSet(null, new NativeReporting(context, agentConfiguration));
        Harvest.addHarvestListener(instance.get());
        StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Init");
        return instance.get();
    }

    public static void shutdown() {
        if (NativeReporting.isInitialized()) {
            Harvest.removeHarvestListener(instance.get());
            instance.get().stop();
        }
        instance.set(null);
    }

    public static boolean isInitialized() {
        return instance.get() != null && agentNdk.get() != null && AgentNDK.getInstance() != null;
    }

    public static void crashNow(String message) {
        if (NativeReporting.isInitialized()) {
            agentNdk.get().crashNow(message);
        }
    }

    public static boolean isRooted() {
        boolean isRooted = false;
        if (NativeReporting.isInitialized()) {
            StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/RootedDevice");
            isRooted = AgentNDK.getInstance().isRooted();
        }
        return isRooted;
    }

    protected NativeReporting(Context context, AgentConfiguration agentConfiguration) {
        agentNdk.compareAndSet(null, new AgentNDK.Builder(context).withBuildId(Agent.getBuildId()).withANRMonitor(!agentConfiguration.getApplicationExitConfiguration().isEnabled()).withSessionId(agentConfiguration.getSessionID()).withReportListener((AgentNDKListener)this.nativeReportListener).withLogger(AgentLogManager.getAgentLog()).build());
    }

    public void start() {
        if (NativeReporting.isInitialized()) {
            try {
                agentNdk.get().start();
                StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Start");
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            boolean isRooted = NativeReporting.isRooted();
            if (isRooted) {
                NewRelic.setAttribute("rootedDevice", isRooted);
            }
        } else {
            log.error("CrashReporter: Must first initialize native module.");
        }
    }

    void stop() {
        if (NativeReporting.isInitialized()) {
            try {
                agentNdk.get().stop();
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Stop");
            agentNdk.set(null);
        }
    }

    @Override
    public void onHarvestStart() {
        agentNdk.get().flushPendingReports();
        StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Reports/Flush");
    }

    static class NativeReportListener
    implements AgentNDKListener {
        NativeReportListener() {
        }

        public boolean onNativeCrash(String crashAsString) {
            StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Reports/NativeCrash");
            final AnalyticsControllerImpl analyticsController = AnalyticsControllerImpl.getInstance();
            HashSet<AnalyticsAttribute> sessionAttributes = new HashSet<AnalyticsAttribute>(){
                {
                    this.addAll(analyticsController.getSessionAttributes());
                }
            };
            NativeCrashException exceptionToHandle = new NativeCrashException(crashAsString);
            sessionAttributes.add(new AnalyticsAttribute("platform", "native"));
            sessionAttributes.add(new AnalyticsAttribute("nativeCrash", true));
            sessionAttributes.add(new AnalyticsAttribute("exceptionMessage", exceptionToHandle.getNativeStackTrace().getExceptionMessage()));
            if (null != exceptionToHandle.getNativeStackTrace().getCrashedThread()) {
                sessionAttributes.add(new AnalyticsAttribute("crashingThreadId", exceptionToHandle.getNativeStackTrace().getCrashedThread().getThreadId()));
            }
            NativeCrash crash = new NativeCrash((NativeException)exceptionToHandle, (Set)sessionAttributes, analyticsController.getEventManager().getQueuedEvents());
            if (null != CrashReporter.getInstance()) {
                CrashReporter.getInstance().storeAndReportCrash((Crash)crash);
                return true;
            }
            log.error("Could not report native crash: CrashReporter is disabled.");
            return false;
        }

        public boolean onNativeException(String exceptionAsString) {
            StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Reports/NativeException");
            HashMap<String, Object> exceptionAttributes = new HashMap<String, Object>(){
                {
                    this.put("platform", "native");
                    this.put("unhandledNativeException", true);
                }
            };
            NativeUnhandledException exceptionToHandle = new NativeUnhandledException(exceptionAsString);
            exceptionAttributes.put("nativeThreads", exceptionToHandle.getNativeStackTrace().getThreads());
            exceptionAttributes.put("exceptionMessage", exceptionToHandle.getNativeStackTrace().getExceptionMessage());
            if (null != exceptionToHandle.getNativeStackTrace().getCrashedThread()) {
                exceptionAttributes.put("crashingThreadId", exceptionToHandle.getNativeStackTrace().getCrashedThread().getThreadId());
            }
            if (null != AgentDataReporter.getInstance()) {
                return AgentDataController.sendAgentData((Throwable)((Object)exceptionToHandle), (Map<String, Object>)exceptionAttributes);
            }
            log.error("Could not report native exception: AgentDataReporter is disabled.");
            return false;
        }

        public boolean onApplicationNotResponding(String anrAsString) {
            StatsEngine.SUPPORTABILITY.inc("Supportability/Mobile/Android/NDK/Reports/ANR");
            HashMap<String, Object> exceptionAttributes = new HashMap<String, Object>(){
                {
                    this.put("platform", "native");
                    this.put("ANR", true);
                }
            };
            ANRException exceptionToHandle = new ANRException(anrAsString);
            exceptionAttributes.put("nativeThreads", exceptionToHandle.getNativeStackTrace().getThreads());
            exceptionAttributes.put("exceptionMessage", exceptionToHandle.getNativeStackTrace().getExceptionMessage());
            if (null != exceptionToHandle.getNativeStackTrace().getCrashedThread()) {
                exceptionAttributes.put("crashingThreadId", exceptionToHandle.getNativeStackTrace().getCrashedThread().getThreadId());
            }
            if (null != AgentDataReporter.getInstance()) {
                return AgentDataController.sendAgentData((Throwable)((Object)exceptionToHandle), (Map<String, Object>)exceptionAttributes);
            }
            log.error("Could not report native exception: AgentDataReporter is disabled.");
            return false;
        }
    }

    static class ANRException
    extends NativeException {
        public ANRException(String anrAsString) {
            super(anrAsString);
        }
    }

    static class NativeUnhandledException
    extends NativeException {
        public NativeUnhandledException(String exceptionAsString) {
            super(exceptionAsString);
        }
    }

    static class NativeCrashException
    extends NativeException {
        public NativeCrashException(String crashAsString) {
            super(crashAsString);
        }
    }
}

