/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Constants;
import com.newrelic.agent.compile.FileLogger;
import com.newrelic.agent.compile.InvocationDispatcher;
import com.newrelic.agent.compile.Logger;
import com.newrelic.agent.compile.SystemLogger;
import com.newrelic.agent.compile.transformers.ClassRewriterTransformer;
import com.newrelic.agent.util.BuildId;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class InstrumentationAgent
extends Constants {
    public static final String VERSION = "7.0.0";
    public static org.slf4j.Logger LOGGER = new Logger(){};
    private static Map<String, String> agentOptions = new HashMap<String, String>();

    public static Throwable withAgentArgs(String agentArgs) {
        try {
            agentOptions = InstrumentationAgent.parseAgentArgs(agentArgs);
            if (!agentOptions.isEmpty() && LOGGER instanceof Logger) {
                LOGGER = new SystemLogger(agentOptions);
            }
            System.setProperty("newrelic.agent.args", agentArgs);
            BuildId.invalidate();
        }
        catch (Throwable t) {
            return t;
        }
        return null;
    }

    @Deprecated
    public static void premain(String agentArgs, Instrumentation instrumentation) {
        Logger log;
        Throwable argsError = InstrumentationAgent.withAgentArgs(agentArgs);
        String logFileName = agentOptions.get("logfile");
        Logger logger = log = logFileName == null ? new SystemLogger(agentOptions) : new FileLogger(agentOptions, logFileName);
        if (argsError != null) {
            log.error("Agent args error: " + argsError);
        }
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        String pid = nameOfRunningVM.substring(0, p);
        log.debug("Bootstrapping New Relic Android class rewriter");
        log.debug("Agent running in pid " + pid + " arguments: " + agentArgs);
        try {
            ClassRewriterTransformer classTransformer = new ClassRewriterTransformer(log);
            log.info("Using class transformer.");
            InstrumentationAgent.createInvocationDispatcher(log);
            instrumentation.addTransformer(classTransformer, true);
            ArrayList<Class> classes = new ArrayList<Class>();
            for (Class clazz : instrumentation.getAllLoadedClasses()) {
                if (!classTransformer.modifies(clazz)) continue;
                classes.add(clazz);
            }
            if (!classes.isEmpty()) {
                if (instrumentation.isRetransformClassesSupported()) {
                    instrumentation.retransformClasses(classes.toArray(new Class[classes.size()]));
                } else {
                    log.warn("Unable to retransform classes: " + classes);
                }
            }
        }
        catch (Throwable ex) {
            log.error("Agent startup error", ex);
            throw new RuntimeException(ex);
        }
    }

    @Deprecated
    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        InstrumentationAgent.premain(agentArgs, instrumentation);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static Map<String, String> getAgentOptions() {
        return agentOptions;
    }

    public static String getProxyInvocationKey(String className, String methodName) {
        return className + "." + methodName;
    }

    public static Map<String, String> parseAgentArgs(String agentArgs) {
        if (agentArgs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (String arg : agentArgs.split(";")) {
            String[] keyValue = arg.split("=");
            if (keyValue.length != 2) continue;
            options.put(keyValue[0], keyValue[1]);
        }
        return options;
    }

    public static String getAgentJarPath() throws URISyntaxException {
        return new File(InstrumentationAgent.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getAbsolutePath();
    }

    private static void createInvocationDispatcher(org.slf4j.Logger log) throws Exception {
        Field field = InvocationDispatcher.INVOCATION_DISPATCHER_CLASS.getDeclaredField("treeLock");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        if (field.get(null) instanceof InvocationDispatcher) {
            log.info("Detected cached instrumentation.");
        } else {
            field.set(null, new InvocationDispatcher(log));
        }
    }
}

