/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.Constants;
import com.newrelic.agent.compile.ClassData;
import com.newrelic.agent.compile.ClassRemapperConfig;
import com.newrelic.agent.compile.ClassWriterSafe;
import com.newrelic.agent.compile.HaltBuildException;
import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.SkipException;
import com.newrelic.agent.compile.visitor.ActivityClassVisitor;
import com.newrelic.agent.compile.visitor.AnnotatingClassVisitor;
import com.newrelic.agent.compile.visitor.AsyncTaskClassVisitor;
import com.newrelic.agent.compile.visitor.ContextInitializationClassVisitor;
import com.newrelic.agent.compile.visitor.FragmentClassVisitor;
import com.newrelic.agent.compile.visitor.NewRelicClassVisitor;
import com.newrelic.agent.compile.visitor.PrefilterClassVisitor;
import com.newrelic.agent.compile.visitor.TraceAnnotationClassVisitor;
import com.newrelic.agent.compile.visitor.WrapMethodClassVisitor;
import com.newrelic.com.google.common.collect.ImmutableMap;
import com.newrelic.org.objectweb.asm.ClassReader;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import java.lang.reflect.InvocationHandler;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class InvocationDispatcher {
    public static final Class<java.util.logging.Logger> INVOCATION_DISPATCHER_CLASS = java.util.logging.Logger.class;
    public static final String INVOCATION_DISPATCHER_FIELD_NAME = "treeLock";
    private final Logger log;
    private final InstrumentationContext instrumentationContext;
    private final Pattern androidPackagePattern = Pattern.compile("^android[x]{0,1}/.*");
    private final Pattern kotlinPackagePattern = Pattern.compile("^kotlin[x]{0,1}/.*");
    final Map<String, InvocationHandler> invocationHandlers;

    public InvocationDispatcher(Logger log) throws ClassNotFoundException {
        ClassRemapperConfig config = new ClassRemapperConfig(log);
        this.log = log;
        this.instrumentationContext = new InstrumentationContext(config, log);
        this.invocationHandlers = ImmutableMap.of();
    }

    boolean isInstrumentationDisabled() {
        return System.getProperty("newrelic.instrumentation.disabled") != null;
    }

    boolean isIncludedPackage(String packageName) {
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : Constants.ANDROID_INCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    boolean isExcludedPackage(String packageName) {
        if (this.isIncludedPackage(packageName)) {
            return false;
        }
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : Constants.ANDROID_EXCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    boolean isKotlinSDKPackage(String className) {
        return this.kotlinPackagePattern.matcher(className.toLowerCase()).matches();
    }

    boolean isAndroidSDKPackage(String className) {
        return this.androidPackagePattern.matcher(className.toLowerCase()).matches() || this.isKotlinSDKPackage(className);
    }

    public ClassData visitClassBytes(byte[] bytes) {
        return this.visitClassBytesWithOptions(bytes, 2);
    }

    ClassData visitClassBytesWithOptions(byte[] bytes, int classWriterFlags) {
        String className = "unknown";
        if (this.isInstrumentationDisabled()) {
            return new ClassData(bytes, false);
        }
        try {
            ClassReader cr = new ClassReader(bytes);
            ClassWriterSafe cw = new ClassWriterSafe(cr, classWriterFlags);
            this.instrumentationContext.reset();
            this.instrumentationContext.setComputeFlags(classWriterFlags);
            cr.accept(new PrefilterClassVisitor(this.instrumentationContext, this.log), 7);
            className = this.instrumentationContext.getClassName();
            if (!this.instrumentationContext.hasTag("Lcom/newrelic/agent/android/instrumentation/Instrumented;")) {
                ClassVisitor cv = cw;
                if (className.equals("com/newrelic/agent/android/NewRelic")) {
                    cv = new NewRelicClassVisitor(cv, this.instrumentationContext, this.log);
                } else if (this.isAndroidSDKPackage(className)) {
                    cv = new ActivityClassVisitor(cv, this.instrumentationContext, this.log);
                } else {
                    if (this.isExcludedPackage(className)) {
                        return null;
                    }
                    cv = new AnnotatingClassVisitor(cv, this.instrumentationContext, this.log);
                    cv = new ActivityClassVisitor(cv, this.instrumentationContext, this.log);
                    cv = new FragmentClassVisitor(cv, this.instrumentationContext, this.log);
                    cv = new AsyncTaskClassVisitor(cv, this.instrumentationContext, this.log);
                    cv = new TraceAnnotationClassVisitor(cv, this.instrumentationContext, this.log);
                    cv = new WrapMethodClassVisitor(cv, this.instrumentationContext, this.log);
                }
                cv = new ContextInitializationClassVisitor(cv, this.instrumentationContext);
                try {
                    int parsingOptions = 8;
                    if ((this.instrumentationContext.getComputeFlags() & 2) == 0) {
                        parsingOptions = 4;
                    }
                    cr.accept(cv, parsingOptions);
                }
                catch (Exception e) {
                    if (classWriterFlags != 1) {
                        this.log.debug("[InvocationDispatcher] [" + className + "] " + e);
                        this.log.debug("[InvocationDispatcher] Retry with ClassWriter.COMPUTE_MAXS");
                        return this.visitClassBytesWithOptions(bytes, 1);
                    }
                    this.log.warn("[InvocationDispatcher] [" + className + "] instrumentation failed: " + e.getLocalizedMessage());
                    return new ClassData(bytes, false);
                }
                if (this.instrumentationContext.isClassModified() && bytes.length != cw.toByteArray().length) {
                    this.log.debug("[InvocationDispatcher] class[" + className + "] bytes[" + bytes.length + "] transformed[" + cw.toByteArray().length + "]");
                }
            } else {
                this.log.debug(MessageFormat.format("[{0}] class is already instrumented! skipping ...", this.instrumentationContext.getFriendlyClassName()));
            }
            return this.instrumentationContext.newClassData(cw.toByteArray());
        }
        catch (SkipException e) {
            this.log.debug("[InvocationDispatcher] " + e);
            return new ClassData(bytes, false);
        }
        catch (IllegalArgumentException e) {
            this.log.warn("[InvocationDispatcher] Class[" + className + "] ignored: JDK not supported");
            return new ClassData(bytes, false);
        }
        catch (HaltBuildException e) {
            this.log.debug("[InvocationDispatcher] " + e);
            throw new RuntimeException(e);
        }
        catch (NoClassDefFoundError e) {
            this.log.warn("Unfortunately, an error has occurred while processing class [" + className + "].\nThe file is unable to be parsed. Please copy your build logs and the jar containing this class and visit http://support.newrelic.com, thanks!\n" + e.getLocalizedMessage());
            return new ClassData(bytes, false);
        }
        catch (Throwable t) {
            this.log.error("Unfortunately, an error has occurred while processing class [" + className + "].\nPlease copy your build logs and the jar containing this class and visit http://support.newrelic.com, thanks!\n" + t.getMessage(), t);
            this.log.debug("Throwable type[" + t + "].\n");
            if (t.getMessage() != null) {
                this.log.debug("  message[" + t.getMessage() + "].\n");
            }
            if (t.getCause() != null) {
                this.log.debug("  cause[" + t.getCause() + "].\n");
            }
            return new ClassData(bytes, false);
        }
    }

    public InstrumentationContext getInstrumentationContext() {
        return this.instrumentationContext;
    }
}

