/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.visitor.ActivityClassAdapter;
import com.newrelic.agent.compile.visitor.TraceClassDecorator;
import com.newrelic.agent.compile.visitor.TraceMethodVisitor;
import com.newrelic.com.google.common.collect.ImmutableMap;
import com.newrelic.com.google.common.collect.ImmutableSet;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.Map;
import org.slf4j.Logger;

public class ActivityClassVisitor
extends ActivityClassAdapter {
    static final Type applicationStateMonitorType = Type.getObjectType("com/newrelic/agent/android/background/ApplicationStateMonitor");
    static final ImmutableSet<String> ACTIVITY_CLASSES = ImmutableSet.of("^(android\\/.*\\/)(.*Activity)", "^(android\\/app\\/)(ActivityGroup)", "^(android\\/.*\\/)(.*Activity)([DGH].*)", "^(androidx\\/.*\\/)(.*Activity)", "^(androidx\\/)(ActivityCompat)");
    public static final ImmutableMap<String, Integer> methodAccessMap = ImmutableMap.of("onStart", 4, "onStop", 4);
    public static final Map<Method, Method> methodDelegateMap = ImmutableMap.of(new Method("onStart", "()V"), new Method("activityStarted", "()V"), new Method("onStop", "()V"), new Method("activityStopped", "()V"));

    public ActivityClassVisitor(ClassVisitor cv, InstrumentationContext context, Logger log) {
        super(cv, context, log, ACTIVITY_CLASSES, methodDelegateMap);
        this.access = 0;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.instrument = this.shouldInstrumentClass(name, superName);
        if (this.instrument) {
            interfaces = TraceClassDecorator.addInterface(interfaces);
            this.log.info("[ActivityClassVisitor] Added Trace interface to class[" + this.context.getClassName() + "] superName[" + superName + "]");
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    protected void injectCodeIntoMethod(GeneratorAdapter generatorAdapter, Method method, Method monitorMethod) {
        if (method.getName().equalsIgnoreCase("onStart")) {
            generatorAdapter.invokeStatic(applicationStateMonitorType, new Method("getInstance", applicationStateMonitorType, new Type[0]));
            generatorAdapter.invokeVirtual(applicationStateMonitorType, monitorMethod);
            this.log.debug("[ActivityClassVisitor] injecting onStart method");
        } else if (method.getName().equalsIgnoreCase("onStop")) {
            generatorAdapter.invokeStatic(applicationStateMonitorType, new Method("getInstance", applicationStateMonitorType, new Type[0]));
            generatorAdapter.invokeVirtual(applicationStateMonitorType, monitorMethod);
            this.log.debug("[ActivityClassVisitor] injecting onStop method");
        } else if (method.getName().equalsIgnoreCase("onBackPressed")) {
            this.log.debug("[ActivityClassVisitor] injecting onBackPressed method");
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        if (this.context.isSkippedMethod(methodName, desc)) {
            this.log.debug("[ActivityClassVisitor] @SkipTrace applied to method [" + methodName + ", " + desc + "]");
        } else if (this.instrument && traceMethodMap.containsKey(methodName) && ((String)traceMethodMap.get(methodName)).equals(desc)) {
            this.log.info("[ActivityClassVisitor] Tracing method [" + methodName + "]");
            MethodVisitor methodVisitor = super.visitMethod(access, methodName, desc, signature, exceptions);
            TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, methodName, desc, this.context);
            if (startTracingOn.contains(methodName)) {
                this.log.debug("[ActivityClassVisitor] Start new trace for [" + methodName + "]");
                traceMethodVisitor.setStartTracing();
            }
            return traceMethodVisitor;
        }
        return super.visitMethod(access, methodName, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.instrument) {
            TraceClassDecorator decorator = new TraceClassDecorator(this);
            decorator.addTraceField();
            this.log.debug("[ActivityClassVisitor] Added Trace object to " + this.context.getClassName());
            if ((this.access & 0x400) != 0) {
                this.log.info("[ActivityClassVisitor] Abstract base class: adding TraceFieldInterface impl to [" + this.context.getClassName() + "]");
                decorator.addTraceInterface(Type.getObjectType(this.context.getClassName()));
            }
        }
        this.access = 0;
        super.visitEnd();
    }

    @Override
    protected int provideAccessForMethod(String methodName) {
        Integer v = methodAccessMap.get(methodName);
        return v != null ? v : 4;
    }
}

