/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.InstrumentationAgent;
import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.util.BuildId;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.FieldVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import org.slf4j.Logger;

public class NewRelicClassVisitor
extends ClassVisitor {
    private final InstrumentationContext context;
    private final Logger log;

    public NewRelicClassVisitor(ClassVisitor cv, InstrumentationContext context, Logger log) {
        super(589824, cv);
        this.context = context;
        this.log = log;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.context.getClassName().equals("com/newrelic/agent/android/NewRelic") && name.equals("isInstrumented")) {
            return new NewRelicMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        }
        if (this.context.getClassName().equals("com/newrelic/agent/android/crash/Crash") && name.equals("getBuildId")) {
            return new BuildIdMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.context.getClassName().equals("com/newrelic/agent/android/Agent") && name.equals("VERSION") && !value.equals(InstrumentationAgent.getVersion())) {
            this.log.warn("New Relic Error: Your agent and class rewriter versions do not match: agent[" + value + "] class rewriter[" + InstrumentationAgent.getVersion() + "]. You may need to update one of these components, or simply invalidate your AndroidStudio cache.  If you're using gradle and just updated, run gradle -stop to restart the daemon.");
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private final class NewRelicMethodVisitor
    extends GeneratorAdapter {
        public NewRelicMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(589824, mv, access, name, desc);
        }

        @Override
        public void visitCode() {
            super.visitInsn(4);
            super.visitInsn(172);
            NewRelicClassVisitor.this.log.info("[NewRelicMethodVisitor] Marking NewRelic agent as instrumented");
            NewRelicClassVisitor.this.context.markModified();
        }
    }

    private final class BuildIdMethodVisitor
    extends GeneratorAdapter {
        public BuildIdMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(589824, mv, access, name, desc);
        }

        @Override
        public void visitCode() {
            String buildId = BuildId.getBuildId(NewRelicClassVisitor.this.context.getVariantName());
            super.visitLdcInsn(buildId);
            super.visitInsn(176);
            NewRelicClassVisitor.this.log.info("[NewRelicMethodVisitor] Setting build identifier to [" + buildId + "]");
            NewRelicClassVisitor.this.context.markModified();
        }
    }
}

