/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.InstrumentationAgent;
import com.newrelic.com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class BuildId {
    public static final String BUILD_ID_KEY = "NewRelic.buildId";
    public static final String DEFAULT_VARIANT = "release";
    private static AtomicReference<Map<String, String>> variantBuildIds = new AtomicReference<Object>(null);
    private static Logger log = InstrumentationAgent.LOGGER;
    private static boolean variantMapsEnabled = true;

    static String autoBuildId() {
        return UUID.randomUUID().toString();
    }

    public static void invalidate() {
        System.clearProperty(BUILD_ID_KEY);
        variantBuildIds.set(null);
        BuildId.getDefaultBuildId();
    }

    public static String getDefaultBuildId() {
        variantBuildIds.compareAndSet(null, new HashMap());
        String buildId = variantBuildIds.get().get(DEFAULT_VARIANT);
        if (Strings.isNullOrEmpty(buildId)) {
            buildId = BuildId.autoBuildId();
            variantBuildIds.get().put(DEFAULT_VARIANT, buildId);
        }
        if (Strings.isNullOrEmpty(buildId = variantBuildIds.get().get(DEFAULT_VARIANT))) {
            log.error("NewRelic has detected an invalid build ID. Please clean and rebuild the project.");
        }
        return buildId;
    }

    public static String getBuildId(String variantName) {
        if (!variantMapsEnabled || Strings.isNullOrEmpty(variantName)) {
            return BuildId.getDefaultBuildId();
        }
        variantName = variantName.toLowerCase();
        String buildId = variantBuildIds.get().get(variantName);
        if (Strings.isNullOrEmpty(buildId)) {
            buildId = BuildId.autoBuildId();
            variantBuildIds.get().put(variantName, buildId);
            log.debug("buildId[" + variantName + "] = [" + buildId + "]");
        }
        return variantBuildIds.get().get(variantName);
    }

    public static Map<String, String> getVariantBuildIds() {
        return variantBuildIds.get();
    }

    public static void setVariantMapsEnabled(boolean variantMapsEnabled) {
        BuildId.variantMapsEnabled = variantMapsEnabled;
        log.debug("Variant buildIds have been " + (BuildId.variantMapsEnabled ? "enabled" : "disabled"));
    }

    static {
        BuildId.invalidate();
    }
}

