/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.android.instrumentation.ReplaceCallSite;
import com.newrelic.agent.android.instrumentation.WrapReturn;
import com.newrelic.agent.util.Annotations;
import com.newrelic.agent.util.MethodAnnotation;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.reflections.util.ClasspathHelper;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MapFileGenerator {
    private static final int KNOWN_MAP_SIZE = 83;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage:   MapFileGenerator class_dir");
            System.exit(1);
        }
        try {
            Class.forName("com.newrelic.agent.android.Agent");
        }
        catch (Exception ex) {
            System.err.println("Unable to load agent classes");
            System.exit(1);
        }
        Map<String, String> remapperProperties = MapFileGenerator.getRemapperProperties();
        if (remapperProperties.size() == 0) {
            System.err.println("No class mappings were found");
            System.exit(1);
        }
        for (Map.Entry<String, String> entry : remapperProperties.entrySet()) {
            System.out.println(entry.getKey() + " = " + entry.getValue());
        }
        Properties props = new Properties();
        props.putAll(remapperProperties);
        try {
            Set urls = ClasspathHelper.forPackage((String)"com.newrelic.agent", (ClassLoader[])new ClassLoader[0]);
            if (props.size() != 83) {
                System.err.println("Classpath: " + urls);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    System.err.println(entry.getKey() + "[" + entry.getValue() + "]");
                }
                RuntimeException e = new RuntimeException("Generated " + props.size() + "  of 83 expected elements from classpath [" + urls + "]");
                System.err.println(e);
                throw e;
            }
            System.out.println("Storing mapping data to " + args[0]);
            FileOutputStream out = new FileOutputStream(args[0]);
            props.store(out, "");
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static Map<String, String> getRemapperProperties() {
        HashMap<String, String> classMap = new HashMap<String, String>();
        Set urls = ClasspathHelper.forPackage((String)"com.newrelic.agent", (ClassLoader[])new ClassLoader[0]);
        System.out.println("Classpath URLS: " + urls);
        Collection<MethodAnnotation> wrapReturnAnnotations = Annotations.getMethodAnnotations(WrapReturn.class, "com/newrelic/agent", urls);
        for (MethodAnnotation annotation : wrapReturnAnnotations) {
            String originalClassName = (String)annotation.getAttributes().get("className");
            String originalMethodName = (String)annotation.getAttributes().get("methodName");
            String originalMethodDesc = (String)annotation.getAttributes().get("methodDesc");
            String newClassName = annotation.getClassName();
            String newMethodName = annotation.getMethodName();
            classMap.put("WRAP_METHOD:" + originalClassName.replace('.', '/') + "." + originalMethodName + originalMethodDesc, newClassName + "." + newMethodName + annotation.getMethodDesc());
        }
        Collection<MethodAnnotation> callSiteAnnotations = Annotations.getMethodAnnotations(ReplaceCallSite.class, "com/newrelic/agent", urls);
        for (MethodAnnotation annotation : callSiteAnnotations) {
            Boolean isStatic = (Boolean)annotation.getAttributes().get("isStatic");
            String scope = (String)annotation.getAttributes().get("scope");
            if (isStatic == null) {
                isStatic = Boolean.FALSE;
            }
            String originalMethodName = annotation.getMethodName();
            String originalMethodDesc = annotation.getMethodDesc();
            if (!isStatic.booleanValue()) {
                Type[] argTypes = Type.getArgumentTypes(originalMethodDesc);
                Type[] newArgTypes = new Type[argTypes.length - 1];
                for (int i = 0; i < newArgTypes.length; ++i) {
                    newArgTypes[i] = argTypes[i + 1];
                }
                Type returnType = Type.getReturnType(originalMethodDesc);
                originalMethodDesc = Type.getMethodDescriptor(returnType, newArgTypes);
            }
            String newClassName = annotation.getClassName();
            String newMethodName = annotation.getMethodName();
            if (scope == null) {
                classMap.put("REPLACE_CALL_SITE:" + originalMethodName + originalMethodDesc, newClassName + "." + newMethodName + annotation.getMethodDesc());
                continue;
            }
            classMap.put("REPLACE_CALL_SITE:" + scope.replace('.', '/') + "." + originalMethodName + originalMethodDesc, newClassName + "." + newMethodName + annotation.getMethodDesc());
        }
        return classMap;
    }
}

