/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.org.slf4j.Marker;
import com.newrelic.org.slf4j.event.Level;
import com.newrelic.org.slf4j.helpers.LegacyAbstractLogger;
import java.util.Map;

public abstract class Logger
extends LegacyAbstractLogger {
    protected final Level logLevel;

    protected Logger() {
        this.logLevel = Level.WARN;
        this.name = this.getFullyQualifiedCallerName();
    }

    public Logger(Map<String, String> agentOptions) {
        String logLevelOpt = agentOptions.getOrDefault("loglevel", Level.WARN.name());
        this.logLevel = Level.valueOf(logLevelOpt);
    }

    protected void log(String level, String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(Level level, String message) {
        if (this.isLevelEnabled(level)) {
            Logger logger = this;
            synchronized (logger) {
                this.log(level.name(), message);
            }
        }
    }

    boolean isLevelEnabled(Level level) {
        return this.logLevel.toInt() <= level.toInt();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.ERROR);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARN);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Level.TRACE);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    @Override
    protected String getFullyQualifiedCallerName() {
        return "newrelic";
    }

    @Override
    protected void handleNormalizedLoggingCall(Level level, Marker marker, String s, Object[] objects, Throwable throwable) {
        this.log(level.name(), String.format(s, objects));
    }
}

