/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public abstract class AgentDelegateClassVisitor
extends ClassVisitor {
    protected String superName;
    protected boolean instrument = false;
    protected int access = 0;
    private Pattern classPackagePattern = Pattern.compile("^android[x]{0,1}/.*");
    protected final InstrumentationContext context;
    protected final Logger log;
    protected final Map<String, Pattern> delegatedClassPatterns;
    protected final Map<Method, AgentDelegateMethodVisitorFactory> methodVisitors;
    protected final Map<String, Integer> methodAccessMap;

    public AgentDelegateClassVisitor(ClassVisitor cv, InstrumentationContext context, Logger log, final Set<String> delegateClasses, final Map<Method, Method> delegateMethods, Map<String, Integer> delegateMethodAccessMap) {
        super(589824, cv);
        this.context = context;
        this.log = log;
        this.delegatedClassPatterns = new HashMap<String, Pattern>(){
            {
                for (String pattern : delegateClasses) {
                    this.put(pattern, Pattern.compile(pattern));
                }
            }
        };
        this.methodVisitors = new HashMap<Method, AgentDelegateMethodVisitorFactory>(){
            {
                for (Map.Entry entry : delegateMethods.entrySet()) {
                    this.put((Method)entry.getKey(), new AgentDelegateMethodVisitorFactory((Method)entry.getValue()));
                }
            }
        };
        this.methodAccessMap = delegateMethodAccessMap;
        this.superName = context.getSuperClassName();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.superName = superName;
        this.access = access;
        this.instrument = this.isInstrumentable(name, superName);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (!this.instrument) {
            return mv;
        }
        Method method = new Method(name, desc);
        AgentDelegateMethodVisitorFactory v = this.methodVisitors.get(method);
        if (v != null) {
            this.methodVisitors.remove(method);
            return v.createMethodVisitor(access, method, mv, false);
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.instrument) {
            super.visitEnd();
            return;
        }
        this.context.markModified();
        for (Map.Entry<Method, AgentDelegateMethodVisitorFactory> entry : this.methodVisitors.entrySet()) {
            String className = entry.getKey().getName();
            String classDescr = entry.getKey().getDescriptor();
            int access = this.provideAccessForMethod(className);
            MethodVisitor mv = super.visitMethod(access, className, classDescr, null, null);
            mv = entry.getValue().createMethodVisitor(access, entry.getKey(), mv, true);
            mv.visitCode();
            Type methodReturn = entry.getValue().agentDelegateMethod.getReturnType();
            if (methodReturn == Type.VOID_TYPE) {
                mv.visitInsn(177);
            } else if (methodReturn == Type.BOOLEAN_TYPE) {
                mv.visitInsn(172);
            } else {
                mv.visitInsn(173);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    protected abstract void injectIntoMethod(GeneratorAdapter var1, Method var2, Method var3);

    protected int provideAccessForMethod(String methodName) {
        Integer v = this.methodAccessMap.get(methodName);
        return v != null ? v : 4;
    }

    protected boolean isInstrumentable(String className, String superName) {
        if (!this.classPackagePattern.matcher(className.toLowerCase()).matches()) {
            for (Pattern baseClassPattern : this.delegatedClassPatterns.values()) {
                Matcher matcher = baseClassPattern.matcher(superName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isInstrumentable(Method method) {
        for (Method methodVisitor : this.methodVisitors.keySet()) {
            if (!methodVisitor.getName().equalsIgnoreCase(method.getName())) continue;
            return true;
        }
        return false;
    }

    protected class AgentDelegateMethodVisitorFactory {
        final Method agentDelegateMethod;

        public AgentDelegateMethodVisitorFactory(Method delegateMethod) {
            this.agentDelegateMethod = delegateMethod;
        }

        public MethodVisitor createMethodVisitor(int access, final Method method, MethodVisitor mv, final boolean callSuper) {
            return new GeneratorAdapter(589824, mv, access, method.getName(), method.getDescriptor()){

                @Override
                public void visitCode() {
                    super.visitCode();
                    if (callSuper) {
                        this.loadThis();
                        for (int i = 0; i < method.getArgumentTypes().length; ++i) {
                            this.loadArg(i);
                        }
                        this.visitMethodInsn(183, AgentDelegateClassVisitor.this.superName, method.getName(), method.getDescriptor(), false);
                    }
                    AgentDelegateClassVisitor.this.injectIntoMethod(this, method, AgentDelegateMethodVisitorFactory.this.agentDelegateMethod);
                }
            };
        }
    }
}

