/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile.visitor;

import com.newrelic.agent.compile.InstrumentationContext;
import com.newrelic.agent.compile.visitor.AgentDelegateClassVisitor;
import com.newrelic.agent.compile.visitor.TraceClassDecorator;
import com.newrelic.agent.compile.visitor.TraceMethodVisitor;
import com.newrelic.com.google.common.collect.ImmutableMap;
import com.newrelic.com.google.common.collect.ImmutableSet;
import com.newrelic.org.objectweb.asm.ClassVisitor;
import com.newrelic.org.objectweb.asm.MethodVisitor;
import com.newrelic.org.objectweb.asm.Type;
import com.newrelic.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.org.objectweb.asm.commons.Method;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class FragmentClassVisitor
extends AgentDelegateClassVisitor {
    static final ImmutableSet<String> FRAGMENT_CLASSES = ImmutableSet.of("^(android\\/.*\\/)(.*Fragment)", "^(android\\/support\\/v%d\\/.*\\/)(.*FragmentCompat)", "^(androidx\\/.*\\/)(Fragment)", "^(androidx\\/.*\\/)(FragmentCompat)", "^(androidx\\/.*\\/)(.*Fragment)");
    public static final Map<Method, Method> methodDelegateMap = ImmutableMap.of(new Method("onStart", "()V"), new Method("onActivityStarted", "(Ljava/lang/Object;)V"), new Method("onStop", "()V"), new Method("onActivityStopped", "(Ljava/lang/Object;)V"));
    public static final Map<String, Integer> methodAccessMap = ImmutableMap.of("onStart", 4, "onStop", 4);
    public static final Map<String, String> tracedMethodMap = ImmutableMap.of("onCreate", "(Landroid/os/Bundle;)V", "onCreateView", "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;");
    public static final Set<String> startTracingOn = ImmutableSet.of("onCreate");

    public FragmentClassVisitor(ClassVisitor cv, InstrumentationContext context, Logger log) {
        super(cv, context, log, FRAGMENT_CLASSES, methodDelegateMap, methodAccessMap);
        this.access = 0;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.instrument = this.isInstrumentable(name, superName);
        if (this.instrument) {
            interfaces = TraceClassDecorator.addInterface(interfaces);
            this.log.info("[FragmentClassVisitor] Added Trace interface to class[" + this.context.getClassName() + "] superName[" + superName + "]");
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    protected void injectIntoMethod(GeneratorAdapter generatorAdapter, Method method, Method agentDelegateMethod) {
        if (method.getName().equalsIgnoreCase("onStart") || method.getName().equalsIgnoreCase("onStop")) {
            this.log.debug("[FragmentClassVisitor] inject [" + method.getName() + "]");
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        if (this.context.isSkippedMethod(methodName, desc)) {
            this.log.debug("[FragmentClassVisitor] @SkipTrace applied to method [" + methodName + ", " + desc + "]");
        } else if (this.instrument && tracedMethodMap.containsKey(methodName) && tracedMethodMap.get(methodName).equals(desc)) {
            this.log.debug("[FragmentClassVisitor] Tracing method [" + methodName + "]");
            MethodVisitor methodVisitor = super.visitMethod(access, methodName, desc, signature, exceptions);
            TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(methodVisitor, access, methodName, desc, this.context);
            if (startTracingOn.contains(methodName)) {
                this.log.debug("[FragmentClassVisitor] Start new trace for [" + methodName + "]");
                traceMethodVisitor.setStartTracing();
            }
            return traceMethodVisitor;
        }
        return super.visitMethod(access, methodName, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.instrument) {
            TraceClassDecorator decorator = new TraceClassDecorator(this);
            decorator.addTraceField();
            this.log.debug("[FragmentClassVisitor] Added Trace object to " + this.context.getClassName());
            if ((this.access & 0x400) != 0) {
                this.log.info("[FragmentClassVisitor] Abstract base class: adding TraceFieldInterface impl to [" + this.context.getClassName() + "]");
                decorator.addTraceInterface(Type.getObjectType(this.context.getClassName()));
            }
        }
        this.access = 0;
        super.visitEnd();
    }
}

