/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.DistributedTracePayload;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.deps.com.google.common.base.Charsets;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.org.apache.axis.encoding.Base64;
import java.util.logging.Level;

public class DistributedTracePayloadImpl
implements DistributedTracePayload {
    public final long timestamp;
    public final String parentType;
    public final String accountId;
    public final String applicationId;
    public final String id;
    public final String traceId;
    public final Float priority;
    public final Boolean sampled;
    public final String parentId;
    public final String txnId;

    public static DistributedTracePayloadImpl createDistributedTracePayload(DistributedTracePayloadImpl inboundPayload, String traceId, String guid, String txnId, float priority) {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        String accountId = distributedTraceService.getAccountId();
        if (accountId == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Not creating distributed trace payload due to null accountId.");
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/DistributedTrace/CreatePayload/Ignored/NoAccountId", 1));
            return null;
        }
        String applicationId = distributedTraceService.getApplicationId();
        long timestamp = System.currentTimeMillis();
        String parentType = "App";
        boolean hasInboundPayload = inboundPayload != null;
        boolean sampled = DistributedTraceUtil.isSampledPriority(priority);
        String parentId = hasInboundPayload ? inboundPayload.id : null;
        return new DistributedTracePayloadImpl(timestamp, parentType, accountId, applicationId, guid, traceId, txnId, Float.valueOf(priority), sampled, parentId);
    }

    private DistributedTracePayloadImpl(long timestamp, String parentType, String accountId, String applicationId, String id, String traceId, String txnId, Float priority, Boolean sampled, String parentId) {
        this.timestamp = timestamp;
        this.parentType = parentType;
        this.accountId = accountId;
        this.applicationId = applicationId;
        this.id = id;
        this.txnId = txnId;
        this.traceId = traceId;
        this.priority = priority;
        this.sampled = sampled;
        this.parentId = parentId;
    }

    public String text() {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONObject payload = new JSONObject();
        JSONArray catVersion = new JSONArray();
        catVersion.add(distributedTraceService.getMajorSupportedCatVersion());
        catVersion.add(distributedTraceService.getMinorSupportedCatVersion());
        payload.put("v", catVersion);
        JSONObject data = new JSONObject();
        data.put("ti", this.timestamp);
        data.put("ty", this.parentType);
        data.put("ac", this.accountId);
        data.put("ap", this.applicationId);
        if (this.id != null) {
            data.put("id", this.id);
            data.put("tr", this.traceId);
            data.put("pr", this.priority);
            data.put("tx", this.txnId);
            data.put("sa", this.sampled);
            data.put("pa", this.parentId);
        }
        payload.put("d", data);
        return payload.toJSONString();
    }

    public String httpSafe() {
        return Base64.encode(this.text().getBytes(Charsets.UTF_8));
    }

    public static DistributedTracePayloadImpl parseDistributedTracePayload(DistributedTracePayloadImpl outboundPayloadData, String payload) {
        char firstChar;
        if (payload == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is null.");
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/DistributedTrace/AcceptPayload/Ignored/Null", 1));
            return null;
        }
        if (outboundPayloadData != null) {
            Agent.LOG.log(Level.WARNING, "Error: createDistributedTracePayload was called before acceptDistributedTracePayload. Ignoring Call");
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/DistributedTrace/AcceptPayload/Ignored/CreateBeforeAccept", 1));
            return null;
        }
        if (!payload.trim().isEmpty() && (firstChar = (payload = payload.trim()).charAt(0)) != '{' && firstChar != '[') {
            payload = new String(Base64.decode(payload), Charsets.UTF_8);
        }
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONParser parser = new JSONParser();
        try {
            boolean trustedAccount;
            JSONObject object = (JSONObject)parser.parse(payload);
            JSONArray version = (JSONArray)object.get("v");
            Long majorVersion = (Long)version.get(0);
            int majorSupportedVersion = distributedTraceService.getMajorSupportedCatVersion();
            if (majorVersion > (long)majorSupportedVersion) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload major version: {0} is newer than supported agent version: {1}. Ignoring payload.", (Object)majorVersion, (Object)majorSupportedVersion);
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/DistributedTrace/AcceptPayload/Ignored/MajorVersion", 1));
                return null;
            }
            JSONObject data = (JSONObject)object.get("d");
            String accountId = distributedTraceService.getAccountId();
            String payloadAccountId = (String)data.get("ac");
            CrossProcessConfig crossProcessConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getCrossProcessConfig();
            boolean bl = trustedAccount = crossProcessConfig.isTrustedAccountId(payloadAccountId) || accountId.equals(payloadAccountId);
            if (accountId == null || payloadAccountId == null || !trustedAccount) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload accountId: {0} does not match trusted accountIds: {1}. Ignoring payload.", (Object)payloadAccountId, (Object)accountId);
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/DistributedTrace/AcceptPayload/Ignored/UntrustedAccount", 1));
                return null;
            }
            long timestamp = (Long)data.get("ti");
            String parentType = (String)data.get("ty");
            String applicationId = (String)data.get("ap");
            String id = (String)data.get("id");
            String traceId = (String)data.get("tr");
            String txnId = (String)data.get("tx");
            Number priorityNumber = (Number)data.get("pr");
            Float priority = priorityNumber != null ? Float.valueOf(priorityNumber.floatValue()) : null;
            Boolean sampled = (Boolean)data.get("sa");
            String parentId = (String)data.get("pa");
            DistributedTracePayloadImpl distributedTracePayload = new DistributedTracePayloadImpl(timestamp, parentType, payloadAccountId, applicationId, id, traceId, txnId, priority, sampled, parentId);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Parsed distributed trace payload: {0}", distributedTracePayload);
            }
            return distributedTracePayload;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Failed to parse distributed trace payload");
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/DistributedTrace/AcceptPayload/ParseException", 1));
            return null;
        }
    }

    public String toString() {
        return "DistributedTracePayloadImpl{timestamp=" + this.timestamp + ", parentType='" + this.parentType + '\'' + ", accountId='" + this.accountId + '\'' + ", applicationId='" + this.applicationId + '\'' + ", id='" + this.id + '\'' + ", traceId='" + this.traceId + '\'' + ", txnId='" + this.txnId + '\'' + ", sampled=" + this.sampled + ", priority=" + this.priority + ", parentId=" + this.parentId + '}';
    }
}

