/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionConfigListener;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.ForceRestartException;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.InternalLimitExceeded;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.MetricDataException;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.BrowserMonitoringConfig;
import com.newrelic.agent.config.Hostname;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.apache.http.conn.HttpHostConnectException;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.environment.AgentIdentity;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.environment.EnvironmentChangeListener;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.errors.ErrorServiceImpl;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.metric.MetricIdRegistry;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.profile.ProfileData;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AnalyticsEvent;
import com.newrelic.agent.service.analytics.BaseInternalCustomEvent;
import com.newrelic.agent.service.analytics.CustomInsightsEvent;
import com.newrelic.agent.service.analytics.ErrorEvent;
import com.newrelic.agent.service.analytics.SpanEvent;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.service.module.Jar;
import com.newrelic.agent.service.module.Module;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.transaction.TransactionNamingScheme;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderFactory;
import com.newrelic.agent.transport.DataSenderListener;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.utilization.UtilizationData;
import java.lang.management.ManagementFactory;
import java.net.ConnectException;
import java.rmi.UnexpectedException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class RPMService
extends AbstractService
implements IRPMService,
EnvironmentChangeListener,
AgentConfigListener {
    public static final String COLLECT_TRACES_KEY = "collect_traces";
    public static final String COLLECT_ERRORS_KEY = "collect_errors";
    public static final String DATA_REPORT_PERIOD_KEY = "data_report_period";
    private static final int LOG_MESSAGE_COUNT = 5;
    private final String host;
    private final int port;
    private volatile boolean connected = false;
    private final ErrorService errorService;
    private long lastReportTime;
    private final String appName;
    private final List<String> appNames;
    private final ConnectionConfigListener connectionConfigListener;
    private final ConnectionListener connectionListener;
    private final boolean isMainApp;
    private volatile boolean hasEverConnected = false;
    private final DataSender dataSender;
    private final MetricIdRegistry metricIdRegistry = new MetricIdRegistry();
    private long connectionTimestamp = 0L;
    private final AtomicInteger last503Error = new AtomicInteger(0);
    private final AtomicInteger retryCount = new AtomicInteger(0);
    private String rpmLink;

    public RPMService(List<String> appNames, ConnectionConfigListener connectionConfigListener, ConnectionListener connectionListener) {
        this(appNames, connectionConfigListener, connectionListener, null);
    }

    RPMService(List<String> appNames, ConnectionConfigListener connectionConfigListener, ConnectionListener connectionListener, DataSenderListener dataSenderListener) {
        super(RPMService.class.getSimpleName() + "/" + appNames.get(0));
        this.appName = appNames.get(0).intern();
        AgentConfig config = ServiceFactory.getConfigService().getAgentConfig(this.appName);
        this.dataSender = DataSenderFactory.create(config, dataSenderListener);
        this.appNames = appNames;
        this.connectionConfigListener = connectionConfigListener;
        this.connectionListener = connectionListener;
        this.lastReportTime = System.currentTimeMillis();
        this.errorService = new ErrorServiceImpl(this.appName);
        this.host = config.getHost();
        this.port = config.getPort();
        this.isMainApp = this.appName.equals(config.getApplicationName());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        this.addHarvestablesToServices();
        this.connect();
        ServiceFactory.getEnvironmentService().getEnvironment().addEnvironmentChangeListener(this);
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
        ServiceFactory.getServiceManager().getCircuitBreakerService().addRPMService(this);
        this.errorService.start();
    }

    private Boolean getAndLogHighSecurity(AgentConfig config) {
        boolean isHighSec = config.isHighSecurity();
        if (isHighSec) {
            Agent.LOG.log(Level.INFO, "High security is configured locally for application {0}.", this.appName);
        }
        return isHighSec;
    }

    private void addHarvestablesToServices() {
        ServiceFactory.getServiceManager().getInsights().addHarvestableToService(this.appName);
        ServiceFactory.getTransactionEventsService().addHarvestableToService(this.appName);
        this.errorService.addHarvestableToService();
        ServiceFactory.getSpanEventService().addHarvestableToService(this.appName);
    }

    protected Map<String, Object> getStartOptions() {
        AgentConfig agentConfig = ServiceFactory.getConfigService().getAgentConfig(this.appName);
        int pid = ServiceFactory.getEnvironmentService().getProcessPID();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("pid", pid);
        String language = agentConfig.getLanguage();
        options.put("language", language);
        String defaultHost = Hostname.getHostname(agentConfig, true);
        options.put("host", defaultHost);
        String displayHost = Hostname.getDisplayHostname(agentConfig, defaultHost);
        options.put("display_host", displayHost);
        Agent.LOG.log(Level.INFO, "Host name is {0}, display host {1} for application {2}", defaultHost, displayHost, this.appName);
        options.put("high_security", this.getAndLogHighSecurity(agentConfig));
        Environment environment = ServiceFactory.getEnvironmentService().getEnvironment();
        options.put("environment", environment);
        if (agentConfig.getProperty("send_environment_info", true).booleanValue()) {
            options.put("settings", this.getSettings());
        }
        UtilizationData utilizationData = ServiceFactory.getUtilizationService().updateUtilizationData();
        options.put("utilization", utilizationData.map());
        String instanceName = environment.getAgentIdentity().getInstanceName();
        if (instanceName != null) {
            options.put("instance_name", instanceName);
        }
        options.put("agent_version", Agent.getVersion());
        options.put("app_name", this.appNames);
        StringBuilder identifier = new StringBuilder(language);
        identifier.append(':').append(this.appName);
        Integer serverPort = environment.getAgentIdentity().getServerPort();
        if (serverPort != null) {
            identifier.append(':').append(serverPort);
        }
        options.put("identifier", identifier.toString());
        options.put("labels", agentConfig.getLabelsConfig());
        return options;
    }

    private Map<String, Object> getSettings() {
        Map<String, Object> localSettings = ServiceFactory.getConfigService().getSanitizedLocalSettings();
        HashMap<String, Object> settings = new HashMap<String, Object>(localSettings);
        Map<String, String> props = SystemPropertyFactory.getSystemPropertyProvider().getNewRelicSystemProperties();
        if (!props.isEmpty()) {
            settings.put("system", props);
        }
        BrowserMonitoringConfig browserConfig = ServiceFactory.getConfigService().getAgentConfig(this.appName).getBrowserMonitoringConfig();
        settings.put("browser_monitoring.loader", browserConfig.getLoaderType());
        settings.put("browser_monitoring.debug", browserConfig.isDebug());
        String buildDate = AgentJarHelper.getBuildDate();
        if (buildDate != null) {
            settings.put("build_date", buildDate);
        }
        settings.put("services", ServiceFactory.getServicesConfiguration());
        return settings;
    }

    @Override
    public synchronized void launch() throws Exception {
        Map<String, Object> data;
        if (this.isConnected()) {
            return;
        }
        try {
            data = this.dataSender.connect(this.getStartOptions());
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
        Agent.LOG.log(Level.FINER, "Connection response : {0}", data);
        List<String> requiredParams = Arrays.asList(COLLECT_ERRORS_KEY, COLLECT_TRACES_KEY, DATA_REPORT_PERIOD_KEY);
        if (!data.keySet().containsAll(requiredParams)) {
            throw new UnexpectedException(MessageFormat.format("Missing the following connection parameters", requiredParams.removeAll(data.keySet())));
        }
        Agent.LOG.log(Level.INFO, "Agent {0} connected to {1}", this.toString(), this.getHostString());
        try {
            this.logCollectorMessages(data);
        }
        catch (Exception ex) {
            Agent.LOG.log(Level.FINEST, ex, "Error processing collector connect messages");
        }
        AgentConfig config = null;
        if (this.connectionConfigListener != null) {
            config = this.connectionConfigListener.connected(this, data);
        }
        this.connectionTimestamp = System.nanoTime();
        this.connected = true;
        this.hasEverConnected = true;
        if (this.connectionListener != null) {
            config = config != null ? config : ServiceFactory.getConfigService().getDefaultAgentConfig();
            this.connectionListener.connected(this, config);
        }
    }

    private void logCollectorMessages(Map<String, Object> data) {
        List messages = (List)data.get("messages");
        if (messages != null) {
            for (Map message : messages) {
                String level = (String)message.get("level");
                String text = (String)message.get("message");
                if (text.startsWith("Reporting to")) {
                    this.rpmLink = text.substring(14);
                }
                Agent.LOG.log(Level.parse(level), text);
            }
        }
    }

    @Override
    public String getApplicationLink() {
        return this.rpmLink;
    }

    @Override
    public TransactionNamingScheme getTransactionNamingScheme() {
        AgentConfig appConfig = ServiceFactory.getConfigService().getAgentConfig(this.getApplicationName());
        return appConfig.getTransactionNamingScheme();
    }

    private void logForceDisconnectException(ForceDisconnectException e) {
        Agent.LOG.log(Level.SEVERE, "Received a ForceDisconnectException: {0}. The agent is no longer reporting information. If this is not a misconfiguration, please contact support.", e.toString());
    }

    private void shutdownAsync() {
        ServiceFactory.getAgent().shutdownAsync();
    }

    private void logForceRestartException(ForceRestartException e) {
        Agent.LOG.log(Level.SEVERE, "Received a ForceRestartException: {0}. The agent will attempt to reconnect for data reporting. If this message continues, please contact support.", e.toString());
    }

    private void reconnectSync() throws Exception {
        this.disconnect();
        this.launch();
    }

    private void reconnectAsync() {
        this.disconnect();
        ServiceFactory.getRPMConnectionService().connectImmediate(this);
    }

    private void disconnect() {
        this.connected = false;
        this.metricIdRegistry.clear();
    }

    @Override
    public synchronized void reconnect() {
        Agent.LOG.log(Level.INFO, "{0} is reconnecting", this.getApplicationName());
        try {
            this.shutdown();
        }
        catch (Exception exception) {
        }
        finally {
            this.reconnectAsync();
        }
    }

    @Override
    public String getHostString() {
        return MessageFormat.format("{0}:{1}", this.host, Integer.toString(this.port));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ManagementFactory.getRuntimeMXBean().getName());
        builder.append('/').append(this.appName);
        return builder.toString();
    }

    @Override
    public void sendErrorData(List<TracedError> errors) {
        block9: {
            Agent.LOG.log(Level.FINE, "Sending {0} error(s)", errors.size());
            try {
                try {
                    this.dataSender.sendErrorData(errors);
                }
                catch (IgnoreSilentlyException ignoreSilentlyException) {
                }
                catch (ForceRestartException e) {
                    this.logForceRestartException(e);
                    this.reconnectAsync();
                }
                catch (ForceDisconnectException e) {
                    this.logForceDisconnectException(e);
                    this.shutdownAsync();
                }
                catch (HttpError e) {
                    if (e.getStatusCode() == 413) {
                        this.sendErrorData(Lists.newArrayList(errors.subList(0, errors.size() / 2)));
                        break block9;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Error sending error data to New Relic: {0}", e);
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    Agent.LOG.log(Level.FINER, msg, e);
                }
                Agent.LOG.warning(msg);
            }
        }
    }

    @Override
    public List<Long> sendProfileData(List<ProfileData> profiles) throws Exception {
        Agent.LOG.log(Level.INFO, "Sending {0} profile(s)", profiles.size());
        try {
            return this.sendProfileDataSyncRestart(profiles);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private List<Long> sendProfileDataSyncRestart(List<ProfileData> profiles) throws Exception {
        try {
            return this.dataSender.sendProfileData(profiles);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            return this.dataSender.sendProfileData(profiles);
        }
    }

    @Override
    public void sendModules(List<Jar> pJarsToSend) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} module(s)", pJarsToSend.size());
        try {
            this.sendModulesSyncRestart(pJarsToSend);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendModulesSyncRestart(List<Jar> pJarsToSend) throws Exception {
        try {
            this.dataSender.sendModules(pJarsToSend);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendModules(pJarsToSend);
        }
    }

    @Override
    public void sendAnalyticsEvents(int reservoirSize, int eventsSeen, Collection<TransactionEvent> events) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} analytics event(s)", events.size());
        try {
            this.sendAnalyticsEventsSyncRestart(reservoirSize, eventsSeen, events);
        }
        catch (HttpError e) {
            if (e.getStatusCode() != 413 && e.getStatusCode() != 415) {
                throw e;
            }
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendAnalyticsEventsSyncRestart(int reservoirSize, int eventsSeen, Collection<? extends AnalyticsEvent> events) throws Exception {
        try {
            this.dataSender.sendAnalyticsEvents(reservoirSize, eventsSeen, events);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendAnalyticsEvents(reservoirSize, eventsSeen, events);
        }
    }

    @Override
    public void sendCustomAnalyticsEvents(int reservoirSize, int eventsSeen, Collection<? extends CustomInsightsEvent> events) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} analytics event(s)", events.size());
        try {
            this.sendCustomAnalyticsEventsSyncRestart(reservoirSize, eventsSeen, events);
        }
        catch (HttpError e) {
            if (e.getStatusCode() != 413 && e.getStatusCode() != 415) {
                throw e;
            }
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendSpanEventsSyncRestart(int reservoirSize, int eventsSeen, Collection<SpanEvent> events) throws Exception {
        try {
            this.dataSender.sendSpanEvents(reservoirSize, eventsSeen, events);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendSpanEvents(reservoirSize, eventsSeen, events);
        }
    }

    @Override
    public void sendSpanEvents(int reservoirSize, int eventsSeen, Collection<SpanEvent> events) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} span event(s)", events.size());
        try {
            this.sendSpanEventsSyncRestart(reservoirSize, eventsSeen, events);
        }
        catch (HttpError e) {
            if (e.getStatusCode() != 413 && e.getStatusCode() != 415) {
                throw e;
            }
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendCustomAnalyticsEventsSyncRestart(int reservoirSize, int eventsSeen, Collection<? extends CustomInsightsEvent> events) throws Exception {
        try {
            this.dataSender.sendCustomAnalyticsEvents(reservoirSize, eventsSeen, events);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendCustomAnalyticsEvents(reservoirSize, eventsSeen, events);
        }
    }

    @Override
    public void sendErrorEvents(int reservoirSize, int eventsSeen, Collection<ErrorEvent> events) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} error event(s)", events.size());
        try {
            this.sendErrorEventsSyncRestart(reservoirSize, eventsSeen, events);
        }
        catch (HttpError e) {
            if (e.getStatusCode() != 413 && e.getStatusCode() != 415) {
                throw e;
            }
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendErrorEventsSyncRestart(int reservoirSize, int eventsSeen, Collection<ErrorEvent> events) throws Exception {
        try {
            this.dataSender.sendErrorEvents(reservoirSize, eventsSeen, events);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendErrorEvents(reservoirSize, eventsSeen, events);
        }
    }

    @Override
    public void sendSqlTraceData(List<SqlTrace> sqlTraces) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} sql trace(s)", sqlTraces.size());
        try {
            this.sendSqlTraceDataSyncRestart(sqlTraces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendSqlTraceDataSyncRestart(List<SqlTrace> sqlTraces) throws Exception {
        try {
            this.dataSender.sendSqlTraceData(sqlTraces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendSqlTraceData(sqlTraces);
        }
    }

    @Override
    public void sendTransactionTraceData(List<TransactionTrace> traces) throws Exception {
        Agent.LOG.log(Level.FINE, "Sending {0} trace(s)", traces.size());
        try {
            this.sendTransactionTraceDataSyncRestart(traces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendTransactionTraceDataSyncRestart(List<TransactionTrace> traces) throws Exception {
        try {
            this.dataSender.sendTransactionTraceData(traces);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendTransactionTraceData(traces);
        }
    }

    @Override
    public void sendModuleMetadata(Module module) throws Exception {
        this.dataSender.sendModuleMetadata(module);
    }

    @Override
    public void sendInternalCustomEvents(int reservoirSize, int eventsSeen, Collection<BaseInternalCustomEvent> events) throws Exception {
        try {
            this.sendCustomAnalyticsEvents(reservoirSize, eventsSeen, events);
        }
        catch (HttpError e) {
            if (e.getStatusCode() != 413 && e.getStatusCode() != 415) {
                throw e;
            }
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    @Override
    public ErrorService getErrorService() {
        return this.errorService;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public boolean isMainApp() {
        return this.isMainApp;
    }

    public synchronized void shutdown() throws Exception {
        try {
            if (this.isConnected()) {
                this.dataSender.shutdown(System.currentTimeMillis());
            }
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void harvestNow() {
        int MAX_WAIT_SECONDS = 10;
        long end = System.currentTimeMillis() + 10000L;
        boolean done = false;
        Object trouble = null;
        while (!done && System.currentTimeMillis() < end) {
            try {
                RPMService rPMService = this;
                synchronized (rPMService) {
                    if (this.isConnected()) {
                        ServiceFactory.getHarvestService().harvestNow();
                        done = true;
                    }
                }
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                trouble = ex;
            }
        }
        if (trouble != null) {
            Agent.LOG.log(Level.INFO, "Unable to send data to New Relic during JVM shutdown: {0}: {1}", trouble.getClass().getSimpleName(), ((Throwable)trouble).getLocalizedMessage());
        } else if (!done) {
            Agent.LOG.log(Level.INFO, "Unable to send data to New Relic during JVM shutdown: the Agent was unable to connect within the {0} second time limit.", 10);
        }
    }

    @Override
    public List<List<?>> getAgentCommands() throws Exception {
        try {
            return this.getAgentCommandsSyncRestart();
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    @Override
    public Collection<?> getXRaySessionInfo(Collection<Long> newIds) throws Exception {
        try {
            return this.dataSender.getXRayParameters(newIds);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private List<List<?>> getAgentCommandsSyncRestart() throws Exception {
        try {
            return this.dataSender.getAgentCommands();
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            return this.dataSender.getAgentCommands();
        }
    }

    @Override
    public void sendCommandResults(Map<Long, Object> commandResults) throws Exception {
        try {
            this.sendCommandResultsSyncRestart(commandResults);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectAsync();
            throw e;
        }
        catch (ForceDisconnectException e) {
            this.logForceDisconnectException(e);
            this.shutdownAsync();
            throw e;
        }
    }

    private void sendCommandResultsSyncRestart(Map<Long, Object> commandResults) throws Exception {
        try {
            this.dataSender.sendCommandResults(commandResults);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            this.dataSender.sendCommandResults(commandResults);
        }
    }

    public void connect() {
        ServiceFactory.getRPMConnectionService().connect(this);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean hasEverConnected() {
        return this.hasEverConnected;
    }

    @Override
    public void harvest(StatsEngine statsEngine) {
        if (!this.isConnected()) {
            try {
                Agent.LOG.fine("Trying to re-establish connection to New Relic.");
                this.launch();
            }
            catch (Exception e) {
                Agent.LOG.fine("Problem trying to re-establish connection to New Relic: " + e.getMessage());
            }
        }
        if (this.isConnected()) {
            long reportInterval;
            long startTime;
            List<MetricData> data;
            boolean retry;
            block20: {
                retry = false;
                if (this.metricIdRegistry.getSize() > 1000) {
                    statsEngine.getStats("Agent/Metrics/Count").setCallCount(this.metricIdRegistry.getSize());
                }
                Normalizer metricNormalizer = ServiceFactory.getNormalizationService().getMetricNormalizer(this.appName);
                data = statsEngine.getMetricData(metricNormalizer, this.metricIdRegistry);
                startTime = System.nanoTime();
                reportInterval = 0L;
                try {
                    long now = System.currentTimeMillis();
                    List<List<?>> responseList = this.sendMetricDataSyncRestart(this.lastReportTime, now, data);
                    reportInterval = now - this.lastReportTime;
                    this.lastReportTime = now;
                    this.registerMetricIds(responseList);
                    this.last503Error.set(0);
                    if (this.retryCount.get() > 0) {
                        Agent.LOG.log(Level.INFO, "Successfully reconnected to the New Relic data service.");
                    }
                    Agent.LOG.log(Level.FINE, "Reported {0} timeslices for {1}", data.size(), this.getApplicationName());
                }
                catch (InternalLimitExceeded e) {
                    Agent.LOG.log(Level.SEVERE, "The metric data post was too large.  {0} timeslices will not be resent", data.size());
                }
                catch (MetricDataException e) {
                    Agent.LOG.log(Level.SEVERE, "An invalid response was received while sending metric data. This data will not be resent.");
                    Agent.LOG.log(Level.FINEST, e, e.toString());
                }
                catch (HttpError e) {
                    retry = e.isRetryableError();
                    if (503 == e.getStatusCode()) {
                        this.handle503Error(e);
                    } else if (retry) {
                        Agent.LOG.log(Level.INFO, "An error occurred posting metric data - {0}.  This data will be resent later.", e.getMessage());
                    } else {
                        Agent.LOG.log(Level.SEVERE, "An error occurred posting metric data - {0}.  {1} timeslices will not be resent.", e.getMessage(), data.size());
                    }
                }
                catch (ForceRestartException e) {
                    this.logForceRestartException(e);
                    this.reconnectAsync();
                    retry = true;
                }
                catch (ForceDisconnectException e) {
                    this.logForceDisconnectException(e);
                    this.shutdownAsync();
                }
                catch (HttpHostConnectException e) {
                    retry = true;
                    Agent.LOG.log(Level.INFO, "A connection error occurred contacting {0}.  Please check your network / proxy settings.", e.getHost());
                    Agent.LOG.log(Level.FINEST, e, e.toString());
                }
                catch (Exception e) {
                    this.logMetricDataError(e);
                    retry = true;
                    String message = e.getMessage().toLowerCase();
                    if (!message.contains("json") || !message.contains("parse")) break block20;
                    retry = false;
                }
            }
            long duration = System.nanoTime() - startTime;
            if (retry) {
                this.retryCount.getAndIncrement();
            } else {
                this.retryCount.set(0);
                statsEngine.clear();
                this.recordSupportabilityMetrics(statsEngine, reportInterval, duration, data.size());
            }
        }
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long reportInterval, long duration, int dataSize) {
        if (reportInterval > 0L) {
            statsEngine.getResponseTimeStats("Supportability/MetricHarvest/interval").recordResponseTime(reportInterval, TimeUnit.MILLISECONDS);
        }
        statsEngine.getResponseTimeStats("Supportability/MetricHarvest/transmit").recordResponseTime(duration, TimeUnit.NANOSECONDS);
        statsEngine.getStats("Supportability/MetricHarvest/count").incrementCallCount(dataSize);
    }

    private List<List<?>> sendMetricDataSyncRestart(long beginTimeMillis, long endTimeMillis, List<MetricData> metricData) throws Exception {
        try {
            return this.dataSender.sendMetricData(beginTimeMillis, endTimeMillis, metricData);
        }
        catch (ForceRestartException e) {
            this.logForceRestartException(e);
            this.reconnectSync();
            return this.dataSender.sendMetricData(beginTimeMillis, endTimeMillis, metricData);
        }
    }

    private void registerMetricIds(List<List<?>> responseList) {
        for (List<?> response : responseList) {
            JSONObject jsonObj = (JSONObject)JSONObject.class.cast(response.get(0));
            MetricName metricName = MetricName.parseJSON(jsonObj);
            Long id = (Long)Long.class.cast(response.get(1));
            this.metricIdRegistry.setMetricId(metricName, id.intValue());
        }
    }

    private void logMetricDataError(Exception e) {
        Agent.LOG.log(Level.INFO, "An unexpected error occurred sending metric data to New Relic.  Please file a support ticket once you have seen several of these messages in a short period of time: {0}", e.toString());
        Agent.LOG.log(Level.FINEST, e, e.toString());
    }

    private void handle503Error(Exception e) {
        String msg = "A 503 (Unavailable) response was received while sending metric data to New Relic.  The agent will continue to aggregate data and report it in the next time period.";
        if (this.last503Error.getAndIncrement() == 5) {
            Agent.LOG.info(msg);
            Agent.LOG.log(Level.FINEST, e, e.toString());
        } else {
            Agent.LOG.log(Level.FINER, msg, e);
        }
    }

    @Override
    protected void doStop() {
        this.removeHarvestablesFromServices(this.appName);
        this.errorService.stop();
        try {
            this.shutdown();
        }
        catch (Exception e) {
            Level level = e instanceof ConnectException ? Level.FINER : Level.SEVERE;
            Agent.LOG.log(level, "An error occurred in the NewRelic agent shutdown", e);
        }
        ServiceFactory.getEnvironmentService().getEnvironment().removeEnvironmentChangeListener(this);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
        ServiceFactory.getServiceManager().getCircuitBreakerService().removeRPMService(this);
    }

    private void removeHarvestablesFromServices(String appName) {
        ServiceFactory.getHarvestService().removeHarvestablesByAppName(appName);
    }

    @Override
    public long getConnectionTimestamp() {
        return this.connectionTimestamp;
    }

    @Override
    public void agentIdentityChanged(AgentIdentity agentIdentity) {
        if (this.connected) {
            this.logger.log(Level.FINE, "Reconnecting after an environment change");
            this.reconnect();
        }
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.last503Error.set(0);
    }
}

