/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.Map;

public class SpanEventsConfig
extends BaseConfig {
    public static final int DEFAULT_MAX_SPAN_EVENTS_PER_HARVEST = 1000;
    public static final int DEFAULT_TARGET_SAMPLES_STORED = 10;
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_CROSS_PROCESS_ONLY = false;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.span_events.";
    public static final String MAX_SAMPLES_STORED = "max_samples_stored";
    private static final String ENABLED = "enabled";
    private static final String TARGET_SAMPLES_STORED = "target_samples_stored";
    private static final String CROSS_PROCESS_ONLY = "cross_process_only";
    private final int maxSamplesStored;
    private final boolean enabled;
    private final int targetSamplesStored;
    private final boolean crossProcessOnly;

    public SpanEventsConfig(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.maxSamplesStored = 1000;
        this.enabled = this.initEnabled(this.maxSamplesStored);
        this.targetSamplesStored = this.getProperty(TARGET_SAMPLES_STORED, 10);
        this.crossProcessOnly = this.getProperty(CROSS_PROCESS_ONLY, false);
    }

    private boolean initEnabled(int maxSamplesStored) {
        Boolean configEnabled = this.getProperty(ENABLED, false);
        return maxSamplesStored > 0 && configEnabled != false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    public int getTargetSamplesStored() {
        return this.targetSamplesStored;
    }

    public boolean isCrossProcessOnly() {
        return this.crossProcessOnly;
    }
}

