/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.util.Strings;
import java.sql.ResultSetMetaData;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDatabaseStatementParser
implements DatabaseStatementParser {
    private static final int PATTERN_SWITCHES = 34;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern NR_HINT_PATTERN = Pattern.compile("\\s*/\\*\\s*nrhint\\s*:\\s*([^\\*]*)\\s*\\*/\\s*([^\\s]*).*", 32);
    private static final Pattern VALID_METRIC_NAME_MATCHER = Pattern.compile("[a-zA-Z0-9.$_@]+");
    private static final Pattern FROM_MATCHER = Pattern.compile("\\s+from\\s+", 34);
    private static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*select.*?\\sfrom[\\s\\[]+([^\\]\\s,)(;]*).*", 34);
    private static final Pattern EXEC_VAR_PATTERN = Pattern.compile(".*(?:exec|execute)\\s+[^\\s(,]*.*?=(?:\\s|)([^\\s]*)", 34);
    private final Set<String> knownOperations;
    private final List<StatementFactory> statementFactories;
    private final boolean reportSqlParserErrors;
    private final StatementFactory selectStatementFactory = new DefaultStatementFactory("select", SELECT_PATTERN, true);

    public DefaultDatabaseStatementParser(AgentConfig agentConfig) {
        this.reportSqlParserErrors = agentConfig.isReportSqlParserErrors();
        this.statementFactories = Arrays.asList(new InnerSelectStatementFactory(), new DefaultStatementFactory("show", Pattern.compile("^\\s*show\\s+(.*)$", 34), false){

            @Override
            protected boolean isValidModelName(String name) {
                return true;
            }
        }, new DefaultStatementFactory("insert", Pattern.compile("^\\s*insert(?:\\s+ignore)?(?:\\s+into)?\\s+([^\\s(,;]*).*", 34), true), new DefaultStatementFactory("update", Pattern.compile("^\\s*update\\s+([^\\s,;]*).*", 34), true), new DefaultStatementFactory("delete", Pattern.compile("^\\s*delete\\s*?.*?\\s+from\\s+([^\\s,(;]*).*", 34), true), new DDLStatementFactory("create", Pattern.compile("^\\s*create\\s+procedure.*", 34), "Procedure"), new SelectVariableStatementFactory(), new DDLStatementFactory("drop", Pattern.compile("^\\s*drop\\s+procedure.*", 34), "Procedure"), new DDLStatementFactory("create", Pattern.compile("^\\s*create\\s+table.*", 34), "Table"), new DDLStatementFactory("drop", Pattern.compile("^\\s*drop\\s+table.*", 34), "Table"), new DefaultStatementFactory("alter", Pattern.compile("^\\s*alter\\s+([^\\s]*).*", 34), false), new DefaultStatementFactory("call", Pattern.compile(".*call\\s+([^\\s(,]*).*", 34), true), new DefaultStatementFactory("exec", Pattern.compile(".*(?:exec|execute)\\s+(?!as\\s+)([^\\s(,=;]*+);?\\s*+(?:[^=]|$).*", 34), true, EXEC_VAR_PATTERN), new DefaultStatementFactory("set", Pattern.compile("^\\s*set\\s+(.*)\\s*(as|=).*", 34), false));
        this.knownOperations = new HashSet<String>();
        for (StatementFactory factory : this.statementFactories) {
            this.knownOperations.add(factory.getOperation());
        }
    }

    @Override
    public ParsedDatabaseStatement getParsedDatabaseStatement(DatabaseVendor databaseVendor, String statement, ResultSetMetaData metaData) {
        Matcher hintMatcher = NR_HINT_PATTERN.matcher(statement);
        if (hintMatcher.matches()) {
            String model = hintMatcher.group(1).trim().toLowerCase();
            String operation = hintMatcher.group(2).toLowerCase();
            if (!this.knownOperations.contains(operation)) {
                operation = "unknown";
            }
            return new ParsedDatabaseStatement(model, operation, true);
        }
        if (metaData != null) {
            try {
                String tableName;
                int columnCount = metaData.getColumnCount();
                if (columnCount > 0 && !Strings.isEmpty(tableName = metaData.getTableName(1))) {
                    return new ParsedDatabaseStatement(tableName.toLowerCase(), "select", true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.parseStatement(statement);
    }

    ParsedDatabaseStatement parseStatement(String statement) {
        try {
            statement = COMMENT_PATTERN.matcher(statement).replaceAll("");
            for (StatementFactory factory : this.statementFactories) {
                ParsedDatabaseStatement parsedStatement = factory.parseStatement(statement);
                if (parsedStatement == null) continue;
                return parsedStatement;
            }
            Agent.LOG.log(Level.FINE, "Returning UNPARSEABLE_STATEMENT for statement: {0}", statement);
            return UNPARSEABLE_STATEMENT;
        }
        catch (Throwable t) {
            Agent.LOG.fine(MessageFormat.format("Unable to parse sql \"{0}\" - {1}", statement, t.toString()));
            Agent.LOG.log(Level.FINER, "SQL parsing error", t);
            Agent.LOG.log(Level.FINE, t, "Returning UNPARSEABLE_STATEMENT for statement: {0}", statement);
            return UNPARSEABLE_STATEMENT;
        }
    }

    static boolean isValidName(String string) {
        return VALID_METRIC_NAME_MATCHER.matcher(string).matches();
    }

    private class DDLStatementFactory
    extends DefaultStatementFactory {
        private final String type;

        public DDLStatementFactory(String key, Pattern pattern, String type) {
            super(key, pattern, false);
            this.type = type;
        }

        @Override
        ParsedDatabaseStatement createParsedDatabaseStatement(String model) {
            return new ParsedDatabaseStatement(this.type, this.key, this.isMetricGenerator());
        }
    }

    private class InnerSelectStatementFactory
    implements StatementFactory {
        private final Pattern innerSelectPattern = Pattern.compile("^\\s*SELECT.*?\\sFROM\\s*\\(\\s*(SELECT.*)", 34);

        private InnerSelectStatementFactory() {
        }

        @Override
        public ParsedDatabaseStatement parseStatement(String statement) {
            String res2;
            String sql = statement;
            String res = null;
            while ((res2 = this.findMatch(sql)) != null) {
                res = res2;
                sql = res2;
            }
            if (res != null) {
                return DefaultDatabaseStatementParser.this.selectStatementFactory.parseStatement(res);
            }
            return DefaultDatabaseStatementParser.this.selectStatementFactory.parseStatement(statement);
        }

        private String findMatch(String statement) {
            Matcher matcher = this.innerSelectPattern.matcher(statement);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return null;
        }

        @Override
        public String getOperation() {
            return "select";
        }
    }

    private class SelectVariableStatementFactory
    implements StatementFactory {
        private final ParsedDatabaseStatement innerSelectStatement = new ParsedDatabaseStatement("INNER_SELECT", "select", false);
        private final ParsedDatabaseStatement statement = new ParsedDatabaseStatement("VARIABLE", "select", false);
        private final Pattern pattern = Pattern.compile(".*select\\s+([^\\s,]*).*", 34);

        private SelectVariableStatementFactory() {
        }

        @Override
        public ParsedDatabaseStatement parseStatement(String statement) {
            Matcher matcher = this.pattern.matcher(statement);
            if (matcher.matches()) {
                if (FROM_MATCHER.matcher(statement).find()) {
                    return this.innerSelectStatement;
                }
                return this.statement;
            }
            return null;
        }

        @Override
        public String getOperation() {
            return "select";
        }
    }

    class DefaultStatementFactory
    implements StatementFactory {
        private final Pattern pattern;
        private final DefaultStatementFactory backupPattern;
        protected final String key;
        private final boolean generateMetric;

        public DefaultStatementFactory(String key, Pattern pattern, boolean generateMetric) {
            this.key = key;
            this.pattern = pattern;
            this.generateMetric = generateMetric;
            this.backupPattern = null;
        }

        public DefaultStatementFactory(String key, Pattern pattern, boolean generateMetric, Pattern backupPattern) {
            this.key = key;
            this.pattern = pattern;
            this.generateMetric = generateMetric;
            this.backupPattern = new DefaultStatementFactory(key, backupPattern, generateMetric);
        }

        protected boolean isMetricGenerator() {
            return this.generateMetric;
        }

        @Override
        public ParsedDatabaseStatement parseStatement(String statement) {
            if (!Strings.containsIgnoreCase(statement, this.key)) {
                return null;
            }
            Matcher matcher = this.pattern.matcher(statement);
            if (matcher.find()) {
                String model;
                String string = model = matcher.groupCount() > 0 ? matcher.group(1).trim() : "unknown";
                if (model.length() == 0) {
                    Agent.LOG.log(Level.FINE, MessageFormat.format("Parsed an empty model name for {0} statement : {1}", this.key, statement));
                    return null;
                }
                model = Strings.unquoteDatabaseName(model);
                model = Strings.removeBrackets(model);
                if (this.generateMetric && !this.isValidModelName(model)) {
                    if (DefaultDatabaseStatementParser.this.reportSqlParserErrors) {
                        Agent.LOG.log(Level.FINE, MessageFormat.format("Parsed an invalid model name {0} for {1} statement : {2}", model, this.key, statement));
                    }
                    model = "ParseError";
                }
                return this.createParsedDatabaseStatement(model);
            }
            if (this.backupPattern != null) {
                return this.backupPattern.parseStatement(statement);
            }
            return null;
        }

        protected boolean isValidModelName(String name) {
            return DefaultDatabaseStatementParser.isValidName(name);
        }

        ParsedDatabaseStatement createParsedDatabaseStatement(String model) {
            return new ParsedDatabaseStatement(model.toLowerCase(), this.key, this.generateMetric);
        }

        @Override
        public String getOperation() {
            return this.key;
        }
    }

    private static interface StatementFactory {
        public String getOperation();

        public ParsedDatabaseStatement parseStatement(String var1);
    }
}

